/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.util;

import com.ibm.commons.util.DateTime;
import com.ibm.commons.util.StringUtil;
import com.ibm.commons.xml.XMLException;
import com.ibm.commons.xml.util.DateStringParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.TimeZone;

public class XMIConverter {
    private static int[] pow10 = new int[]{100000, 10000, 1000, 100, 10, 1};

    public static char parseChar(String s) {
        return s.length() > 0 ? s.charAt(0) : (char)'\u0000';
    }

    public static char parseChar(String s, String def) {
        return XMIConverter.parseChar(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static String toString(char value) {
        return value != '\u0000' ? new String(new char[]{value}) : "";
    }

    public static byte parseByte(String s) {
        if (!StringUtil.isEmpty((String)s)) {
            try {
                return Byte.parseByte(s);
            }
            catch (NumberFormatException numberFormatException) {
                return (byte)Double.parseDouble(s);
            }
        }
        return 0;
    }

    public static byte parseByte(String s, String def) {
        return XMIConverter.parseByte(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static String toString(byte value) {
        return StringUtil.toString((byte)value);
    }

    public static short parseShort(String s) {
        if (!StringUtil.isEmpty((String)s)) {
            try {
                return Short.parseShort(s);
            }
            catch (NumberFormatException numberFormatException) {
                return (short)Double.parseDouble(s);
            }
        }
        return 0;
    }

    public static short parseShort(String s, String def) {
        return XMIConverter.parseShort(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static String toString(short value) {
        return StringUtil.toString((short)value);
    }

    public static int parseInteger(String s) {
        if (!StringUtil.isEmpty((String)s)) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                return (int)Double.parseDouble(s);
            }
        }
        return 0;
    }

    public static int parseInteger(String s, String def) {
        return XMIConverter.parseInteger(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static String toString(int value) {
        return StringUtil.toString((int)value);
    }

    public static long parseLong(String s) {
        if (!StringUtil.isEmpty((String)s)) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException numberFormatException) {
                return (long)Double.parseDouble(s);
            }
        }
        return 0L;
    }

    public static long parseLong(String s, String def) {
        return XMIConverter.parseLong(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static String toString(long value) {
        return StringUtil.toString((long)value);
    }

    public static float parseFloat(String s) {
        if (!StringUtil.isEmpty((String)s)) {
            try {
                return Float.parseFloat(s);
            }
            catch (NumberFormatException numberFormatException) {
                if (StringUtil.equals((String)s, (String)"NaN")) {
                    return Float.NaN;
                }
                return (float)Double.parseDouble(s);
            }
        }
        return 0.0f;
    }

    public static float parseFloat(String s, String def) {
        return XMIConverter.parseFloat(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static String toString(float value) {
        return StringUtil.toString((float)value);
    }

    public static double parseDouble(String s) {
        block3: {
            if (!StringUtil.isEmpty((String)s)) {
                try {
                    return Double.parseDouble(s);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!StringUtil.equals((String)s, (String)"NaN")) break block3;
                    return Double.NaN;
                }
            }
        }
        return 0.0;
    }

    public static double parseDouble(String s, String def) {
        return XMIConverter.parseDouble(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static String toString(double value) {
        String s = Double.toString(value);
        if (s.indexOf(101) > 0 || s.indexOf(69) > 0) {
            return new BigDecimal(s).toString();
        }
        return s;
    }

    public static BigInteger parseBigInteger(String s) {
        return StringUtil.isEmpty((String)s) ? new BigInteger("0") : new BigInteger(s);
    }

    public static BigInteger parseBigInteger(String s, String def) {
        return XMIConverter.parseBigInteger(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static String toString(BigInteger value) {
        return StringUtil.toString((Object)value);
    }

    public static BigDecimal parseBigDecimal(String s) {
        return StringUtil.isEmpty((String)s) ? new BigDecimal("0.0") : new BigDecimal(s);
    }

    public static BigDecimal parseBigDecimal(String s, String def) {
        return XMIConverter.parseBigDecimal(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static String toString(BigDecimal value) {
        if (value != null) {
            String s = value.toString();
            int trailingZero = 0;
            int scale = value.scale();
            int i = 0;
            while (i < scale) {
                if (s.charAt(s.length() - i - 1) != '0') break;
                ++trailingZero;
                ++i;
            }
            if (trailingZero > 0) {
                return s.substring(0, s.length() - trailingZero);
            }
            return s;
        }
        return "";
    }

    public static boolean parseBoolean(String s) {
        if (StringUtil.isEmpty((String)s)) {
            return false;
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new NumberFormatException(StringUtil.format((String)"Invalid Boolean format", (Object[])new Object[]{s}));
    }

    public static boolean parseBoolean(String s, String def) {
        return XMIConverter.parseBoolean(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static String toString(boolean value) {
        return value ? "true" : "false";
    }

    public static java.util.Date parseUtilDate(String s) {
        String CURRENT_DATE_TIME = "now";
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        if (StringUtil.equalsIgnoreCase((String)s, (String)CURRENT_DATE_TIME)) {
            java.util.Date nowResult = new java.util.Date();
            return nowResult;
        }
        try {
            java.util.Date result = XMIConverter.readXMIDate(s, java.util.Date.class);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            try {
                long resultTime = XMIConverter.readXMIDateStrict(s, false, false);
                if (resultTime > 0L) {
                    java.util.Date nowResult = new java.util.Date();
                    return nowResult;
                }
            }
            catch (Exception exception2) {}
        }
        return null;
    }

    public static Date parseDate(String s) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        try {
            Date result = (Date)XMIConverter.readXMIDate(s, Date.class);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static Date parseDate(String s, String def) {
        return XMIConverter.parseDate(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static String toString(java.util.Date value) {
        if (value == null) {
            return "";
        }
        return XMIConverter.composeDate(value.getTime());
    }

    public static Time parseTime(String s) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        try {
            Time result = (Time)XMIConverter.readXMIDate(s, Time.class);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static Time parseTime(String s, String def) {
        return XMIConverter.parseTime(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static Timestamp parseTimestamp(String s) {
        if (StringUtil.isEmpty((String)s)) {
            return null;
        }
        try {
            Timestamp result = (Timestamp)XMIConverter.readXMIDate(s, Timestamp.class);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static Timestamp parseTimestamp(String s, String def) {
        return XMIConverter.parseTimestamp(StringUtil.isEmpty((String)s) ? def : s);
    }

    public static java.util.Date readXMIDate(String s, Class javaClass) throws XMLException {
        long xmlDate = XMIConverter.readXMIDate(s);
        if (xmlDate != Long.MIN_VALUE) {
            if (javaClass == java.util.Date.class) {
                return new java.util.Date(xmlDate);
            }
            if (javaClass == Date.class) {
                return new Date(xmlDate);
            }
            if (javaClass == Time.class) {
                return new Time(xmlDate);
            }
            if (javaClass == Timestamp.class) {
                return new Timestamp(xmlDate);
            }
        }
        return null;
    }

    public static long readXMIDate(String s) throws XMLException {
        return XMIConverter.readXMIDateStrict(s, true);
    }

    public static long readXMIDateStrict(String s, boolean strict) throws XMLException {
        return XMIConverter.readXMIDateStrict(s, strict, false);
    }

    public static long readXMIDateStrict(String s, boolean strict, boolean ignoreTz) throws XMLException {
        boolean tzIndication = false;
        boolean tzSignPlus = false;
        int h2 = 0;
        int m2 = 0;
        DateStringParser parser = new DateStringParser(s);
        int year = 1970;
        int month = 1;
        int day = 1;
        if (!parser.startsWith('T')) {
            year = parser.matchInteger(4);
            if (year == Integer.MIN_VALUE) {
                XMIConverter.throwBadDateException(s);
            }
            if (!parser.match('-')) {
                XMIConverter.throwBadDateException(s);
            }
            if ((month = parser.matchInteger(2)) == Integer.MIN_VALUE) {
                XMIConverter.throwBadDateException(s);
            }
            if (!parser.match('-')) {
                XMIConverter.throwBadDateException(s);
            }
            if ((day = parser.matchInteger(2)) == Integer.MIN_VALUE) {
                XMIConverter.throwBadDateException(s);
            }
        } else if (strict) {
            XMIConverter.throwBadDateException(s);
        }
        int hour = 12;
        int minute = 0;
        int second = 0;
        if (parser.match('T')) {
            hour = parser.matchInteger(2);
            if (hour == Integer.MIN_VALUE) {
                XMIConverter.throwBadDateException(s);
            }
            if (!parser.match(':')) {
                XMIConverter.throwBadDateException(s);
            }
            if ((minute = parser.matchInteger(2)) == Integer.MIN_VALUE) {
                XMIConverter.throwBadDateException(s);
            }
            if (!parser.match(':')) {
                XMIConverter.throwBadDateException(s);
            }
            if ((second = parser.matchInteger(2)) == Integer.MIN_VALUE) {
                XMIConverter.throwBadDateException(s);
            }
            if (parser.match('.')) {
                int ndigits;
                int ptr = parser.getCurrentPosition();
                int frac = parser.getNextInteger();
                if (frac == Integer.MIN_VALUE) {
                    XMIConverter.throwBadDateException(s);
                }
                if ((ndigits = parser.getCurrentPosition() - ptr) < 6) {
                    int cfr_ignored_0 = frac * pow10[ndigits];
                }
            }
            if (parser.match('Z')) {
                tzIndication = true;
            } else {
                tzSignPlus = parser.match('+');
                if (parser.match('-') || tzSignPlus) {
                    tzIndication = true;
                    h2 = parser.matchInteger(2);
                    if (h2 == Integer.MIN_VALUE) {
                        XMIConverter.throwBadDateException(s);
                    }
                    parser.match(':');
                    m2 = parser.matchInteger(2);
                    if (m2 == Integer.MIN_VALUE) {
                        XMIConverter.throwBadDateException(s);
                    }
                }
            }
        } else if (strict) {
            XMIConverter.throwBadDateException(s);
        }
        if (!parser.isEOF()) {
            XMIConverter.throwBadDateException(s);
        }
        DateTime.TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
        try {
            long serverOffsetIndication;
            long xmlOffsetindication;
            gregorianCalendar.set(year, month - 1, day, hour, minute, second);
            gregorianCalendar.set(14, 0);
            long xmlDate = gregorianCalendar.getMillis();
            if (tzIndication && !ignoreTz && (xmlOffsetindication = tzSignPlus ? (long)(h2 * 60 * 60 * 1000 + m2 * 60 * 1000) : (long)(-h2 * 60 * 60 * 1000 - m2 * 60 * 1000)) != (serverOffsetIndication = (long)TimeZone.getDefault().getRawOffset())) {
                xmlDate = xmlDate - xmlOffsetindication + serverOffsetIndication;
            }
            long l = xmlDate;
            return l;
        }
        finally {
            DateTime.recycleCalendar((DateTime.TGregorianCalendar)gregorianCalendar, (boolean)false);
        }
    }

    private static void throwBadDateException(String dateString) throws XMLException {
        throw new XMLException(null, "Invalid XMI date format {0}", dateString);
    }

    public static String composeDate(long date) {
        DateTime.TGregorianCalendar gregorianCalendar = DateTime.getCalendar();
        try {
            gregorianCalendar.setMillis(date);
            int year = gregorianCalendar.get(1);
            int month = gregorianCalendar.get(2) + 1;
            int day = gregorianCalendar.get(5);
            int hour = gregorianCalendar.get(11);
            int minute = gregorianCalendar.get(12);
            int second = gregorianCalendar.get(13);
            String string = XMIConverter.composeDate(year, month, day, hour, minute, second);
            return string;
        }
        finally {
            DateTime.recycleCalendar((DateTime.TGregorianCalendar)gregorianCalendar, (boolean)false);
        }
    }

    public static String composeDate(int year, int month, int day, int hour, int minute, int second) {
        return XMIConverter.composeDate(year, month, day, hour, minute, second, true);
    }

    public static String composeDate(int year, int month, int day, int hour, int minute, int second, boolean addTZIndication) {
        StringBuffer sb = new StringBuffer();
        XMIConverter.appendInt(sb, year, 4);
        sb.append('-');
        XMIConverter.appendInt(sb, month, 2);
        sb.append('-');
        XMIConverter.appendInt(sb, day, 2);
        sb.append('T');
        XMIConverter.appendInt(sb, hour, 2);
        sb.append(':');
        XMIConverter.appendInt(sb, minute, 2);
        sb.append(':');
        XMIConverter.appendInt(sb, second, 2);
        if (addTZIndication) {
            sb.append(XMIConverter.composeServerTZOffset());
        }
        return sb.toString();
    }

    public static String composeServerTZOffset() {
        int offset = TimeZone.getDefault().getRawOffset();
        if (offset == 0) {
            return "Z";
        }
        StringBuffer sb = new StringBuffer();
        int h = offset / 3600000;
        int min = (offset - h * 60 * 60 * 1000) / 60000;
        if (offset > 0) {
            sb.append('+');
            XMIConverter.appendInt(sb, h, 2);
            sb.append(':');
            XMIConverter.appendInt(sb, min, 2);
        } else if (offset < 0) {
            sb.append('-');
            XMIConverter.appendInt(sb, -h, 2);
            sb.append(':');
            XMIConverter.appendInt(sb, -min, 2);
        }
        return sb.toString();
    }

    private static void appendInt(StringBuffer sb, int v, int size) {
        String s = Integer.toString(v);
        switch (size - s.length()) {
            case 1: {
                sb.append("0");
                break;
            }
            case 2: {
                sb.append("00");
                break;
            }
            case 3: {
                sb.append("000");
            }
        }
        sb.append(s);
    }
}

