/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.xpath;

import com.ibm.commons.util.StringUtil;
import com.ibm.commons.xml.NamespaceContext;
import com.ibm.commons.xml.XResult;
import com.ibm.commons.xml.xpath.AbstractExpression;
import com.ibm.commons.xml.xpath.XPathException;
import com.ibm.commons.xml.xpath.part.Part;
import com.ibm.commons.xml.xpath.xml.Utils;
import java.util.ArrayList;

public abstract class AbstractSimpleExpression
extends AbstractExpression {
    protected boolean _isFromRoot;
    protected Part[] _parts;

    public AbstractSimpleExpression(String expression, boolean isFromRoot, Part[] parts) {
        super(expression);
        this._isFromRoot = isFromRoot;
        this._parts = parts;
    }

    @Override
    public boolean isFromRoot() {
        return this._isFromRoot;
    }

    public int getPartCount() {
        return this._parts != null ? this._parts.length : 0;
    }

    public Part getPart(int index) {
        return this._parts != null ? this._parts[index] : null;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    protected XResult doEval(Object node, NamespaceContext namespaceContext) throws XPathException {
        try {
            int count;
            if (this.isFromRoot()) {
                node = this.getRootNode(node);
            }
            namespaceContext = this.resolveNamespaceContext(node, namespaceContext);
            int n = count = this._parts != null ? this._parts.length : 0;
            if (count == 0 && StringUtil.isEmpty((String)this.getExpression())) {
                throw new XPathException(null, "Incorrect XPATH: Empty text was provided");
            }
            int pos = 0;
            while (pos < count && node != null) {
                node = this.evaluatePart(node, this._parts[pos], namespaceContext);
                ++pos;
            }
            return this.wrapUp(node);
        }
        catch (Exception e) {
            throw new XPathException(e);
        }
    }

    @Override
    protected void doSetValue(Object node, Object value, NamespaceContext namespaceContext, boolean autoCreate) throws XPathException {
        if (this.isFromRoot()) {
            node = this.getRootNode(node);
        }
        Object curObject = node;
        Object prevObject = null;
        try {
            if (!this.isValid(node)) {
                throw new XPathException(null, "Incorrect node type for evaluation:" + node.getClass());
            }
            if (this.getPartCount() == 0 && StringUtil.isEmpty((String)this.getExpression())) {
                throw new XPathException(null, "Incorrect XPATH: Empty text was provided");
            }
            namespaceContext = this.resolveNamespaceContext(node, namespaceContext);
            Part currentPart = null;
            int currentPos = 0;
            while (this.getPartCount() > currentPos) {
                currentPart = this.getPart(currentPos);
                ++currentPos;
                prevObject = curObject;
                if ((curObject = this.evaluatePart(curObject, currentPart, namespaceContext)) == null) {
                    if (autoCreate) {
                        curObject = this.createPart(prevObject, currentPart, namespaceContext);
                    } else {
                        throw new XPathException(null, "Evaluation error for " + currentPart.toString() + " of the XPATH:" + this.getExpression());
                    }
                }
                if (this.isValid(curObject)) continue;
                throw new XPathException(null, "Incorrect node type for evaluation:" + node.getClass());
            }
            String strValue = Utils.getAsString(value);
            this.setNodeValue(curObject, strValue);
        }
        catch (Exception e) {
            throw new XPathException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Object doCreateNodes(Object node, NamespaceContext namespaceContext) throws XPathException {
        if (this.isFromRoot()) {
            node = this.getRootNode(node);
        }
        created = new ArrayList<Object>();
        curObject = node;
        try {
            if (!this.isValid(node)) {
                throw new XPathException(null, "Incorrect node type for evaluation:" + node.getClass());
            }
            if (this.getPartCount() == 0 && StringUtil.isEmpty((String)this.getExpression())) {
                throw new XPathException(null, "Incorrect XPATH: Empty text was provided");
            }
            namespaceContext = this.resolveNamespaceContext(node, namespaceContext);
            currentPart = null;
            currentPos = 0;
            while (this.getPartCount() > currentPos) {
                currentPart = this.getPart(currentPos);
                ++currentPos;
                evalObject = this.evaluatePart(curObject, currentPart, namespaceContext);
                if (evalObject == null && (evalObject = this.createPart(curObject, currentPart, namespaceContext)) != null) {
                    created.add(evalObject);
                }
                curObject = evalObject;
            }
            return curObject;
        }
        catch (Exception e) {
            iter = created.iterator();
            ** while (iter.hasNext())
        }
lbl-1000:
        // 1 sources

        {
            this.deletePart(iter.next(), null);
            continue;
        }
lbl28:
        // 1 sources

        throw new XPathException(e);
    }

    public abstract Object getRootNode(Object var1);

    protected abstract Object createPart(Object var1, Part var2, NamespaceContext var3) throws XPathException;

    protected abstract void setNodeValue(Object var1, Object var2) throws XPathException;

    protected abstract void deletePart(Object var1, Part var2);

    protected abstract Object evaluatePart(Object var1, Part var2, NamespaceContext var3) throws XPathException;

    public abstract XResult wrapUp(Object var1) throws XPathException;
}

