/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.xpath.xml;

import com.ibm.commons.util.StringUtil;
import com.ibm.commons.xml.DOMUtil;
import com.ibm.commons.xml.NamespaceContext;
import com.ibm.commons.xml.util.XMIConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Utils {
    public static NamespaceContext resolveNamespaceContext(Node node, NamespaceContext nsContext) {
        if (nsContext != null) {
            return nsContext;
        }
        if (node == null) {
            return null;
        }
        Document document = DOMUtil.getOwnerDocument(node);
        nsContext = DOMUtil.getSelectionNamespaces(document);
        if (nsContext != null) {
            return nsContext;
        }
        nsContext = Utils.getNamespaceContext(document.getDocumentElement());
        return nsContext;
    }

    public static NamespaceContext getNamespaceContext(final Element docElement) {
        return new NamespaceContext(){

            @Override
            public String getNamespaceURI(String prefix) {
                if (docElement == null) {
                    return null;
                }
                return docElement.getAttribute(Utils.getNamespaceAttribute(prefix));
            }

            @Override
            public String getPrefix(String namespaceURI) {
                if (docElement == null) {
                    return null;
                }
                NamedNodeMap attrs = docElement.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Attr attr = (Attr)attrs.item(i);
                    if (namespaceURI.equals(attr.getNodeValue())) {
                        return attr.getLocalName();
                    }
                    ++i;
                }
                return null;
            }

            @Override
            public Iterator getPrefixes(String namespaceURI) {
                if (docElement == null) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ArrayList<String> prefixes = new ArrayList<String>();
                NamedNodeMap attrs = docElement.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Attr attr = (Attr)attrs.item(i);
                    if (namespaceURI.equals(attr.getNodeValue())) {
                        prefixes.add(attr.getLocalName());
                    }
                    ++i;
                }
                return prefixes.iterator();
            }

            @Override
            public Iterator getPrefixes() {
                if (docElement == null) {
                    return Collections.EMPTY_LIST.iterator();
                }
                ArrayList<String> prefixes = new ArrayList<String>();
                NamedNodeMap attrs = docElement.getAttributes();
                int i = 0;
                while (i < attrs.getLength()) {
                    Attr attr = (Attr)attrs.item(i);
                    if (Utils.isNamespaceAttribute(attr.getName())) {
                        prefixes.add(attr.getLocalName());
                    }
                    ++i;
                }
                return prefixes.iterator();
            }
        };
    }

    public static String getNamespaceAttribute(String prefix) {
        if (StringUtil.isEmpty((String)prefix)) {
            return "xmlns";
        }
        return "xmlns:" + prefix;
    }

    public static boolean isNamespaceAttribute(String name) {
        return name.startsWith("xmlns:");
    }

    public static String getAsString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            return XMIConverter.toString((Date)value);
        }
        if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                return XMIConverter.toString((BigDecimal)value);
            }
            if (value instanceof BigInteger) {
                return XMIConverter.toString((BigInteger)value);
            }
            if (value instanceof Integer) {
                return XMIConverter.toString((Integer)value);
            }
            if (value instanceof Double) {
                return XMIConverter.toString((Double)value);
            }
            if (value instanceof Long) {
                return XMIConverter.toString((Long)value);
            }
            if (value instanceof Float) {
                return XMIConverter.toString(((Float)value).floatValue());
            }
            if (value instanceof Short) {
                return XMIConverter.toString((Short)value);
            }
            if (value instanceof Byte) {
                return XMIConverter.toString((Byte)value);
            }
        }
        if (value instanceof Character) {
            return XMIConverter.toString(((Character)value).charValue());
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            StringBuffer buffer = new StringBuffer();
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                buffer.append(Utils.getAsString(i.next()));
                if (!i.hasNext()) continue;
                buffer.append(" ");
            }
            return buffer.toString();
        }
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < array.length) {
                buffer.append(Utils.getAsString(array[i]));
                if (i + 1 < array.length) {
                    buffer.append(" ");
                }
                ++i;
            }
            return buffer.toString();
        }
        return value == null ? "" : value.toString();
    }
}

