/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.commons.xml.xpath.xml;

import com.ibm.commons.xml.DOMUtil;
import com.ibm.commons.xml.XResult;
import com.ibm.commons.xml.drivers.XMLParserDriver;
import com.ibm.commons.xml.xpath.AbstractExpressionFactory;
import com.ibm.commons.xml.xpath.XPathException;
import com.ibm.commons.xml.xpath.XPathExpression;
import com.ibm.commons.xml.xpath.part.Part;
import com.ibm.commons.xml.xpath.xml.XmlComplexExpression;
import com.ibm.commons.xml.xpath.xml.XmlSimpleExpression;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlXPathExpressionFactory
extends AbstractExpressionFactory {
    protected XMLParserDriver _domDriver;

    public XmlXPathExpressionFactory(XMLParserDriver domDriver) {
        this._domDriver = domDriver;
    }

    public XmlXPathExpressionFactory() {
        this._domDriver = DOMUtil.getParserDriver();
    }

    @Override
    public boolean isValidDataContext(Object data) {
        return data instanceof Node || data instanceof Document || data instanceof XResult;
    }

    @Override
    public XPathExpression createExpression(Object data, String expression, boolean usecache) throws XPathException {
        return super.createExpression(data, expression, usecache);
    }

    @Override
    protected XPathExpression createSimpleExpression(String expression, boolean isFromRoot, Part[] parts) throws XPathException {
        return new XmlSimpleExpression(expression, isFromRoot, parts);
    }

    @Override
    protected XPathExpression createComplexExpression(String expression) throws XPathException {
        Object compiledXPath = this._domDriver.createXPath(expression);
        return new XmlComplexExpression(this._domDriver, expression, compiledXPath);
    }

    @Override
    protected boolean isXMLNameStartCharacter(char ch) {
        boolean result = false;
        result = Character.isLetterOrDigit(ch) || ch == '.' || ch == '-' || ch == '_' || ch == ':';
        return result;
    }

    @Override
    protected boolean isXMLNameCharacter(char ch) {
        boolean result = false;
        result = Character.isLetterOrDigit(ch) || ch == '.' || ch == '-' || ch == '_' || ch == ':';
        return result;
    }
}

