/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.maven.plugin.managers;

import com.hcl.appscan.sdk.logging.IProgress;
import com.hcl.appscan.sdk.logging.Message;
import org.apache.maven.plugin.logging.Log;

public class MavenProgress
implements IProgress {
    private Log m_log;

    public MavenProgress(Log log) {
        this.m_log = log;
    }

    public void setStatus(Message message) {
        this.log(message);
    }

    public void setStatus(Throwable e) {
        this.logError(new Message(2, e.getLocalizedMessage()));
    }

    public void setStatus(Message message, Throwable e) {
        this.logInfo(message);
        this.logError(new Message(2, e.getLocalizedMessage()));
    }

    private void log(Message message) {
        switch (message.getSeverity()) {
            case 2: {
                this.logError(message);
                break;
            }
            case 1: {
                this.logWarning(message);
                break;
            }
            default: {
                this.logInfo(message);
            }
        }
    }

    private void logError(Message error) {
        this.m_log.error((CharSequence)error.getText());
    }

    private void logWarning(Message warning) {
        this.m_log.warn((CharSequence)warning.getText());
    }

    private void logInfo(Message info) {
        this.m_log.info((CharSequence)info.getText());
    }
}

