/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.maven.plugin.mojos;

import com.hcl.appscan.maven.plugin.Messages;
import com.hcl.appscan.maven.plugin.mojos.AppScanMojo;
import com.hcl.appscan.maven.plugin.targets.MavenTarget;
import com.hcl.appscan.sdk.logging.Message;
import com.hcl.appscan.sdk.scan.IScanManager;
import com.hcl.appscan.sdk.scan.ITarget;
import com.hcl.appscan.sdk.scanners.sast.SASTScanManager;
import com.hcl.appscan.sdk.utils.FileUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class SASTMojo
extends AppScanMojo {
    @Parameter(property="output", defaultValue="", required=false, readonly=false)
    private String m_output;
    private File m_irx;
    private IScanManager m_scanManager;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_scanManager = new SASTScanManager(this.m_targetDir);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isLastProject(this.m_project)) {
            this.initialize();
            this.setIrxFile();
            for (MavenProject project : this.m_projects) {
                this.addScanTarget(project);
            }
            this.run();
        }
    }

    protected IScanManager getScanManager() {
        return this.m_scanManager;
    }

    protected File getIrx() {
        return this.m_irx;
    }

    protected Map<String, String> getScanProperties() {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("ScanName", this.getScanName());
        properties.put("irxDir", this.m_irx.getParent());
        properties.put("APPSCAN_IRGEN_CLIENT", "Maven");
        return properties;
    }

    protected abstract void run() throws MojoExecutionException;

    private void addScanTarget(MavenProject project) {
        if (project.getPackaging().equalsIgnoreCase("pom")) {
            return;
        }
        this.m_scanManager.addScanTarget((ITarget)new MavenTarget(project));
    }

    private String getScanName() {
        return this.m_irx.getName().substring(0, this.m_irx.getName().lastIndexOf(46));
    }

    private String getDefaultScanName() {
        return FileUtil.getValidFilename((String)(this.m_rootProject.getName() + ".irx"));
    }

    private void setIrxFile() {
        if (this.m_output == null || this.m_output.trim().equals("") || this.m_output.equals("true")) {
            this.m_irx = new File(this.m_targetDir, this.getDefaultScanName());
            this.getProgress().setStatus(new Message(0, Messages.getMessage("missing.output.arg", this.m_irx)));
        } else {
            File irxFile = new File(this.m_output);
            if (irxFile.isDirectory()) {
                this.m_irx = new File(irxFile, this.getDefaultScanName());
                this.getProgress().setStatus(new Message(0, Messages.getMessage("scan.file.is.directory", irxFile, this.m_irx)));
            } else if (irxFile.getParentFile() == null || !irxFile.getParentFile().exists()) {
                this.m_irx = new File(this.m_targetDir, this.getDefaultScanName());
                this.getProgress().setStatus(new Message(0, Messages.getMessage("scan.file.invalid", this.m_output, this.m_irx)));
            } else {
                String name = irxFile.getName();
                name = name.endsWith(".irx") ? name : name + ".irx";
                this.m_irx = new File(irxFile.getParentFile(), name);
            }
        }
        if (this.m_irx.isFile()) {
            this.m_irx.delete();
        }
    }
}

