/*
 * Decompiled with CFR 0.152.
 */
package com.hcl.appscan.maven.plugin.targets;

import com.hcl.appscan.maven.plugin.IMavenConstants;
import com.hcl.appscan.maven.plugin.util.MavenUtil;
import com.hcl.appscan.sdk.scanners.sast.targets.JavaTarget;
import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class MavenJavaTarget
extends JavaTarget
implements IMavenConstants {
    private MavenProject m_project;

    public MavenJavaTarget(MavenProject project) {
        this.m_project = project;
    }

    public String getClasspath() {
        String classpath = "";
        for (Artifact dependency : this.m_project.getArtifacts()) {
            if (dependency.getFile() == null || dependency.getScope() == "test") continue;
            classpath = classpath + dependency.getFile().getAbsolutePath() + File.pathSeparator;
        }
        return classpath;
    }

    public String getJava() {
        String jdk = System.getenv("JAVA_HOME");
        return jdk == null ? System.getProperty("java.home") : jdk;
    }

    public File getTargetFile() {
        String packaging = this.m_project.getPackaging();
        if (!packaging.equalsIgnoreCase("jar") && !packaging.equalsIgnoreCase("hpi")) {
            return new File(this.m_project.getBuild().getOutputDirectory());
        }
        String finalName = MavenUtil.getPluginConfigurationProperty(this.m_project, "org.apache.maven.plugins:maven-jar-plugin", "finalName");
        if (finalName == null) {
            finalName = this.m_project.getBuild().getFinalName();
        }
        return new File(this.m_project.getBuild().getDirectory(), finalName + ".jar");
    }
}

