/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.ssa;

import com.ibm.wala.cast.java.ssa.AstJavaInstructionFactory;
import com.ibm.wala.cast.java.ssa.AstJavaInstructionVisitor;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;
import java.util.Collection;
import java.util.Collections;

public class EnclosingObjectReference
extends SSAInstruction {
    private final TypeReference type;
    private final int lval;

    public EnclosingObjectReference(int iindex, int lval, TypeReference type) {
        super(iindex);
        this.lval = lval;
        this.type = type;
    }

    public boolean hasDef() {
        return true;
    }

    public int getDef() {
        return this.lval;
    }

    public int getDef(int i) {
        assert (i == 0);
        return this.lval;
    }

    public int getNumberOfDefs() {
        return 1;
    }

    public TypeReference getEnclosingType() {
        return this.type;
    }

    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        return ((AstJavaInstructionFactory)insts).EnclosingObjectReference(this.iIndex(), defs == null ? this.lval : defs[0], this.type);
    }

    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.lval) + " = enclosing " + this.type.getName();
    }

    public void visit(SSAInstruction.IVisitor v) {
        ((AstJavaInstructionVisitor)v).visitEnclosingObjectReference(this);
    }

    public int hashCode() {
        return this.lval * this.type.hashCode();
    }

    public Collection<TypeReference> getExceptionTypes() {
        return Collections.emptySet();
    }

    public boolean isFallThrough() {
        return true;
    }
}

