/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ir.ssa;

import com.ibm.wala.cast.ir.ssa.AbstractSSAConversion;
import com.ibm.wala.cast.ir.ssa.AssignInstruction;
import com.ibm.wala.cast.ir.ssa.AstIRFactory;
import com.ibm.wala.cast.ir.ssa.analysis.LiveAnalysis;
import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAOptions;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.IteratorUtil;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.BitVectorIntSet;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SSAConversion
extends AbstractSSAConversion {
    public static boolean DEBUG = false;
    public static boolean DEBUG_UNDO = false;
    public static boolean DEBUG_NAMES = false;
    public static boolean DUMP = false;
    private final AstIRFactory.AstIR ir;
    private int nextSSAValue;
    private final AstMethod.DebuggingInformation debugInfo;
    private final AstMethod.LexicalInformation lexicalInfo;
    private final SymbolTable symtab;
    private final LiveAnalysis.Result liveness;
    private SSAInformation computedLocalMap;
    private Map<Integer, Integer> assignments = HashMapFactory.make();
    private final Map<Object, CopyPropagationRecord> copyPropagationMap;
    private final ArrayList<CopyPropagationRecord>[] R;

    public static void undoCopyPropagation(AstIRFactory.AstIR ir, int instruction, int use) {
        SSAInformation info = ir.getLocalMap();
        info.undoCopyPropagation(instruction, use);
    }

    public static void copyUse(AstIRFactory.AstIR ir, int fromInst, int fromUse, int toInst, int toUse) {
        SSAInformation info = ir.getLocalMap();
        info.copyUse(fromInst, fromUse, toInst, toUse);
    }

    private CopyPropagationRecord topR(int v) {
        if (this.R[v] != null && !this.R[v].isEmpty()) {
            CopyPropagationRecord rec = SSAConversion.peek(this.R[v]);
            if (this.top(v) == rec.rhs) {
                return rec;
            }
        }
        return null;
    }

    private static <T> void push(ArrayList<T> stack, T elt) {
        stack.add(elt);
    }

    private static <T> T peek(ArrayList<T> stack) {
        return stack.get(stack.size() - 1);
    }

    @Override
    protected int getNumberOfDefs(SSAInstruction inst) {
        return inst.getNumberOfDefs();
    }

    @Override
    protected int getDef(SSAInstruction inst, int index) {
        return inst.getDef(index);
    }

    @Override
    protected int getNumberOfUses(SSAInstruction inst) {
        return inst.getNumberOfUses();
    }

    @Override
    protected int getUse(SSAInstruction inst, int index) {
        return inst.getUse(index);
    }

    @Override
    protected boolean isAssignInstruction(SSAInstruction inst) {
        return inst instanceof AssignInstruction;
    }

    @Override
    protected int getMaxValueNumber() {
        return this.symtab.getMaxValueNumber();
    }

    @Override
    protected boolean skip(int vn) {
        return false;
    }

    @Override
    protected boolean isLive(SSACFG.BasicBlock Y, int V) {
        return this.liveness.isLiveEntry((ISSABasicBlock)Y, V);
    }

    private void addPhi(SSACFG.BasicBlock BB, SSAPhiInstruction phi) {
        BB.addPhiForLocal(this.phiCounts[BB.getGraphNodeId()], phi);
    }

    @Override
    protected void placeNewPhiAt(int value, SSACFG.BasicBlock Y) {
        int[] params = new int[this.CFG.getPredNodeCount((ISSABasicBlock)Y)];
        Arrays.fill(params, value);
        SSAPhiInstruction phi = new SSAPhiInstruction(-1, value, params);
        if (DEBUG) {
            System.err.println("Placing " + phi + " at " + Y);
        }
        this.addPhi(Y, phi);
    }

    @Override
    protected SSAPhiInstruction getPhi(SSACFG.BasicBlock B, int index) {
        return B.getPhiForLocal(index);
    }

    @Override
    protected void setPhi(SSACFG.BasicBlock B, int index, SSAPhiInstruction inst) {
        B.addPhiForLocal(index, inst);
    }

    @Override
    protected SSAPhiInstruction repairPhiDefs(SSAPhiInstruction phi, int[] newDefs) {
        return (SSAPhiInstruction)phi.copyForSSA(this.CFG.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory(), newDefs, null);
    }

    @Override
    protected void repairPhiUse(SSACFG.BasicBlock BB, int phiIndex, int rvalIndex, int newRval) {
        SSAPhiInstruction phi = this.getPhi(BB, phiIndex);
        int[] newUses = new int[this.getNumberOfUses((SSAInstruction)phi)];
        for (int v = 0; v < newUses.length; ++v) {
            int newUse;
            int oldUse = this.getUse((SSAInstruction)phi, v);
            newUses[v] = newUse = v == rvalIndex ? newRval : oldUse;
            if (v != rvalIndex || this.topR(oldUse) == null) continue;
            this.topR(oldUse).addUse(BB.getGraphNodeId(), phiIndex, v);
        }
        phi.setValues(newUses);
    }

    @Override
    protected void pushAssignment(SSAInstruction inst, int index, int newRhs) {
        int lhs = this.getDef(inst, 0);
        int rhs = this.getUse(inst, 0);
        this.assignments.put(rhs, lhs);
        CopyPropagationRecord rec = new CopyPropagationRecord(index, newRhs);
        SSAConversion.push(this.R[lhs], rec);
        if (this.topR(rhs) != null) {
            this.topR(rhs).addChild(rec);
        }
    }

    @Override
    protected void repairInstructionUses(SSAInstruction inst, int index, int[] newUses) {
        for (int j = 0; j < this.getNumberOfUses(inst); ++j) {
            if (this.topR(this.getUse(inst, j)) == null) continue;
            this.topR(this.getUse(inst, j)).addUse(index, j);
        }
        int[] lexicalUses = this.lexicalInfo.getExposedUses(index);
        if (lexicalUses != null) {
            for (int j = 0; j < lexicalUses.length; ++j) {
                int newUse;
                int lexicalUse = lexicalUses[j];
                if (lexicalUse == -1 || this.skip(lexicalUse)) continue;
                if (this.S.length <= lexicalUse || this.S[lexicalUse].isEmpty()) {
                    lexicalUses[j] = -1;
                    continue;
                }
                lexicalUses[j] = newUse = this.top(lexicalUse);
                if (this.topR(lexicalUse) == null) continue;
                this.topR(lexicalUse).addUse(index, -j - 1);
            }
        }
    }

    @Override
    protected void repairInstructionDefs(SSAInstruction inst, int index, int[] newDefs, int[] newUses) {
        this.instructions[index] = inst.copyForSSA(this.CFG.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory(), newDefs, newUses);
    }

    @Override
    protected void popAssignment(SSAInstruction inst, int index) {
        this.instructions[index] = null;
    }

    @Override
    protected boolean isConstant(int valueNumber) {
        return this.symtab.isConstant(valueNumber);
    }

    @Override
    protected boolean skipRepair(SSAInstruction inst, int index) {
        if (!super.skipRepair(inst, index)) {
            return false;
        }
        if (index == -1) {
            return true;
        }
        int[] lexicalUses = this.lexicalInfo.getExposedUses(index);
        if (lexicalUses != null) {
            for (int lexicalUs : lexicalUses) {
                if (this.skip(lexicalUs)) continue;
                return false;
            }
        }
        return true;
    }

    private SSAConversion(AstMethod M, AstIRFactory.AstIR ir, SSAOptions options) {
        super(ir, options);
        HashMap m = HashMapFactory.make();
        this.copyPropagationMap = ir.getLocalMap() != null ? ir.getLocalMap().getCopyHistory() : m;
        this.ir = ir;
        this.debugInfo = M.debugInfo();
        this.lexicalInfo = ir.lexicalInfo();
        this.symtab = ir.getSymbolTable();
        this.R = new ArrayList[ir.getSymbolTable().getMaxValueNumber() + 1];
        for (int i = 0; i < this.CFG.getNumberOfNodes(); ++i) {
            SSACFG.BasicBlock bb = this.CFG.getNode(i);
            if (!bb.hasPhi()) continue;
            this.phiCounts[i] = IteratorUtil.count((Iterator)bb.iteratePhis());
        }
        this.nextSSAValue = ir.getNumberOfParameters() + 1;
        int[] exitLive = this.lexicalInfo.getExitExposedUses();
        BitVector v = new BitVector();
        if (exitLive != null) {
            for (int element : exitLive) {
                if (element <= -1) continue;
                v.set(element);
            }
        }
        this.liveness = LiveAnalysis.perform((ControlFlowGraph<SSAInstruction, ISSABasicBlock>)this.CFG, this.symtab, v);
        if (DEBUG) {
            System.err.println(this.liveness);
        }
    }

    @Override
    protected int getNextNewValueNumber() {
        while (this.symtab.isConstant(this.nextSSAValue) || this.skip(this.nextSSAValue)) {
            ++this.nextSSAValue;
        }
        this.symtab.ensureSymbol(this.nextSSAValue);
        int v = this.nextSSAValue++;
        return v;
    }

    @Override
    protected void initializeVariables() {
        int[] params;
        for (int V = 1; V <= this.getMaxValueNumber(); ++V) {
            if (this.skip(V)) continue;
            this.R[V] = new ArrayList();
        }
        for (int param : params = this.symtab.getParameterValueNumbers()) {
            if (this.skip(param)) continue;
            this.S[param].push(param);
            this.valueMap[param] = param;
        }
    }

    @Override
    protected void repairExit() {
        int[] exitLives = this.lexicalInfo.getExitExposedUses();
        if (exitLives != null) {
            for (int i = 0; i < exitLives.length; ++i) {
                if (exitLives[i] == -1 || this.skip(exitLives[i])) continue;
                assert (!this.S[exitLives[i]].isEmpty());
                exitLives[i] = this.top(exitLives[i]);
            }
        }
    }

    @Override
    protected void fail(int v) {
        System.err.println("during SSA conversion of the following IR:");
        System.err.println((Object)this.ir);
        super.fail(v);
    }

    public SSAInformation getComputedLocalMap() {
        return this.computedLocalMap;
    }

    @Override
    public void perform() {
        super.perform();
        if (DUMP) {
            System.err.println((Object)this.ir);
            if (this.lexicalInfo != null) {
                for (int i = 0; i < this.instructions.length; ++i) {
                    int[] lexicalUses = this.lexicalInfo.getExposedUses(i);
                    if (lexicalUses == null) continue;
                    System.err.print("extra uses for " + this.instructions[i] + ": ");
                    for (int lexicalUse : lexicalUses) {
                        System.err.print(Integer.valueOf(lexicalUse).toString() + ' ');
                    }
                    System.err.println();
                }
            }
        }
        this.computedLocalMap = new SSAInformation();
    }

    private static IntSet valuesToConvert(AstIRFactory.AstIR ir) {
        SSAInstruction[] insts = ir.getInstructions();
        BitVectorIntSet foundOne = new BitVectorIntSet();
        BitVectorIntSet foundTwo = new BitVectorIntSet();
        for (SSAInstruction inst : insts) {
            if (inst == null) continue;
            for (int j = 0; j < inst.getNumberOfDefs(); ++j) {
                int def = inst.getDef(j);
                if (def == -1) continue;
                if (foundOne.contains(def) || ir.getSymbolTable().isConstant(def) || def <= ir.getNumberOfParameters() || inst instanceof AssignInstruction) {
                    foundTwo.add(def);
                    continue;
                }
                foundOne.add(def);
            }
        }
        return foundTwo;
    }

    public static SSAInformation convert(AstMethod M, AstIRFactory.AstIR ir, SSAOptions options) {
        return SSAConversion.convert(M, ir, options, SSAConversion.valuesToConvert(ir));
    }

    public static SSAInformation convert(AstMethod M, final AstIRFactory.AstIR ir, SSAOptions options, final IntSet values) {
        if (DEBUG) {
            System.err.println("starting conversion for " + values);
            System.err.println((Object)ir);
        }
        if (DEBUG_UNDO) {
            System.err.println(">>> starting " + ir.getMethod());
        }
        SSAConversion ssa = new SSAConversion(M, ir, options){
            final int limit;
            {
                super(M, ir2, options);
                this.limit = ir.getSymbolTable().getMaxValueNumber();
            }

            @Override
            protected boolean skip(int i) {
                return i >= 0 && i <= this.limit && !values.contains(i);
            }
        };
        ssa.perform();
        if (DEBUG_UNDO) {
            System.err.println("<<< done " + ir.getMethod());
        }
        return ssa.getComputedLocalMap();
    }

    public class SSAInformation
    implements IR.SSA2LocalMap {
        private final String[][] computedNames;

        public SSAInformation() {
            this.computedNames = new String[SSAConversion.this.valueMap.length][];
        }

        public String[] getLocalNames(int pc, int vn) {
            if (this.computedNames[vn] != null) {
                return this.computedNames[vn];
            }
            int v = SSAConversion.this.skip(vn) || vn >= SSAConversion.this.valueMap.length ? vn : SSAConversion.this.valueMap[vn];
            String[][] namesData = SSAConversion.this.debugInfo.getSourceNamesForValues();
            String[] vNames = namesData[v];
            HashSet x = HashSetFactory.make();
            x.addAll(Arrays.asList(vNames));
            MutableIntSet vals = IntSetUtil.make();
            while (SSAConversion.this.assignments.containsKey(v) && !vals.contains(v)) {
                vals.add(v);
                v = (Integer)SSAConversion.this.assignments.get(v);
                vNames = namesData[v];
                x.addAll(Arrays.asList(vNames));
            }
            this.computedNames[vn] = x.toArray(new String[0]);
            return this.computedNames[vn];
        }

        private void undoCopyPropagation(int instructionIndex, int useNumber) {
            if (DEBUG_UNDO) {
                System.err.println("undoing for use #" + useNumber + " of inst #" + instructionIndex);
            }
            UseRecord use = new UseRecord(instructionIndex, useNumber);
            if (SSAConversion.this.copyPropagationMap.containsKey(use)) {
                ((CopyPropagationRecord)SSAConversion.this.copyPropagationMap.get(use)).undo();
            }
        }

        private void copyUse(int fromInst, int fromUse, int toInst, int toUse) {
            UseRecord use = new UseRecord(fromInst, fromUse);
            if (SSAConversion.this.copyPropagationMap.containsKey(use)) {
                ((CopyPropagationRecord)SSAConversion.this.copyPropagationMap.get(use)).addUse(toInst, toUse);
            }
        }

        public Map<Object, CopyPropagationRecord> getCopyHistory() {
            return SSAConversion.this.copyPropagationMap;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(super.toString());
            for (Map.Entry x : SSAConversion.this.copyPropagationMap.entrySet()) {
                sb.append(x.getKey().toString()).append(" --> ").append(((CopyPropagationRecord)x.getValue()).toString()).append('\n');
            }
            return sb.toString();
        }
    }

    public class CopyPropagationRecord {
        final int rhs;
        final int instructionIndex;
        final Set<Object> renamedUses = HashSetFactory.make((int)2);
        private final Set<CopyPropagationRecord> childRecords = HashSetFactory.make((int)1);

        public int getRhs() {
            return this.rhs;
        }

        public int getInstructionIndex() {
            return this.instructionIndex;
        }

        public Set<Object> getRenamedUses() {
            return this.renamedUses;
        }

        public Set<CopyPropagationRecord> getChildRecords() {
            return this.childRecords;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("<vn " + this.rhs + " at " + this.instructionIndex);
            for (CopyPropagationRecord c : this.childRecords) {
                sb.append("\n ").append(c.toString());
            }
            sb.append('>');
            return sb.toString();
        }

        public int hashCode() {
            return this.instructionIndex;
        }

        public boolean equals(Object o) {
            return o instanceof CopyPropagationRecord && this.instructionIndex == ((CopyPropagationRecord)o).instructionIndex;
        }

        private CopyPropagationRecord(int instructionIndex, int rhs) {
            if (DEBUG_UNDO) {
                System.err.println("new copy record for instruction #" + instructionIndex + ", rhs value is " + rhs);
            }
            this.rhs = rhs;
            this.instructionIndex = instructionIndex;
        }

        private void addChild(CopyPropagationRecord rec) {
            if (DEBUG_UNDO) {
                System.err.println("(" + rec.instructionIndex + ',' + rec.rhs + ") is a child of (" + this.instructionIndex + ',' + this.rhs + ')');
            }
            this.childRecords.add(rec);
        }

        private void addUse(int instructionIndex, int use) {
            if (DEBUG_UNDO) {
                System.err.println("propagated use of (" + this.instructionIndex + ',' + this.rhs + ") at use #" + use + " of instruction #" + instructionIndex);
            }
            UseRecord rec = new UseRecord(instructionIndex, use);
            SSAConversion.this.copyPropagationMap.put(rec, this);
            this.renamedUses.add(rec);
        }

        private void addUse(int BB, int phiNumber, int use) {
            PhiUseRecord rec = new PhiUseRecord(BB, phiNumber, use);
            SSAConversion.this.copyPropagationMap.put(rec, this);
            this.renamedUses.add(rec);
        }

        private SSAInstruction undo(SSAInstruction inst, int use, int val) {
            int c = SSAConversion.this.getNumberOfUses(inst);
            int[] newUses = new int[c];
            for (int i = 0; i < c; ++i) {
                newUses[i] = i == use ? val : SSAConversion.this.getUse(inst, i);
            }
            return inst.copyForSSA(SSAConversion.this.CFG.getMethod().getDeclaringClass().getClassLoader().getInstructionFactory(), null, newUses);
        }

        private void undo(int rhs) {
            int lhs = SSAConversion.this.symtab.newSymbol();
            SSAConversion.this.instructions[this.instructionIndex] = new AssignInstruction(this.instructionIndex, lhs, rhs);
            if (DEBUG_UNDO) {
                System.err.println("recreating assignment at " + this.instructionIndex + " as " + lhs + " = " + rhs);
            }
            for (Object x : this.renamedUses) {
                Object use;
                if (x instanceof UseRecord) {
                    use = (UseRecord)x;
                    int idx = ((UseRecord)use).instructionIndex;
                    SSAInstruction inst = SSAConversion.this.instructions[idx];
                    if (DEBUG_UNDO) {
                        System.err.println("Changing use #" + ((UseRecord)use).useNumber + " of inst #" + idx + " to val " + lhs);
                    }
                    if (((UseRecord)use).useNumber >= 0) {
                        SSAConversion.this.instructions[idx] = this.undo(inst, ((UseRecord)use).useNumber, lhs);
                    } else {
                        ((SSAConversion)SSAConversion.this).lexicalInfo.getExposedUses((int)idx)[-((UseRecord)use).useNumber - 1] = lhs;
                    }
                    SSAConversion.this.copyPropagationMap.remove(use);
                    continue;
                }
                use = (PhiUseRecord)x;
                int bb = ((PhiUseRecord)use).BBnumber;
                int phi = ((PhiUseRecord)use).phiNumber;
                SSACFG.BasicBlock BB = SSAConversion.this.CFG.getNode(bb);
                BB.addPhiForLocal(phi, (SSAPhiInstruction)this.undo((SSAInstruction)BB.getPhiForLocal(phi), ((PhiUseRecord)use).useNumber, lhs));
                SSAConversion.this.copyPropagationMap.remove(use);
            }
            for (CopyPropagationRecord copyPropagationRecord : this.childRecords) {
                copyPropagationRecord.undo(lhs);
            }
        }

        public void undo() {
            this.undo(this.rhs);
            SSAConversion.this.copyPropagationMap.remove(new UseRecord(this.instructionIndex, this.rhs));
        }
    }

    public static class PhiUseRecord {
        final int BBnumber;
        final int phiNumber;
        final int useNumber;

        private PhiUseRecord(int BBnumber, int phiNumber, int useNumber) {
            this.BBnumber = BBnumber;
            this.phiNumber = phiNumber;
            this.useNumber = useNumber;
        }

        public int getBBnumber() {
            return this.BBnumber;
        }

        public int getPhiNumber() {
            return this.phiNumber;
        }

        public int getUseNumber() {
            return this.useNumber;
        }

        public String toString() {
            return "[use " + this.useNumber + " of " + this.phiNumber + " of block " + this.BBnumber + ']';
        }

        public int hashCode() {
            return this.phiNumber * this.BBnumber * this.useNumber;
        }

        public boolean equals(Object o) {
            return o instanceof PhiUseRecord && this.BBnumber == ((PhiUseRecord)o).BBnumber && this.phiNumber == ((PhiUseRecord)o).phiNumber && this.useNumber == ((PhiUseRecord)o).useNumber;
        }
    }

    public static class UseRecord {
        final int instructionIndex;
        final int useNumber;

        public int getInstructionIndex() {
            return this.instructionIndex;
        }

        public int getUseNumber() {
            return this.useNumber;
        }

        private UseRecord(int instructionIndex, int useNumber) {
            this.useNumber = useNumber;
            this.instructionIndex = instructionIndex;
        }

        public String toString() {
            return "[use " + this.useNumber + " of " + this.instructionIndex + ']';
        }

        public int hashCode() {
            return this.useNumber * this.instructionIndex;
        }

        public boolean equals(Object o) {
            return o instanceof UseRecord && this.instructionIndex == ((UseRecord)o).instructionIndex && this.useNumber == ((UseRecord)o).useNumber;
        }
    }
}

