/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.util.test;

import com.ibm.wala.cast.loader.AstMethod;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import java.util.Collection;
import java.util.Iterator;

public abstract class TestCallGraphShape {
    public static final Object ROOT = new Object(){

        public String toString() {
            return "CallGraphRoot";
        }
    };

    public void verifyCFGAssertions(CallGraph CG, Object[][] assertionData) {
        for (Object[] dat : assertionData) {
            String function = (String)dat[0];
            for (CGNode N : this.getNodes(CG, function)) {
                int[][] edges = (int[][])dat[1];
                SSACFG cfg = N.getIR().getControlFlowGraph();
                for (int i = 0; i < edges.length; ++i) {
                    SSACFG.BasicBlock bb = cfg.getNode(i);
                    assert (edges[i].length == cfg.getSuccNodeCount((ISSABasicBlock)bb)) : "basic block " + i;
                    for (int j = 0; j < edges[i].length; ++j) {
                        assert (cfg.hasEdge((ISSABasicBlock)bb, (ISSABasicBlock)cfg.getNode(edges[i][j])));
                    }
                }
            }
        }
    }

    public void verifySourceAssertions(CallGraph CG, Object[][] assertionData) {
        for (Object[] dat : assertionData) {
            String function = (String)dat[0];
            for (CGNode N : this.getNodes(CG, function)) {
                if (!(N.getMethod() instanceof AstMethod)) continue;
                AstMethod M = (AstMethod)N.getMethod();
                SSAInstruction[] insts = N.getIR().getInstructions();
                block2: for (int i = 0; i < insts.length; ++i) {
                    CAstSourcePositionMap.Position pos;
                    SSAInstruction inst = insts[i];
                    if (inst == null || (pos = M.getSourcePosition(i)) == null) continue;
                    String fileName = pos.getURL().toString();
                    if (fileName.lastIndexOf(47) >= 0) {
                        fileName = fileName.substring(fileName.lastIndexOf(47) + 1);
                    }
                    for (Object[] assertionDatum : assertionData) {
                        String file = (String)assertionDatum[1];
                        if (file.indexOf(47) >= 0) {
                            file = file.substring(file.lastIndexOf(47) + 1);
                        }
                        if (!file.equalsIgnoreCase(fileName) || pos.getFirstLine() < (Integer)assertionDatum[2] || (pos.getLastLine() != -1 ? pos.getLastLine() : pos.getFirstLine()) > (Integer)assertionDatum[3]) continue;
                        System.err.println("found " + inst + " of " + M + " at expected position " + pos);
                        continue block2;
                    }
                    assert (false) : "unexpected location " + pos + " for " + inst + " of " + M + "\n" + N.getIR();
                }
            }
        }
    }

    public void verifyNameAssertions(CallGraph CG, Object[][] assertionData) {
        for (Object[] element : assertionData) {
            for (CGNode N : this.getNodes(CG, (String)element[0])) {
                Name[] names;
                IR ir = N.getIR();
                for (Name name : names = (Name[])element[1]) {
                    System.err.println("looking for " + name.name + ", " + name.vn + " in " + N);
                    String[] localNames = ir.getLocalNames(name.instructionIndex, name.vn);
                    boolean found = false;
                    for (String localName : localNames) {
                        if (!localName.equals(name.name)) continue;
                        found = true;
                        break;
                    }
                    assert (found) : "no name " + name.name + " for " + N + "\n" + ir;
                }
            }
        }
    }

    protected void verifyGraphAssertions(CallGraph CG, Object[][] assertionData) {
        if (assertionData == null) {
            return;
        }
        for (Object[] assertionDatum : assertionData) {
            block1: for (int j = 0; j < ((String[])assertionDatum[1]).length; ++j) {
                NonNullSingletonIterator srcs;
                Object object = srcs = assertionDatum[0] instanceof String ? this.getNodes(CG, (String)assertionDatum[0]).iterator() : new NonNullSingletonIterator((Object)CG.getFakeRootNode());
                assert (srcs.hasNext()) : "cannot find " + assertionDatum[0];
                boolean checkAbsence = false;
                String targetName = ((String[])assertionDatum[1])[j];
                if (targetName.startsWith("!")) {
                    checkAbsence = true;
                    targetName = targetName.substring(1);
                }
                while (srcs.hasNext()) {
                    CGNode src = (CGNode)srcs.next();
                    for (CallSiteReference sr : Iterator2Iterable.make((Iterator)src.iterateCallSites())) {
                        Iterator<CGNode> dsts = this.getNodes(CG, targetName).iterator();
                        if (!checkAbsence) assert (dsts.hasNext()) : "cannot find " + targetName;
                        while (dsts.hasNext()) {
                            CGNode dst = dsts.next();
                            for (CGNode cgNode : CG.getPossibleTargets(src, sr)) {
                                if (!cgNode.equals(dst)) continue;
                                if (checkAbsence) {
                                    System.err.println("found unexpected " + src + " --> " + dst + " at " + sr);
                                    assert (false) : "found edge " + assertionDatum[0] + " ---> " + targetName;
                                    continue;
                                }
                                System.err.println("found expected " + src + " --> " + dst + " at " + sr);
                                continue block1;
                            }
                        }
                    }
                }
                System.err.println("cannot find edge " + assertionDatum[0] + " ---> " + targetName);
                assert (checkAbsence) : "cannot find edge " + assertionDatum[0] + " ---> " + targetName;
            }
        }
    }

    public void verifyNoEdges(CallGraph CG, String sourceDescription, String destDescription) {
        Collection<CGNode> sources = this.getNodes(CG, sourceDescription);
        Collection<CGNode> dests = this.getNodes(CG, destDescription);
        for (CGNode source : sources) {
            for (CGNode dest : dests) {
                for (CGNode n : Iterator2Iterable.make((Iterator)CG.getSuccNodes((Object)source))) {
                    if (n.equals(dest)) assert (false) : "Found a link from " + source + " to " + dest;
                }
            }
        }
    }

    public abstract Collection<CGNode> getNodes(CallGraph var1, String var2);

    public static class Name {
        String name;
        int instructionIndex;
        int vn;

        public Name(int vn, int instructionIndex, String name) {
            this.vn = vn;
            this.name = name;
            this.instructionIndex = instructionIndex;
        }
    }
}

