/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeCT.ClassConstants;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.Atom;
import java.io.Reader;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public abstract class AstClass
implements IClass,
ClassConstants {
    private final CAstSourcePositionMap.Position sourcePosition;
    private final TypeName typeName;
    private final TypeReference typeReference;
    private final IClassLoader loader;
    private final short modifiers;
    protected final Map<Atom, IField> declaredFields;
    protected final Map<Selector, IMethod> declaredMethods;

    protected AstClass(CAstSourcePositionMap.Position sourcePosition, TypeName typeName, IClassLoader loader, short modifiers, Map<Atom, IField> declaredFields, Map<Selector, IMethod> declaredMethods) {
        this.sourcePosition = sourcePosition;
        this.typeName = typeName;
        this.loader = loader;
        this.modifiers = modifiers;
        this.declaredFields = declaredFields;
        this.declaredMethods = declaredMethods;
        this.typeReference = TypeReference.findOrCreate((ClassLoaderReference)loader.getReference(), (TypeName)typeName);
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isReferenceType() {
        return true;
    }

    public boolean isArrayClass() {
        return false;
    }

    public boolean isSynthetic() {
        return false;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public CAstSourcePositionMap.Position getSourcePosition() {
        return this.sourcePosition;
    }

    public URL getSourceURL() {
        return this.sourcePosition.getURL();
    }

    public String getSourceFileName() {
        return this.sourcePosition.getURL().getFile();
    }

    public Reader getSource() {
        return null;
    }

    public TypeName getName() {
        return this.typeName;
    }

    public TypeReference getReference() {
        return this.typeReference;
    }

    public IClassLoader getClassLoader() {
        return this.loader;
    }

    public abstract IClass getSuperclass();

    private Collection<IClass> gatherInterfaces() {
        HashSet result = HashSetFactory.make();
        result.addAll(this.getDirectInterfaces());
        if (this.getSuperclass() != null) {
            result.addAll(this.getSuperclass().getAllImplementedInterfaces());
        }
        return result;
    }

    public abstract Collection<IClass> getDirectInterfaces();

    public Collection<IClass> getAllImplementedInterfaces() {
        return this.gatherInterfaces();
    }

    public IMethod getClassInitializer() {
        return this.getMethod(MethodReference.clinitSelector);
    }

    public IMethod getMethod(Selector selector) {
        if (this.declaredMethods.containsKey(selector)) {
            return this.declaredMethods.get(selector);
        }
        if (this.getSuperclass() != null) {
            return this.getSuperclass().getMethod(selector);
        }
        return null;
    }

    public IField getField(Atom name) {
        if (this.declaredFields.containsKey(name)) {
            return this.declaredFields.get(name);
        }
        if (this.getSuperclass() != null) {
            return this.getSuperclass().getField(name);
        }
        return null;
    }

    public IField getField(Atom name, TypeName type) {
        return this.getField(name);
    }

    public Collection<? extends IMethod> getDeclaredMethods() {
        return this.declaredMethods.values();
    }

    public Collection<IField> getDeclaredInstanceFields() {
        HashSet result = HashSetFactory.make();
        for (IField F : this.declaredFields.values()) {
            if (F.isStatic()) continue;
            result.add(F);
        }
        return result;
    }

    public Collection<IField> getDeclaredStaticFields() {
        HashSet result = HashSetFactory.make();
        for (IField F : this.declaredFields.values()) {
            if (!F.isStatic()) continue;
            result.add(F);
        }
        return result;
    }

    public Collection<IField> getAllInstanceFields() {
        HashSet result = HashSetFactory.make();
        result.addAll(this.getDeclaredInstanceFields());
        if (this.getSuperclass() != null) {
            result.addAll(this.getSuperclass().getAllInstanceFields());
        }
        return result;
    }

    public Collection<IField> getAllStaticFields() {
        HashSet result = HashSetFactory.make();
        result.addAll(this.getDeclaredStaticFields());
        if (this.getSuperclass() != null) {
            result.addAll(this.getSuperclass().getAllStaticFields());
        }
        return result;
    }

    public Collection<IField> getAllFields() {
        HashSet result = HashSetFactory.make();
        result.addAll(this.getAllInstanceFields());
        result.addAll(this.getAllStaticFields());
        return result;
    }

    public Collection<? extends IMethod> getAllMethods() {
        HashSet result = HashSetFactory.make();
        result.addAll(this.getDeclaredMethods());
        if (this.getSuperclass() != null) {
            result.addAll(this.getSuperclass().getAllMethods());
        }
        return result;
    }
}

