/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.loader;

import com.ibm.wala.cast.tree.CAstQualifier;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IField;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.types.annotations.Annotation;
import com.ibm.wala.util.strings.Atom;
import java.util.Collection;

public class AstField
implements IField {
    private final Collection<CAstQualifier> qualifiers;
    private final FieldReference ref;
    private final IClass declaringClass;
    private final IClassHierarchy cha;
    private final Collection<Annotation> annotations;

    public AstField(FieldReference ref, Collection<CAstQualifier> qualifiers, IClass declaringClass, IClassHierarchy cha, Collection<Annotation> annotations) {
        this.declaringClass = declaringClass;
        this.qualifiers = qualifiers;
        this.ref = ref;
        this.cha = cha;
        this.annotations = annotations;
    }

    public Collection<Annotation> getAnnotations() {
        return this.annotations;
    }

    public IClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String toString() {
        return "field " + this.ref.getName();
    }

    public Atom getName() {
        return this.ref.getName();
    }

    public TypeReference getFieldTypeReference() {
        return this.ref.getFieldType();
    }

    public FieldReference getReference() {
        return this.ref;
    }

    public boolean isStatic() {
        return this.qualifiers.contains(CAstQualifier.STATIC);
    }

    public boolean isFinal() {
        return this.qualifiers.contains(CAstQualifier.CONST) || this.qualifiers.contains(CAstQualifier.FINAL);
    }

    public boolean isPrivate() {
        return this.qualifiers.contains(CAstQualifier.PRIVATE);
    }

    public boolean isProtected() {
        return this.qualifiers.contains(CAstQualifier.PROTECTED);
    }

    public boolean isPublic() {
        return this.qualifiers.contains(CAstQualifier.PUBLIC);
    }

    public boolean isVolatile() {
        return this.qualifiers.contains(CAstQualifier.VOLATILE);
    }

    public IClassHierarchy getClassHierarchy() {
        return this.cha;
    }
}

