/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.rewrite;

import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.CAstOperator;
import com.ibm.wala.cast.tree.rewrite.CAstRewriter;
import com.ibm.wala.util.collections.Pair;
import java.util.Map;
import java.util.Objects;

public class AstLoopUnwinder
extends CAstRewriter<CAstRewriter.RewriteContext<UnwindKey>, UnwindKey> {
    private final int unwindFactor;

    public AstLoopUnwinder(CAst Ast, boolean recursive) {
        this(Ast, recursive, 3);
    }

    public AstLoopUnwinder(CAst Ast, boolean recursive, int unwindFactor) {
        super(Ast, recursive, new RootContext());
        this.unwindFactor = unwindFactor;
    }

    public CAstEntity translate(CAstEntity original) {
        return this.rewrite(original);
    }

    @Override
    protected CAstNode flowOutTo(Map<Pair<CAstNode, UnwindKey>, CAstNode> nodeMap, CAstNode oldSource, Object label, CAstNode oldTarget, CAstControlFlowMap orig, CAstSourcePositionMap src) {
        assert (oldTarget == CAstControlFlowMap.EXCEPTION_TO_EXIT);
        return oldTarget;
    }

    @Override
    protected CAstNode copyNodes(CAstNode n, CAstControlFlowMap cfg, CAstRewriter.RewriteContext<UnwindKey> c, Map<Pair<CAstNode, UnwindKey>, CAstNode> nodeMap) {
        if (n instanceof CAstOperator) {
            return n;
        }
        if (n.getValue() != null) {
            return this.Ast.makeConstant(n.getValue());
        }
        if (n.getKind() == 2) {
            CAstNode test = n.getChild(0);
            CAstNode body = n.getChild(1);
            int count = this.unwindFactor;
            LoopContext lc = new LoopContext(count, c);
            CAstNode code = this.Ast.makeNode(403, this.Ast.makeNode(106, (CAstNode)CAstOperator.OP_NOT, this.copyNodes(test, cfg, lc, nodeMap)), this.Ast.makeConstant(false));
            while (count-- > 0) {
                lc = new LoopContext(count, c);
                code = this.Ast.makeNode(11, this.copyNodes(test, cfg, lc, nodeMap), this.Ast.makeNode(3, this.copyNodes(body, cfg, lc, nodeMap), code));
            }
            return code;
        }
        return this.copySubtreesIntoNewNode(n, cfg, c, nodeMap);
    }

    private static class LoopContext
    implements CAstRewriter.RewriteContext<UnwindKey> {
        private final CAstRewriter.RewriteContext<UnwindKey> parent;
        private final int iteration;

        private LoopContext(int iteration, CAstRewriter.RewriteContext<UnwindKey> parent) {
            this.iteration = iteration;
            this.parent = parent;
        }

        @Override
        public UnwindKey key() {
            return new UnwindKey(this.iteration, this.parent.key());
        }
    }

    private static class RootContext
    implements CAstRewriter.RewriteContext<UnwindKey> {
        private RootContext() {
        }

        @Override
        public UnwindKey key() {
            return null;
        }
    }

    public static class UnwindKey
    implements CAstRewriter.CopyKey<UnwindKey> {
        private final int iteration;
        private final UnwindKey rest;

        private UnwindKey(int iteration, UnwindKey rest) {
            this.rest = rest;
            this.iteration = iteration;
        }

        @Override
        public int hashCode() {
            return this.iteration * (this.rest == null ? 1 : this.rest.hashCode());
        }

        @Override
        public UnwindKey parent() {
            return this.rest;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof UnwindKey && ((UnwindKey)o).iteration == this.iteration && Objects.equals(this.rest, ((UnwindKey)o).rest);
        }

        public String toString() {
            return "#" + this.iteration + (this.rest == null ? "" : this.rest.toString());
        }
    }
}

