/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.util;

import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;

public class SourceBuffer {
    private String[] lines;
    private final CAstSourcePositionMap.Position p;

    public SourceBuffer(CAstSourcePositionMap.Position p) throws IOException {
        this.p = p;
        BufferedReader reader = new BufferedReader(p.getReader());
        String currentLine = null;
        ArrayList<String> lines = new ArrayList<String>();
        int offset = 0;
        int line = 0;
        do {
            if ((currentLine = reader.readLine()) != null) continue;
            this.lines = new String[0];
            return;
        } while (p.getLastOffset() < 0 ? p.getFirstLine() > ++line : p.getFirstOffset() > (offset += currentLine.length() + 1));
        if (p.getLastOffset() >= 0) {
            if (p.getFirstOffset() == offset) {
                lines.add("\n");
            } else {
                int startOffset = p.getFirstOffset() - (offset - currentLine.length() - 1);
                if (offset > p.getLastOffset()) {
                    int endOffset = p.getLastOffset() - (offset - currentLine.length() - 1);
                    lines.add(currentLine.substring(startOffset, endOffset));
                } else {
                    lines.add(currentLine.substring(startOffset));
                }
            }
        } else {
            lines.add(currentLine.substring(Math.max(p.getFirstCol(), 0)));
        }
        while (p.getLastOffset() >= 0 ? p.getLastOffset() >= offset : p.getLastLine() >= line) {
            currentLine = reader.readLine();
            if (currentLine == null) {
                offset = p.getLastOffset();
                break;
            }
            offset += currentLine.length() + 1;
            ++line;
            if (p.getLastOffset() >= 0) {
                if (offset > p.getLastOffset()) {
                    lines.add(currentLine.substring(0, currentLine.length() - (offset - p.getLastOffset()) + 1));
                    continue;
                }
                lines.add(currentLine);
                continue;
            }
            if (p.getLastLine() == line) {
                lines.add(currentLine.substring(0, p.getLastCol()));
                continue;
            }
            lines.add(currentLine);
        }
        this.lines = lines.toArray(new String[0]);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.lines.length; ++i) {
            if (i == this.lines.length - 1) {
                result.append(this.lines[i]);
                continue;
            }
            result.append(this.lines[i]).append('\n');
        }
        return result.toString();
    }

    public void substitute(CAstSourcePositionMap.Position range, String newText) {
        String[] newTextLines;
        int endLine;
        int startLine = range.getFirstLine() - this.p.getFirstLine();
        if (startLine != (endLine = range.getLastLine() - this.p.getFirstLine())) {
            int i;
            String[] newLines = new String[this.lines.length - (endLine - startLine)];
            for (i = 0; i < startLine; ++i) {
                newLines[i] = this.lines[i];
            }
            newLines[i++] = this.lines[startLine].substring(0, range.getFirstCol()) + this.lines[endLine].substring(range.getLastCol());
            while (i < newLines.length) {
                newLines[i] = this.lines[i + (endLine - startLine)];
                ++i;
            }
            this.lines = newLines;
            endLine = startLine;
            final CAstSourcePositionMap.Position hack = range;
            range = new AbstractSourcePosition(){

                public int getFirstLine() {
                    return hack.getFirstLine();
                }

                public int getLastLine() {
                    return hack.getFirstLine();
                }

                public int getFirstCol() {
                    return hack.getFirstCol();
                }

                public int getLastCol() {
                    return hack.getFirstCol();
                }

                public int getFirstOffset() {
                    return hack.getFirstOffset();
                }

                public int getLastOffset() {
                    return hack.getFirstOffset();
                }

                @Override
                public URL getURL() {
                    return hack.getURL();
                }

                @Override
                public Reader getReader() throws IOException {
                    return hack.getReader();
                }
            };
        }
        if ((newTextLines = newText.split("\n")).length == 1) {
            this.lines[startLine] = this.lines[startLine].substring(0, range.getFirstCol()) + newTextLines[0] + this.lines[startLine].substring(range.getLastCol() + 1);
        } else {
            int i;
            String[] newLines = new String[this.lines.length + newTextLines.length - 1];
            for (i = 0; i < startLine; ++i) {
                newLines[i] = this.lines[i];
            }
            newLines[i++] = this.lines[startLine].substring(0, range.getFirstCol()) + newTextLines[0];
            for (int j = 1; j < newTextLines.length - 1; ++j) {
                this.lines[i++] = newTextLines[j];
            }
            newLines[i++] = newTextLines[newTextLines.length - 1] + this.lines[endLine].substring(range.getLastCol() + 1);
            while (i < newLines.length) {
                newLines[i] = this.lines[i - newTextLines.length + 1];
                ++i;
            }
            this.lines = newLines;
        }
    }
}

