/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.cast.ipa.callgraph.AstCallGraph;
import com.ibm.wala.cast.ir.ssa.AstLexicalRead;
import com.ibm.wala.cast.util.TargetLanguageSelector;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.core.util.strings.Atom;
import com.ibm.wala.ipa.callgraph.AnalysisOptions;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.IAnalysisCacheView;
import com.ibm.wala.ipa.callgraph.impl.AbstractRootMethod;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ipa.callgraph.impl.FakeRootMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.Descriptor;
import com.ibm.wala.types.FieldReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeName;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.CancelException;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.debug.Assertions;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CrossLanguageCallGraph
extends AstCallGraph {
    private final TargetLanguageSelector<AbstractRootMethod, CrossLanguageCallGraph> roots;
    private final Set<CGNode> languageRootNodes = HashSetFactory.make();
    private final Map<Atom, IMethod> languageRoots = HashMapFactory.make();
    public static ClassLoaderReference crossCoreLoader = ClassLoaderReference.Primordial;
    public static TypeReference fakeRootClass = TypeReference.findOrCreate((ClassLoaderReference)crossCoreLoader, (TypeName)TypeName.findOrCreate((String)"CrossFakeRoot"));
    public static MethodReference rootMethod = MethodReference.findOrCreate((TypeReference)fakeRootClass, (Atom)FakeRootMethod.name, (Descriptor)FakeRootMethod.descr);

    public CrossLanguageCallGraph(TargetLanguageSelector<AbstractRootMethod, CrossLanguageCallGraph> roots, IMethod fakeRootClass2, AnalysisOptions options, IAnalysisCacheView cache) {
        super(fakeRootClass2, options, cache);
        this.roots = roots;
    }

    public AbstractRootMethod getLanguageRoot(Atom language) {
        if (!this.languageRoots.containsKey(language)) {
            AbstractRootMethod languageRoot = this.roots.get(language, this);
            CGNode languageRootNode = null;
            try {
                languageRootNode = this.findOrCreateNode((IMethod)languageRoot, (Context)Everywhere.EVERYWHERE);
            }
            catch (CancelException e) {
                e.printStackTrace();
                Assertions.UNREACHABLE();
            }
            this.languageRootNodes.add(languageRootNode);
            CallSiteReference site = CallSiteReference.make((int)1, (MethodReference)languageRoot.getReference(), (IInvokeInstruction.IDispatch)IInvokeInstruction.Dispatch.STATIC);
            CGNode fakeRootNode = this.getFakeRootNode();
            CrossLanguageFakeRoot fakeRootMethod = (CrossLanguageFakeRoot)fakeRootNode.getMethod();
            site = fakeRootMethod.addInvocationInternal(new int[0], site).getCallSite();
            fakeRootNode.addTarget(site, languageRootNode);
            this.languageRoots.put(language, (IMethod)languageRoot);
        }
        return (AbstractRootMethod)this.languageRoots.get(language);
    }

    Iterator<CGNode> getLanguageRoots() {
        return this.languageRootNodes.iterator();
    }

    protected CGNode makeFakeRootNode() throws CancelException {
        return this.findOrCreateNode((IMethod)new CrossLanguageFakeRoot(this.cha, this.options, this.getAnalysisCache()), (Context)Everywhere.EVERYWHERE);
    }

    public class CrossLanguageFakeRoot
    extends AstCallGraph.ScriptFakeRoot {
        public CrossLanguageFakeRoot(IClass declaringClass, IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            super(rootMethod, declaringClass, cha, options, cache);
        }

        public CrossLanguageFakeRoot(IClassHierarchy cha, AnalysisOptions options, IAnalysisCacheView cache) {
            super(rootMethod, cha, options, cache);
        }

        public int addPhi(TypeReference type, int[] values) {
            Atom language = type.getClassLoader().getLanguage();
            AbstractRootMethod root = CrossLanguageCallGraph.this.getLanguageRoot(language);
            return root.addPhi(values);
        }

        public int addGetInstance(FieldReference ref, int object) {
            TypeReference type = ref.getDeclaringClass();
            Atom language = type.getClassLoader().getLanguage();
            AbstractRootMethod root = CrossLanguageCallGraph.this.getLanguageRoot(language);
            return root.addGetInstance(ref, object);
        }

        public int addGetStatic(FieldReference ref) {
            TypeReference type = ref.getDeclaringClass();
            Atom language = type.getClassLoader().getLanguage();
            AbstractRootMethod root = CrossLanguageCallGraph.this.getLanguageRoot(language);
            return root.addGetStatic(ref);
        }

        public int addCheckcast(TypeReference[] type, int rv, boolean isPEI) {
            Atom language = type[0].getClassLoader().getLanguage();
            AbstractRootMethod root = CrossLanguageCallGraph.this.getLanguageRoot(language);
            return root.addCheckcast(type, rv, isPEI);
        }

        @Override
        public SSANewInstruction addAllocation(TypeReference type) {
            Atom language = type.getClassLoader().getLanguage();
            AbstractRootMethod root = CrossLanguageCallGraph.this.getLanguageRoot(language);
            return root.addAllocation(type);
        }

        public SSAAbstractInvokeInstruction addInvocation(int[] params, CallSiteReference site) {
            TypeReference type = site.getDeclaredTarget().getDeclaringClass();
            Atom language = type.getClassLoader().getLanguage();
            AbstractRootMethod root = CrossLanguageCallGraph.this.getLanguageRoot(language);
            return root.addInvocation(params, site);
        }

        public SSAAbstractInvokeInstruction addInvocationInternal(int[] params, CallSiteReference site) {
            return super.addInvocation(params, site);
        }

        @Override
        public AstLexicalRead addGlobalRead(TypeReference type, String name) {
            Atom language = type.getClassLoader().getLanguage();
            AbstractRootMethod root = CrossLanguageCallGraph.this.getLanguageRoot(language);
            return ((AstCallGraph.AstFakeRoot)root).addGlobalRead(type, name);
        }

        @Override
        public SSAAbstractInvokeInstruction addDirectCall(int functionVn, int[] argVns, CallSiteReference callSite) {
            TypeReference type = callSite.getDeclaredTarget().getDeclaringClass();
            Atom language = type.getClassLoader().getLanguage();
            AbstractRootMethod root = CrossLanguageCallGraph.this.getLanguageRoot(language);
            return ((AstCallGraph.ScriptFakeRoot)root).addDirectCall(functionVn, argVns, callSite);
        }
    }
}

