/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.impl;

import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstLeafNode;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.util.CAstPrinter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CAstImpl
implements CAst {
    private int nextID = 0;

    @Override
    public String makeUnique() {
        return "id" + this.nextID++;
    }

    @Override
    public CAstNode makeNode(int kind, List<CAstNode> cs) {
        return new CAstNodeImpl(kind, cs);
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode[] cs) {
        ArrayList<CAstNode> children = new ArrayList<CAstNode>(cs.length + 1);
        children.add(c1);
        children.addAll(Arrays.asList(cs));
        return this.makeNode(kind, children);
    }

    @Override
    public CAstNode makeNode(int kind) {
        return this.makeNode(kind, Collections.emptyList());
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1) {
        return this.makeNode(kind, Collections.singletonList(c1));
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode c2) {
        return this.makeNode(kind, Arrays.asList(c1, c2));
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode c2, CAstNode c3) {
        return this.makeNode(kind, Arrays.asList(c1, c2, c3));
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode c2, CAstNode c3, CAstNode c4) {
        return this.makeNode(kind, Arrays.asList(c1, c2, c3, c4));
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode c2, CAstNode c3, CAstNode c4, CAstNode c5) {
        return this.makeNode(kind, Arrays.asList(c1, c2, c3, c4, c5));
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode c1, CAstNode c2, CAstNode c3, CAstNode c4, CAstNode c5, CAstNode c6) {
        return this.makeNode(kind, Arrays.asList(c1, c2, c3, c4, c5, c6));
    }

    @Override
    public CAstNode makeNode(int kind, CAstNode ... cs) {
        return this.makeNode(kind, Arrays.asList(cs));
    }

    @Override
    public CAstNode makeConstant(Object value) {
        return new CAstValueImpl(value);
    }

    @Override
    public CAstNode makeConstant(boolean value) {
        return this.makeConstant(value ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public CAstNode makeConstant(char value) {
        return this.makeConstant(Character.valueOf(value));
    }

    @Override
    public CAstNode makeConstant(short value) {
        return this.makeConstant((Object)value);
    }

    @Override
    public CAstNode makeConstant(int value) {
        return this.makeConstant((Object)value);
    }

    @Override
    public CAstNode makeConstant(long value) {
        return this.makeConstant((Object)value);
    }

    @Override
    public CAstNode makeConstant(float value) {
        return this.makeConstant(Float.valueOf(value));
    }

    @Override
    public CAstNode makeConstant(double value) {
        return this.makeConstant((Object)value);
    }

    protected static class CAstValueImpl
    implements CAstLeafNode {
        protected final Object value;

        protected CAstValueImpl(Object value) {
            this.value = value;
        }

        @Override
        public int getKind() {
            return 300;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "CAstValue: " + this.value;
        }

        public int hashCode() {
            return System.identityHashCode(this) * (this.value == null ? 1 : System.identityHashCode(this.value));
        }
    }

    protected static class CAstNodeImpl
    implements CAstNode {
        protected final List<CAstNode> cs;
        protected final int kind;

        protected CAstNodeImpl(int kind, List<CAstNode> cs) {
            this.kind = kind;
            this.cs = cs;
            for (int i = 0; i < cs.size(); ++i) {
                assert (cs.get(i) != null) : "argument " + i + " is null for node kind " + kind + " [" + CAstPrinter.entityKindAsString(kind) + ']';
            }
        }

        @Override
        public int getKind() {
            return this.kind;
        }

        @Override
        public Object getValue() {
            return null;
        }

        @Override
        public List<CAstNode> getChildren() {
            return this.cs;
        }

        public String toString() {
            return System.identityHashCode(this) + ":" + CAstPrinter.print(this);
        }

        public int hashCode() {
            int code = this.getKind() * (this.getChildCount() + 13);
            for (int i = 0; i < this.getChildCount() && i < 15; ++i) {
                if (this.getChild(i) == null) continue;
                code *= this.getChild(i).getKind();
            }
            return code;
        }
    }
}

