/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.util;

import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import com.ibm.wala.classLoader.IMethod;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;

public class SourceBuffer {
    private String[] lines;
    private final CAstSourcePositionMap.Position p;
    public final CAstSourcePositionMap.Position detail;

    public SourceBuffer(CAstSourcePositionMap.Position p) throws IOException {
        this.p = p;
        try (Reader pr = p.getReader();
             BufferedReader reader = new BufferedReader(pr);){
            String currentLine = null;
            ArrayList<String> lines = new ArrayList<String>();
            int offset = 0;
            int line = 0;
            do {
                if ((currentLine = reader.readLine()) != null) continue;
                this.lines = new String[0];
                this.detail = null;
                return;
            } while (p.getLastOffset() < 0 ? p.getFirstLine() > ++line : p.getFirstOffset() > (offset += currentLine.length() + 1));
            int endOffset = -1;
            int endLine = -1;
            int endColumn = -1;
            int startOffset = -1;
            int startLine = line;
            int startColumn = -1;
            if (p.getLastOffset() >= 0) {
                if (p.getFirstOffset() == offset) {
                    startOffset = p.getFirstOffset();
                    startColumn = 0;
                    lines.add("\n");
                } else {
                    startColumn = startOffset = p.getFirstOffset() - (offset - currentLine.length() - 1);
                    if (offset > p.getLastOffset()) {
                        endOffset = p.getLastOffset() - (offset - currentLine.length() - 1);
                        endLine = line;
                        endColumn = endOffset;
                        lines.add(currentLine.substring(startOffset, endOffset));
                    } else {
                        lines.add(currentLine.substring(startOffset));
                    }
                }
            } else {
                lines.add(currentLine.substring(Math.max(p.getFirstCol(), 0)));
                startColumn = p.getFirstCol();
            }
            while (p.getLastOffset() >= 0 ? p.getLastOffset() >= offset : p.getLastLine() >= line) {
                currentLine = reader.readLine();
                if (currentLine == null) {
                    offset = p.getLastOffset();
                    break;
                }
                offset += currentLine.length() + 1;
                ++line;
                if (p.getLastOffset() >= 0) {
                    if (offset > p.getLastOffset()) {
                        endColumn = currentLine.length() - (offset - p.getLastOffset()) + 1;
                        lines.add(currentLine.substring(0, endColumn));
                        endLine = line;
                        endOffset = p.getLastOffset();
                        break;
                    }
                    lines.add(currentLine);
                    continue;
                }
                if (p.getLastLine() == line) {
                    lines.add(currentLine.substring(0, p.getLastCol()));
                    endColumn = p.getLastCol();
                    endLine = line;
                    endOffset = offset - (currentLine.length() - p.getLastCol());
                    break;
                }
                lines.add(currentLine);
            }
            this.lines = lines.toArray(new String[0]);
            this.detail = new DetailedPosition(endOffset, endLine, endColumn, startColumn, p, startLine, startOffset);
            reader.close();
            pr.close();
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.lines.length; ++i) {
            if (i == this.lines.length - 1) {
                result.append(this.lines[i]);
                continue;
            }
            result.append(this.lines[i]).append('\n');
        }
        return result.toString();
    }

    public void substitute(CAstSourcePositionMap.Position range, String newText) {
        String[] newTextLines;
        int endLine;
        int startLine = range.getFirstLine() - this.p.getFirstLine();
        if (startLine != (endLine = range.getLastLine() - this.p.getFirstLine())) {
            int i;
            String[] newLines = new String[this.lines.length - (endLine - startLine)];
            for (i = 0; i < startLine; ++i) {
                newLines[i] = this.lines[i];
            }
            newLines[i++] = this.lines[startLine].substring(0, range.getFirstCol()) + this.lines[endLine].substring(range.getLastCol());
            while (i < newLines.length) {
                newLines[i] = this.lines[i + (endLine - startLine)];
                ++i;
            }
            this.lines = newLines;
            endLine = startLine;
            final CAstSourcePositionMap.Position hack = range;
            range = new AbstractSourcePosition(){

                public int getFirstLine() {
                    return hack.getFirstLine();
                }

                public int getLastLine() {
                    return hack.getFirstLine();
                }

                public int getFirstCol() {
                    return hack.getFirstCol();
                }

                public int getLastCol() {
                    return hack.getFirstCol();
                }

                public int getFirstOffset() {
                    return hack.getFirstOffset();
                }

                public int getLastOffset() {
                    return hack.getFirstOffset();
                }

                @Override
                public URL getURL() {
                    return hack.getURL();
                }

                @Override
                public Reader getReader() throws IOException {
                    return hack.getReader();
                }
            };
        }
        if ((newTextLines = newText.split("\n")).length == 1) {
            this.lines[startLine] = this.lines[startLine].substring(0, range.getFirstCol()) + newTextLines[0] + this.lines[startLine].substring(range.getLastCol() + 1);
        } else {
            int i;
            String[] newLines = new String[this.lines.length + newTextLines.length - 1];
            for (i = 0; i < startLine; ++i) {
                newLines[i] = this.lines[i];
            }
            newLines[i++] = this.lines[startLine].substring(0, range.getFirstCol()) + newTextLines[0];
            for (int j = 1; j < newTextLines.length - 1; ++j) {
                this.lines[i++] = newTextLines[j];
            }
            newLines[i++] = newTextLines[newTextLines.length - 1] + this.lines[endLine].substring(range.getLastCol() + 1);
            while (i < newLines.length) {
                newLines[i] = this.lines[i - newTextLines.length + 1];
                ++i;
            }
            this.lines = newLines;
        }
    }

    private static final class DetailedPosition
    implements CAstSourcePositionMap.Position {
        private final int endOffset;
        private final int endLine;
        private final int endColumn;
        private final int startColumn;
        private final CAstSourcePositionMap.Position p;
        private final int startLine;
        private final int startOffset;

        private DetailedPosition(int endOffset, int endLine, int endColumn, int startColumn, CAstSourcePositionMap.Position p, int startLine, int startOffset) {
            this.endOffset = endOffset;
            this.endLine = endLine;
            this.endColumn = endColumn;
            this.startColumn = startColumn;
            this.p = p;
            this.startLine = startLine;
            this.startOffset = startOffset;
        }

        public int getFirstLine() {
            return this.startLine;
        }

        public int getLastLine() {
            return this.endLine;
        }

        public int getFirstCol() {
            return this.startColumn;
        }

        public int getLastCol() {
            return this.endColumn;
        }

        public int getFirstOffset() {
            return this.startOffset;
        }

        public int getLastOffset() {
            return this.endOffset;
        }

        public int compareTo(IMethod.SourcePosition o) {
            return this.p.compareTo(o);
        }

        @Override
        public URL getURL() {
            return this.p.getURL();
        }

        @Override
        public Reader getReader() throws IOException {
            return this.p.getReader();
        }
    }
}

