/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.ipa.callgraph;

import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.NewSiteReference;
import com.ibm.wala.classLoader.ProgramCounter;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.CallGraph;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKey;
import com.ibm.wala.ipa.callgraph.propagation.InstanceKeyFactory;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PropagationCallGraphBuilder;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.CompoundIterator;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.collections.Pair;
import java.util.Collection;
import java.util.Iterator;

public abstract class ScopeMappingInstanceKeys
implements InstanceKeyFactory {
    protected final PropagationCallGraphBuilder builder;
    private final InstanceKeyFactory basic;

    protected abstract boolean needsScopeMappingKey(InstanceKey var1);

    public InstanceKey getInstanceKeyForAllocation(CGNode creatorNode, NewSiteReference allocationSite) {
        InstanceKey base = this.basic.getInstanceKeyForAllocation(creatorNode, allocationSite);
        if (base != null && this.needsScopeMappingKey(base)) {
            return new ScopeMappingInstanceKey(creatorNode, base);
        }
        return base;
    }

    protected abstract Collection<CGNode> getConstructorCallers(ScopeMappingInstanceKey var1, Pair<String, String> var2);

    public InstanceKey getInstanceKeyForMultiNewArray(CGNode node, NewSiteReference allocation, int dim) {
        return this.basic.getInstanceKeyForMultiNewArray(node, allocation, dim);
    }

    public InstanceKey getInstanceKeyForConstant(TypeReference type, Object S) {
        return this.basic.getInstanceKeyForConstant(type, S);
    }

    public InstanceKey getInstanceKeyForPEI(CGNode node, ProgramCounter instr, TypeReference type) {
        return this.basic.getInstanceKeyForPEI(node, instr, type);
    }

    public InstanceKey getInstanceKeyForMetadataObject(Object obj, TypeReference objType) {
        return this.basic.getInstanceKeyForMetadataObject(obj, objType);
    }

    public ScopeMappingInstanceKeys(PropagationCallGraphBuilder builder, InstanceKeyFactory basic) {
        this.basic = basic;
        this.builder = builder;
    }

    public class ScopeMappingInstanceKey
    implements InstanceKey {
        private final InstanceKey base;
        private final CGNode creator;

        public ScopeMappingInstanceKey(CGNode creator, InstanceKey base) {
            this.creator = creator;
            this.base = base;
        }

        public IClass getConcreteType() {
            return this.base.getConcreteType();
        }

        public Iterator<CGNode> getFunargNodes(Pair<String, String> name) {
            Collection<CGNode> constructorCallers = ScopeMappingInstanceKeys.this.getConstructorCallers(this, name);
            assert (constructorCallers != null && !constructorCallers.isEmpty()) : "no callers for constructor";
            EmptyIterator result = EmptyIterator.instance();
            for (CGNode callerOfConstructor : constructorCallers) {
                if (callerOfConstructor.getMethod().getReference().getDeclaringClass().getName().toString().equals(name.snd)) {
                    result = new CompoundIterator((Iterator)result, (Iterator)new NonNullSingletonIterator((Object)callerOfConstructor));
                    continue;
                }
                PointerKey funcKey = ScopeMappingInstanceKeys.this.builder.getPointerKeyForLocal(callerOfConstructor, 1);
                for (InstanceKey funcPtr : ScopeMappingInstanceKeys.this.builder.getPointerAnalysis().getPointsToSet(funcKey)) {
                    if (funcPtr == this || !(funcPtr instanceof ScopeMappingInstanceKey)) continue;
                    result = new CompoundIterator((Iterator)result, ((ScopeMappingInstanceKey)funcPtr).getFunargNodes(name));
                }
            }
            return result;
        }

        public int hashCode() {
            return this.base.hashCode() * this.creator.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ScopeMappingInstanceKey && ((ScopeMappingInstanceKey)o).base.equals(this.base) && ((ScopeMappingInstanceKey)o).creator.equals(this.creator);
        }

        public String toString() {
            return "SMIK:" + this.base + "@creator:" + this.creator;
        }

        public InstanceKey getBase() {
            return this.base;
        }

        public CGNode getCreator() {
            return this.creator;
        }

        public Iterator<Pair<CGNode, NewSiteReference>> getCreationSites(CallGraph CG) {
            return new FilterIterator(this.base.getCreationSites(CG), o -> ((CGNode)o.fst).equals(this.creator));
        }
    }
}

