/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.impl;

import com.ibm.wala.cast.tree.CAstControlFlowMap;
import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class CAstControlFlowRecorder
implements CAstControlFlowMap {
    private final CAstSourcePositionMap src;
    private final Map<CAstNode, Object> CAstToNode = new LinkedHashMap<CAstNode, Object>();
    private final Map<Object, CAstNode> nodeToCAst = new LinkedHashMap<Object, CAstNode>();
    private final Map<Key, Object> table = new LinkedHashMap<Key, Object>();
    private final Map<Object, Set<Object>> labelMap = new LinkedHashMap<Object, Set<Object>>();
    private final Map<Object, Set<Object>> sourceMap = new LinkedHashMap<Object, Set<Object>>();
    private Collection<CAstNode> cachedMappedNodes = null;

    public CAstControlFlowRecorder(CAstSourcePositionMap src) {
        this.src = src;
        this.map(EXCEPTION_TO_EXIT, EXCEPTION_TO_EXIT);
    }

    @Override
    public CAstNode getTarget(CAstNode from, Object label) {
        assert (this.CAstToNode.get(from) != null);
        Key key = new Key(label, this.CAstToNode.get(from));
        if (this.table.containsKey(key)) {
            Object target = this.table.get(key);
            assert (this.nodeToCAst.containsKey(target));
            return this.nodeToCAst.get(target);
        }
        return null;
    }

    @Override
    public Collection<Object> getTargetLabels(CAstNode from) {
        Object node = this.CAstToNode.get(from);
        Set<Object> found = this.labelMap.get(node);
        return found == null ? Collections.emptySet() : found;
    }

    public Set<Object> getSourceNodes(CAstNode to) {
        Set<Object> found = this.sourceMap.get(this.CAstToNode.get(to));
        return found == null ? Collections.emptySet() : found;
    }

    @Override
    public Collection<CAstNode> getMappedNodes() {
        Collection<CAstNode> nodes = this.cachedMappedNodes;
        if (nodes == null) {
            nodes = new LinkedHashSet<CAstNode>();
            for (Map.Entry<Key, Object> entry : this.table.entrySet()) {
                nodes.add(this.nodeToCAst.get(entry.getKey().from));
                nodes.add(this.nodeToCAst.get(entry.getValue()));
            }
            this.cachedMappedNodes = nodes;
        }
        return nodes;
    }

    public void add(Object from, Object to, Object label) {
        assert (from != null);
        assert (to != null);
        assert (!(from instanceof CAstNode) || ((CAstNode)from).getKind() != 8 || to != EXCEPTION_TO_EXIT);
        if (this.CAstToNode.containsKey(to)) {
            to = this.CAstToNode.get(to);
        }
        if (this.CAstToNode.containsKey(from)) {
            from = this.CAstToNode.get(from);
        }
        this.table.put(new Key(label, from), to);
        if (!this.labelMap.containsKey(from)) {
            this.labelMap.put(from, HashSetFactory.make((int)2));
        }
        Set<Object> ls = this.labelMap.get(from);
        ls.add(label);
        if (!this.sourceMap.containsKey(to)) {
            this.sourceMap.put(to, HashSetFactory.make((int)2));
        }
        Set<Object> ss = this.sourceMap.get(to);
        ss.add(from);
    }

    public void map(Object node, CAstNode ast) {
        assert (node != null);
        assert (ast != null);
        assert (!this.nodeToCAst.containsKey(node) || this.nodeToCAst.get(node) == ast) : node + " already mapped:\n" + this;
        assert (!this.CAstToNode.containsKey(ast) || this.CAstToNode.get(ast) == node) : ast + " already mapped:\n" + this;
        this.nodeToCAst.put(node, ast);
        this.cachedMappedNodes = null;
        this.CAstToNode.put(ast, node);
    }

    public void addAll(CAstControlFlowMap other) {
        for (CAstNode n : other.getMappedNodes()) {
            if (!this.CAstToNode.containsKey(n)) {
                this.map(n, n);
            }
            for (Object l : other.getTargetLabels(n)) {
                CAstNode to = other.getTarget(n, l);
                this.add(n, to, l);
            }
        }
    }

    public boolean isMapped(Object node) {
        return this.nodeToCAst.containsKey(node);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("control flow map\n");
        for (Map.Entry<Key, Object> entry : this.table.entrySet()) {
            Key key = entry.getKey();
            sb.append(key.from);
            if (this.src != null && this.nodeToCAst.get(key.from) != null && this.src.getPosition(this.nodeToCAst.get(key.from)) != null) {
                sb.append(" (").append(this.src.getPosition(this.nodeToCAst.get(key.from))).append(") ");
            }
            sb.append(" -- ");
            sb.append(key.label);
            sb.append(" --> ");
            sb.append(entry.getValue());
            sb.append('\n');
        }
        sb.append('\n');
        return sb.toString();
    }

    private static class Key {
        private final Object label;
        private final Object from;

        Key(Object label, Object from) {
            assert (from != null);
            this.from = from;
            this.label = label;
        }

        public int hashCode() {
            if (this.label != null) {
                return this.from.hashCode() * this.label.hashCode();
            }
            return this.from.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Key && this.from == ((Key)o).from && Objects.equals(this.label, ((Key)o).label);
        }

        public String toString() {
            return "<key " + this.label + " : " + this.from + ">";
        }
    }
}

