/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.tree.impl;

import com.ibm.wala.cast.tree.CAstNode;
import com.ibm.wala.cast.tree.CAstSourcePositionMap;
import com.ibm.wala.cast.tree.impl.AbstractSourcePosition;
import com.ibm.wala.cast.tree.impl.LineNumberPosition;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeSet;

public class CAstSourcePositionRecorder
implements CAstSourcePositionMap {
    private final Map<CAstNode, CAstSourcePositionMap.Position> positions = HashMapFactory.make();

    @Override
    public CAstSourcePositionMap.Position getPosition(CAstNode n) {
        return this.positions.get(n);
    }

    @Override
    public Iterator<CAstNode> getMappedNodes() {
        return this.positions.keySet().iterator();
    }

    public void setPosition(CAstNode n, CAstSourcePositionMap.Position p) {
        this.positions.put(n, p);
    }

    public void setPosition(CAstNode n, int fl, int fc, int ll, int lc, String url, String file) throws MalformedURLException {
        this.setPosition(n, fl, fc, ll, lc, new URL(url), new URL(file));
    }

    public void setPosition(CAstNode n, final int fl, final int fc, final int ll, final int lc, final URL url, final URL file) {
        this.setPosition(n, new AbstractSourcePosition(){

            public int getFirstLine() {
                return fl;
            }

            public int getLastLine() {
                return ll;
            }

            public int getFirstCol() {
                return fc;
            }

            public int getLastCol() {
                return lc;
            }

            public int getFirstOffset() {
                return -1;
            }

            public int getLastOffset() {
                return -1;
            }

            @Override
            public URL getURL() {
                return url;
            }

            @Override
            public Reader getReader() throws IOException {
                return new InputStreamReader(file.openConnection().getInputStream());
            }

            @Override
            public String toString() {
                return "[" + fl + ":" + fc + "]->[" + ll + ":" + lc + "]";
            }
        });
    }

    public void setPosition(CAstNode n, int lineNumber, String url, String file) throws MalformedURLException {
        this.setPosition(n, lineNumber, new URL(url), new URL(file));
    }

    public void setPosition(CAstNode n, int lineNumber, URL url, URL file) {
        this.setPosition(n, new LineNumberPosition(url, file, lineNumber));
    }

    public void addAll(CAstSourcePositionMap other) {
        for (CAstNode node : Iterator2Iterable.make(other.getMappedNodes())) {
            this.setPosition(node, other.getPosition(node));
        }
    }

    @Override
    public NavigableSet<CAstSourcePositionMap.Position> positions() {
        return new TreeSet<CAstSourcePositionMap.Position>(this.positions.values());
    }
}

