/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrikeCT.ClassConstants;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import java.util.ArrayList;
import java.util.HashMap;

public class ClassWriter
implements ClassConstants {
    private int majorVersion = 46;
    private int minorVersion = 0;
    private ConstantPoolParser rawCP;
    private HashMap<Object, Integer> cachedCPEntries = new HashMap(1);
    private final ArrayList<Object> newCPEntries = new ArrayList(1);
    private int nextCPIndex = 1;
    private final ArrayList<Element> fields = new ArrayList(1);
    private final ArrayList<Element> methods = new ArrayList(1);
    private final ArrayList<Element> classAttributes = new ArrayList(1);
    private int thisClass;
    private int superClass;
    private int[] superInterfaces;
    private int accessFlags;
    private boolean forceAddCPEntries = false;
    private byte[] buf;
    private int bufLen;
    private static final char[] noChars = new char[0];

    public void setMajorVersion(int major) {
        if (major < 0 || major > 65535) {
            throw new IllegalArgumentException("Major version out of range: " + major);
        }
        this.majorVersion = major;
    }

    public void setMinorVersion(int minor) {
        if (minor < 0 || minor > 65535) {
            throw new IllegalArgumentException("Major version out of range: " + minor);
        }
        this.minorVersion = minor;
    }

    public void setRawCP(ConstantPoolParser cp, boolean cacheEntries) throws InvalidClassFileException, IllegalArgumentException {
        if (cp == null) {
            throw new IllegalArgumentException();
        }
        if (this.rawCP != null) {
            throw new IllegalArgumentException("Cannot set raw constant pool twice");
        }
        if (this.nextCPIndex != 1) {
            throw new IllegalArgumentException("Cannot set raw constant pool after allocating new entries");
        }
        this.rawCP = cp;
        this.nextCPIndex = cp.getItemCount();
        if (cacheEntries) {
            block13: for (int i = 1; i < this.nextCPIndex; ++i) {
                byte t = cp.getItemType(i);
                switch (t) {
                    case 8: {
                        this.cachedCPEntries.put(new CWStringItem(cp.getCPString(i), 8), i);
                        continue block13;
                    }
                    case 7: {
                        this.cachedCPEntries.put(new CWStringItem(cp.getCPClass(i), 7), i);
                        continue block13;
                    }
                    case 16: {
                        this.cachedCPEntries.put(new CWStringItem(cp.getCPMethodType(i), 16), i);
                        continue block13;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 15: {
                        this.cachedCPEntries.put(new CWRef(t, cp.getCPRefClass(i), cp.getCPRefName(i), cp.getCPRefType(i)), i);
                        continue block13;
                    }
                    case 12: {
                        this.cachedCPEntries.put(new CWNAT(cp.getCPNATName(i), cp.getCPNATType(i)), i);
                        continue block13;
                    }
                    case 18: {
                        this.cachedCPEntries.put(new CWInvokeDynamic(cp.getCPDynBootstrap(i), cp.getCPDynName(i), cp.getCPDynType(i)), i);
                        continue block13;
                    }
                    case 3: {
                        this.cachedCPEntries.put(cp.getCPInt(i), i);
                        continue block13;
                    }
                    case 4: {
                        this.cachedCPEntries.put(Float.valueOf(cp.getCPFloat(i)), i);
                        continue block13;
                    }
                    case 5: {
                        this.cachedCPEntries.put(cp.getCPLong(i), i);
                        continue block13;
                    }
                    case 6: {
                        this.cachedCPEntries.put(cp.getCPDouble(i), i);
                        continue block13;
                    }
                    case 1: {
                        this.cachedCPEntries.put(cp.getCPUtf8(i), i);
                        continue block13;
                    }
                    default: {
                        throw new UnsupportedOperationException(String.format("unexpected constant-pool item type %s", t));
                    }
                }
            }
        }
    }

    public void setForceAddCPEntries(boolean force) {
        this.forceAddCPEntries = force;
    }

    protected int addCPEntry(Object o, int size) {
        Integer i;
        if (this.cachedCPEntries == null) {
            throw new IllegalArgumentException("Cannot add a new constant pool entry during makeBytes() processing!");
        }
        Integer n = i = this.forceAddCPEntries ? null : this.cachedCPEntries.get(o);
        if (i != null) {
            return i;
        }
        int index = this.nextCPIndex;
        this.nextCPIndex += size;
        i = index;
        this.cachedCPEntries.put(o, i);
        this.newCPEntries.add(o);
        if (this.nextCPIndex > 65535) {
            throw new IllegalArgumentException("Constant pool item count exceeded");
        }
        return index;
    }

    public int addCPUtf8(String s) {
        return this.addCPEntry(s, 1);
    }

    public int addCPInt(int i) {
        return this.addCPEntry(i, 1);
    }

    public int addCPFloat(float f) {
        return this.addCPEntry(Float.valueOf(f), 1);
    }

    public int addCPLong(long l) {
        return this.addCPEntry(l, 2);
    }

    public int addCPDouble(double d) {
        return this.addCPEntry(d, 2);
    }

    private int addCPString(String s, byte type) {
        if (s == null) {
            throw new IllegalArgumentException("null s: " + s);
        }
        return this.addCPEntry(new CWStringItem(s, type), 1);
    }

    public int addCPMethodHandle(ConstantPoolParser.ReferenceToken c) {
        if (c == null) {
            throw new IllegalArgumentException("null c: " + c);
        }
        return this.addCPEntry(new CWHandle(15, c.getKind(), c.getClassName(), c.getElementName(), c.getDescriptor()), 1);
    }

    public int addCPString(String s) {
        return this.addCPString(s, (byte)8);
    }

    public int addCPClass(String s) {
        return this.addCPString(s, (byte)7);
    }

    public int addCPMethodType(String s) {
        return this.addCPString(s, (byte)16);
    }

    public int addCPFieldRef(String c, String n, String t) {
        return this.addCPEntry(new CWRef(9, c, n, t), 1);
    }

    public int addCPMethodRef(String c, String n, String t) {
        return this.addCPEntry(new CWRef(10, c, n, t), 1);
    }

    public int addCPInterfaceMethodRef(String c, String n, String t) {
        return this.addCPEntry(new CWRef(11, c, n, t), 1);
    }

    public int addCPNAT(String n, String t) {
        return this.addCPEntry(new CWNAT(n, t), 1);
    }

    public int addCPInvokeDynamic(BootstrapMethodsReader.BootstrapMethod b, String n, String t) {
        return this.addCPEntry(new CWInvokeDynamic(b, n, t), 1);
    }

    public void setAccessFlags(int f) {
        if (f < 0 || f > 65535) {
            throw new IllegalArgumentException("Access flags out of range: " + f);
        }
        this.accessFlags = f;
    }

    public void setNameIndex(int c) throws IllegalArgumentException {
        if (c < 1 || c > 65535) {
            throw new IllegalArgumentException("Class name index out of range: " + c);
        }
        this.thisClass = c;
    }

    public void setSuperNameIndex(int c) {
        if (c < 0 || c > 65535) {
            throw new IllegalArgumentException("Superclass name index out of range: " + c);
        }
        this.superClass = c;
    }

    public void setInterfaceNameIndices(int[] ifaces) {
        if (ifaces != null) {
            if (ifaces.length > 65535) {
                throw new IllegalArgumentException("Too many interfaces implemented: " + ifaces.length);
            }
            for (int c : ifaces) {
                if (c >= 1 && c <= 65535) continue;
                throw new IllegalArgumentException("Interface name index out of range: " + c);
            }
        }
        this.superInterfaces = ifaces;
    }

    public void setName(String c) {
        this.setNameIndex(this.addCPClass(c));
    }

    public void setSuperName(String c) {
        this.setSuperNameIndex(c == null ? 0 : this.addCPClass(c));
    }

    public void setInterfaceNames(String[] ifaces) {
        if (ifaces == null) {
            this.setInterfaceNameIndices(null);
        } else {
            int[] ifs = new int[ifaces.length];
            for (int i = 0; i < ifaces.length; ++i) {
                ifs[i] = this.addCPClass(ifaces[i]);
            }
            this.setInterfaceNameIndices(ifs);
        }
    }

    public void addRawMethod(Element e) {
        this.methods.add(e);
    }

    public void addRawField(Element e) {
        this.fields.add(e);
    }

    public void addMethod(int access, String name, String type, Element[] attributes) {
        this.addMethod(access, this.addCPUtf8(name), this.addCPUtf8(type), attributes);
    }

    public void addField(int access, String name, String type, Element[] attributes) {
        this.addField(access, this.addCPUtf8(name), this.addCPUtf8(type), attributes);
    }

    public void addMethod(int access, int name, int type, Element[] attributes) {
        this.methods.add(new MemberElement(access, name, type, attributes));
        if (this.methods.size() > 65535) {
            throw new IllegalArgumentException("Too many methods");
        }
    }

    public void addField(int access, int name, int type, Element[] attributes) {
        this.fields.add(new MemberElement(access, name, type, attributes));
        if (this.fields.size() > 65535) {
            throw new IllegalArgumentException("Too many fields");
        }
    }

    public void addClassAttribute(Element attribute) {
        this.classAttributes.add(attribute);
        if (this.classAttributes.size() > 65535) {
            throw new IllegalArgumentException("Too many class attributes: " + this.classAttributes.size());
        }
    }

    private int reserveBuf(int size) {
        if (this.buf == null) {
            this.buf = new byte[size];
        } else if (this.bufLen + size > this.buf.length) {
            byte[] newBuf = new byte[Math.max(this.buf.length * 2, this.bufLen + size)];
            System.arraycopy(this.buf, 0, newBuf, 0, this.bufLen);
            this.buf = newBuf;
        }
        int offset = this.bufLen;
        this.bufLen += size;
        return offset;
    }

    private void emitElement(Element e) {
        int size = e.getSize();
        int offset = this.reserveBuf(size);
        int finalOffset = e.copyInto(this.buf, offset);
        if (finalOffset - offset != size) {
            throw new Error("Element failed to output the promised bytes: promised " + size + ", got " + (finalOffset - offset));
        }
    }

    private void emitConstantPool() {
        if (this.rawCP != null) {
            int len = this.rawCP.getRawSize();
            int offset = this.reserveBuf(len);
            System.arraycopy(this.rawCP.getRawBytes(), this.rawCP.getRawOffset(), this.buf, offset, len);
        }
        char[] chars = noChars;
        for (int i = 0; i < this.newCPEntries.size(); ++i) {
            int offset;
            Object o = this.newCPEntries.get(i);
            if (o instanceof CWItem) {
                CWItem item = (CWItem)o;
                byte t = item.getType();
                block0 : switch (t) {
                    case 7: 
                    case 8: 
                    case 16: {
                        offset = this.reserveBuf(3);
                        ClassWriter.setUShort(this.buf, offset + 1, this.addCPUtf8(((CWStringItem)item).s));
                        break;
                    }
                    case 12: {
                        offset = this.reserveBuf(5);
                        CWNAT nat = (CWNAT)item;
                        ClassWriter.setUShort(this.buf, offset + 1, this.addCPUtf8(nat.n));
                        ClassWriter.setUShort(this.buf, offset + 3, this.addCPUtf8(nat.t));
                        break;
                    }
                    case 18: {
                        offset = this.reserveBuf(5);
                        CWInvokeDynamic inv = (CWInvokeDynamic)item;
                        ClassWriter.setUShort(this.buf, offset + 1, inv.b.getIndexInClassFile());
                        ClassWriter.setUShort(this.buf, offset + 3, this.addCPNAT(inv.n, inv.t));
                        break;
                    }
                    case 15: {
                        offset = this.reserveBuf(4);
                        CWHandle handle = (CWHandle)item;
                        byte kind = handle.getKind();
                        ClassWriter.setUByte(this.buf, offset + 1, kind);
                        switch (kind) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                int x = this.addCPFieldRef(handle.c, handle.n, handle.t);
                                ClassWriter.setUShort(this.buf, offset + 2, x);
                                break block0;
                            }
                            case 5: 
                            case 8: {
                                int x = this.addCPMethodRef(handle.c, handle.n, handle.t);
                                ClassWriter.setUShort(this.buf, offset + 2, x);
                                break block0;
                            }
                            case 6: 
                            case 7: {
                                int x = this.addCPMethodRef(handle.c, handle.n, handle.t);
                                ClassWriter.setUShort(this.buf, offset + 2, x);
                                break block0;
                            }
                            case 9: {
                                int x = this.addCPInterfaceMethodRef(handle.c, handle.n, handle.t);
                                ClassWriter.setUShort(this.buf, offset + 2, x);
                                break block0;
                            }
                        }
                        throw new UnsupportedOperationException(String.format("unexpected ref kind %s", kind));
                    }
                    case 9: 
                    case 10: 
                    case 11: {
                        offset = this.reserveBuf(5);
                        CWRef ref = (CWRef)item;
                        ClassWriter.setUShort(this.buf, offset + 1, this.addCPClass(ref.c));
                        ClassWriter.setUShort(this.buf, offset + 3, this.addCPNAT(ref.n, ref.t));
                        break;
                    }
                    default: {
                        throw new Error("Invalid type: " + t);
                    }
                }
                this.buf[offset] = t;
                continue;
            }
            if (o instanceof String) {
                String s = (String)o;
                int slen = s.length();
                if (chars.length < slen) {
                    chars = new char[slen];
                }
                s.getChars(0, slen, chars, 0);
                offset = this.reserveBuf(3);
                this.buf[offset] = 1;
                int maxBytes = slen * 3;
                int p = this.reserveBuf(maxBytes);
                for (int j = 0; j < slen; ++j) {
                    char ch = chars[j];
                    if (ch == '\u0000') {
                        ClassWriter.setUShort(this.buf, p, 49280);
                        p += 2;
                        continue;
                    }
                    if (ch < '\u0080') {
                        this.buf[p] = (byte)ch;
                        ++p;
                        continue;
                    }
                    if (ch < '\u0800') {
                        this.buf[p] = (byte)(ch >> 6 | 0xC0);
                        this.buf[p + 1] = (byte)(ch & 0x3F | 0x80);
                        p += 2;
                        continue;
                    }
                    this.buf[p] = (byte)(ch >> 12 | 0xE0);
                    this.buf[p + 1] = (byte)(ch >> 6 & 0x3F | 0x80);
                    this.buf[p + 2] = (byte)(ch & 0x3F | 0x80);
                    p += 3;
                }
                int bytes = p - (offset + 3);
                this.reserveBuf(bytes - maxBytes);
                if (bytes > 65535) {
                    throw new IllegalArgumentException("String too long: " + bytes + " bytes");
                }
                ClassWriter.setUShort(this.buf, offset + 1, bytes);
                continue;
            }
            if (o instanceof Integer) {
                int offset2 = this.reserveBuf(5);
                this.buf[offset2] = 3;
                ClassWriter.setInt(this.buf, offset2 + 1, (Integer)o);
                continue;
            }
            if (o instanceof Long) {
                int offset3 = this.reserveBuf(9);
                this.buf[offset3] = 5;
                ClassWriter.setLong(this.buf, offset3 + 1, (Long)o);
                continue;
            }
            if (o instanceof Float) {
                int offset4 = this.reserveBuf(5);
                this.buf[offset4] = 4;
                ClassWriter.setFloat(this.buf, offset4 + 1, ((Float)o).intValue());
                continue;
            }
            if (!(o instanceof Double)) continue;
            int offset5 = this.reserveBuf(9);
            this.buf[offset5] = 6;
            ClassWriter.setDouble(this.buf, offset5 + 1, ((Double)o).intValue());
        }
    }

    public byte[] makeBytes() throws IllegalArgumentException {
        if (this.buf != null) {
            throw new IllegalArgumentException("Can't call makeBytes() twice");
        }
        if (this.thisClass == 0) {
            throw new IllegalArgumentException("No class name set");
        }
        this.reserveBuf(10);
        ClassWriter.setInt(this.buf, 0, -889275714);
        ClassWriter.setUShort(this.buf, 4, this.minorVersion);
        ClassWriter.setUShort(this.buf, 6, this.majorVersion);
        this.emitConstantPool();
        ClassWriter.setUShort(this.buf, 8, this.nextCPIndex);
        this.cachedCPEntries = null;
        int offset = this.reserveBuf(8);
        ClassWriter.setUShort(this.buf, offset, this.accessFlags);
        ClassWriter.setUShort(this.buf, offset + 2, this.thisClass);
        ClassWriter.setUShort(this.buf, offset + 4, this.superClass);
        if (this.superInterfaces != null) {
            ClassWriter.setUShort(this.buf, offset + 6, this.superInterfaces.length);
            this.reserveBuf(this.superInterfaces.length * 2);
            for (int i = 0; i < this.superInterfaces.length; ++i) {
                ClassWriter.setUShort(this.buf, offset + 8 + i * 2, this.superInterfaces[i]);
            }
        } else {
            ClassWriter.setUShort(this.buf, offset + 6, 0);
        }
        offset = this.reserveBuf(2);
        int numFields = this.fields.size();
        ClassWriter.setUShort(this.buf, offset, numFields);
        for (int i = 0; i < numFields; ++i) {
            this.emitElement(this.fields.get(i));
        }
        offset = this.reserveBuf(2);
        int numMethods = this.methods.size();
        ClassWriter.setUShort(this.buf, offset, numMethods);
        for (int i = 0; i < numMethods; ++i) {
            this.emitElement(this.methods.get(i));
        }
        offset = this.reserveBuf(2);
        int numAttrs = this.classAttributes.size();
        ClassWriter.setUShort(this.buf, offset, numAttrs);
        for (int i = 0; i < numAttrs; ++i) {
            this.emitElement(this.classAttributes.get(i));
        }
        if (this.buf.length == this.bufLen) {
            return this.buf;
        }
        byte[] b = new byte[this.bufLen];
        System.arraycopy(this.buf, 0, b, 0, this.bufLen);
        return b;
    }

    public static void setUByte(byte[] buf, int offset, int v) throws IllegalArgumentException {
        if (buf == null) {
            throw new IllegalArgumentException("buf is null");
        }
        try {
            buf[offset] = (byte)v;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid offset: " + offset, e);
        }
    }

    public static void setInt(byte[] buf, int offset, int v) throws IllegalArgumentException {
        if (buf == null) {
            throw new IllegalArgumentException("buf is null");
        }
        try {
            buf[offset] = (byte)(v >> 24);
            buf[offset + 1] = (byte)(v >> 16);
            buf[offset + 2] = (byte)(v >> 8);
            buf[offset + 3] = (byte)v;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("illegal offset " + offset, e);
        }
    }

    public static void setLong(byte[] buf, int offset, long v) throws IllegalArgumentException {
        ClassWriter.setInt(buf, offset, (int)(v >> 32));
        ClassWriter.setInt(buf, offset + 4, (int)v);
    }

    public static void setFloat(byte[] buf, int offset, float v) throws IllegalArgumentException {
        ClassWriter.setInt(buf, offset, Float.floatToIntBits(v));
    }

    public static void setDouble(byte[] buf, int offset, double v) throws IllegalArgumentException {
        ClassWriter.setLong(buf, offset, Double.doubleToRawLongBits(v));
    }

    public static void setUShort(byte[] buf, int offset, int v) throws IllegalArgumentException {
        if (buf == null) {
            throw new IllegalArgumentException("buf is null");
        }
        if (offset < 0 || offset + 1 >= buf.length) {
            throw new IllegalArgumentException("buf is too short " + buf.length + ' ' + offset);
        }
        try {
            buf[offset] = (byte)(v >> 8);
            buf[offset + 1] = (byte)v;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid offset: " + offset, e);
        }
    }

    static final class MemberElement
    extends Element {
        private final int access;
        private final int name;
        private final int type;
        private final Element[] attributes;

        public MemberElement(int access, int name, int type, Element[] attributes) {
            if (access < 0 || access > 65535) {
                throw new IllegalArgumentException("Access flags out of range: " + access);
            }
            if (name < 1 || name > 65535) {
                throw new IllegalArgumentException("Name constant pool index out of range: " + name);
            }
            if (type < 1 || type > 65535) {
                throw new IllegalArgumentException("Type constant pool index out of range: " + name);
            }
            if (attributes == null) {
                throw new IllegalArgumentException("Atrtributes are null");
            }
            if (attributes.length > 65535) {
                throw new IllegalArgumentException("Too many attributes: " + attributes.length);
            }
            this.access = access;
            this.name = name;
            this.type = type;
            this.attributes = attributes;
        }

        @Override
        public int getSize() {
            int size = 8;
            if (this.attributes != null) {
                for (Element attribute : this.attributes) {
                    size += attribute.getSize();
                }
            }
            return size;
        }

        @Override
        public int copyInto(byte[] buf, int offset) {
            ClassWriter.setUShort(buf, offset, this.access);
            ClassWriter.setUShort(buf, offset + 2, this.name);
            ClassWriter.setUShort(buf, offset + 4, this.type);
            if (this.attributes != null) {
                ClassWriter.setUShort(buf, offset + 6, this.attributes.length);
                offset += 8;
                for (Element attribute : this.attributes) {
                    offset = attribute.copyInto(buf, offset);
                }
            } else {
                ClassWriter.setUShort(buf, offset + 6, 0);
                offset += 8;
            }
            return offset;
        }
    }

    public static final class RawElement
    extends Element {
        private final byte[] buf;
        private final int offset;
        private final int len;

        public RawElement(byte[] buf, int offset, int len) {
            this.buf = buf;
            this.offset = offset;
            this.len = len;
        }

        @Override
        public int getSize() {
            return this.len;
        }

        @Override
        public int copyInto(byte[] dest, int destOffset) {
            System.arraycopy(this.buf, this.offset, dest, destOffset, this.len);
            return destOffset + this.len;
        }
    }

    public static abstract class Element {
        public abstract int getSize();

        public abstract int copyInto(byte[] var1, int var2);
    }

    static class CWInvokeDynamic
    extends CWItem {
        private final BootstrapMethodsReader.BootstrapMethod b;
        private final String n;
        private final String t;

        CWInvokeDynamic(BootstrapMethodsReader.BootstrapMethod b, String n, String t) {
            this.b = b;
            this.n = n;
            this.t = t;
        }

        public boolean equals(Object o) {
            if (o instanceof CWInvokeDynamic) {
                CWInvokeDynamic r = (CWInvokeDynamic)o;
                return r.b.equals(this.b) && r.n.equals(this.n) && r.t.equals(this.t);
            }
            return false;
        }

        public int hashCode() {
            return (this.b.hashCode() << 10) + (this.n.hashCode() << 3) + this.t.hashCode();
        }

        @Override
        byte getType() {
            return 18;
        }
    }

    static class CWNAT
    extends CWItem {
        private final String n;
        private final String t;

        CWNAT(String n, String t) {
            this.n = n;
            this.t = t;
        }

        public boolean equals(Object o) {
            if (o instanceof CWNAT) {
                CWNAT r = (CWNAT)o;
                return r.n.equals(this.n) && r.t.equals(this.t);
            }
            return false;
        }

        public int hashCode() {
            return (this.n.hashCode() << 3) + this.t.hashCode();
        }

        @Override
        byte getType() {
            return 12;
        }
    }

    static class CWHandle
    extends CWRef {
        private final byte kind;

        CWHandle(byte type, byte kind, String c, String n, String t) {
            super(type, c, n, t);
            this.kind = kind;
        }

        @Override
        public int hashCode() {
            return super.hashCode() * this.kind;
        }

        @Override
        public boolean equals(Object o) {
            return super.equals(o) && ((CWHandle)o).kind == this.kind;
        }

        public byte getKind() {
            return this.kind;
        }
    }

    static class CWRef
    extends CWItem {
        protected final String c;
        protected final String n;
        protected final String t;
        private final byte type;

        CWRef(byte type, String c, String n, String t) {
            this.type = type;
            this.c = c;
            this.n = n;
            this.t = t;
        }

        public boolean equals(Object o) {
            if (o.getClass().equals(this.getClass())) {
                CWRef r = (CWRef)o;
                return r.type == this.type && r.c.equals(this.c) && r.n.equals(this.n) && r.t.equals(this.t);
            }
            return false;
        }

        public int hashCode() {
            return this.type + (this.c.hashCode() << 5) + (this.n.hashCode() << 3) + this.t.hashCode();
        }

        @Override
        byte getType() {
            return this.type;
        }
    }

    public static class CWStringItem
    extends CWItem {
        private final String s;
        private final byte type;

        public CWStringItem(String s, byte type) {
            this.s = s;
            this.type = type;
        }

        public boolean equals(Object o) {
            return o != null && o.getClass().equals(this.getClass()) && ((CWStringItem)o).type == this.type && ((CWStringItem)o).s.equals(this.s);
        }

        public int hashCode() {
            return this.s.hashCode() + 3901 * this.type;
        }

        @Override
        byte getType() {
            return this.type;
        }
    }

    static abstract class CWItem {
        CWItem() {
        }

        abstract byte getType();
    }
}

