/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeCT.ClassWriter;
import java.io.UnsupportedEncodingException;

public class SourceDebugExtensionWriter
extends ClassWriter.Element {
    private final int attrID;
    private byte[] table;

    public SourceDebugExtensionWriter(ClassWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = w.addCPUtf8("SourceDebugExtension");
    }

    @Override
    public int getSize() {
        return this.table == null ? 6 : 6 + this.table.length;
    }

    @Override
    public int copyInto(byte[] buf, int offset) throws IllegalArgumentException {
        ClassWriter.setUShort(buf, offset, this.attrID);
        ClassWriter.setInt(buf, offset + 2, this.getSize() - 6);
        offset += 6;
        if (this.table != null) {
            for (byte element : this.table) {
                ClassWriter.setUByte(buf, offset, element);
                ++offset;
            }
        }
        return offset;
    }

    public void setRawTable(byte[] sourceDebug) {
        if (sourceDebug == null) {
            throw new IllegalArgumentException("sourceDebug is null");
        }
        for (byte element : sourceDebug) {
            if (element >= 1) continue;
            throw new IllegalArgumentException("Invalid CP index: " + element);
        }
        this.table = sourceDebug;
    }

    public void setDebugInfo(String sourceDebug) {
        if (sourceDebug == null) {
            throw new IllegalArgumentException("sourceDebug is null");
        }
        try {
            byte[] bytes = sourceDebug.getBytes("UTF8");
            this.setRawTable(bytes);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
        }
    }
}

