/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT;

import com.ibm.wala.shrikeBT.BinaryOpInstruction;
import com.ibm.wala.shrikeBT.CheckCastInstruction;
import com.ibm.wala.shrikeBT.ConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.Constants;
import com.ibm.wala.shrikeBT.DupInstruction;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.GetInstruction;
import com.ibm.wala.shrikeBT.GotoInstruction;
import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrikeBT.InstanceofInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.InvokeDynamicInstruction;
import com.ibm.wala.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrikeBT.LoadInstruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.NewInstruction;
import com.ibm.wala.shrikeBT.PopInstruction;
import com.ibm.wala.shrikeBT.PutInstruction;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.StoreInstruction;
import com.ibm.wala.shrikeBT.SwapInstruction;
import com.ibm.wala.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Analyzer;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyProvider;
import com.ibm.wala.shrikeBT.analysis.Verifier;
import com.ibm.wala.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrikeCT.ConstantPoolParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;

public abstract class Compiler
implements Constants {
    private final boolean isConstructor;
    private final boolean isStatic;
    private final String classType;
    private final String signature;
    private final IInstruction[] instructions;
    private final ExceptionHandler[][] handlers;
    private final int[] instructionsToBytecodes;
    private static final int[] noRawHandlers = new int[0];
    private ClassHierarchyProvider hierarchy;
    private ConstantPoolReader presetConstants;
    private int[] instructionsToOffsets;
    private BitSet branchTargets;
    private byte[][] stackWords;
    private byte[] code;
    private int allocatedLocals;
    private BitSet[] liveLocals;
    private int[][] backEdges;
    private String[][] localTypes;
    private String[][] stackTypes;
    private int maxLocals;
    private int maxStack;
    private Output mainMethod;
    private ArrayList<Output> auxMethods;
    private static byte[] cachedBuf;

    public Compiler(boolean isConstructor, boolean isStatic, String classType, String signature, IInstruction[] instructions, ExceptionHandler[][] handlers, int[] instructionsToBytecodes) {
        if (instructionsToBytecodes == null) {
            throw new IllegalArgumentException("instructionsToBytecodes is null");
        }
        if (instructions == null) {
            throw new IllegalArgumentException("instructions is null");
        }
        if (handlers == null) {
            throw new IllegalArgumentException("handlers is null");
        }
        if (instructions.length != handlers.length) {
            throw new IllegalArgumentException("Instructions/handlers length mismatch");
        }
        if (instructions.length != instructionsToBytecodes.length) {
            throw new IllegalArgumentException("Instructions/handlers length mismatch");
        }
        this.isConstructor = isConstructor;
        this.isStatic = isStatic;
        this.classType = classType;
        this.signature = signature;
        this.instructions = instructions;
        this.handlers = handlers;
        this.instructionsToBytecodes = instructionsToBytecodes;
    }

    protected Compiler(MethodData info) {
        this(info.getName().equals("<init>"), info.getIsStatic(), info.getClassType(), info.getSignature(), info.getInstructions(), info.getHandlers(), info.getInstructionsToBytecodes());
    }

    public final String getClassType() {
        return this.classType;
    }

    public final void setPresetConstants(ConstantPoolReader cp) {
        this.presetConstants = cp;
    }

    public final void setClassHierarchy(ClassHierarchyProvider h) {
        this.hierarchy = h;
    }

    protected abstract int allocateConstantPoolInteger(int var1);

    protected abstract int allocateConstantPoolFloat(float var1);

    protected abstract int allocateConstantPoolLong(long var1);

    protected abstract int allocateConstantPoolDouble(double var1);

    protected abstract int allocateConstantPoolString(String var1);

    protected abstract int allocateConstantPoolClassType(String var1);

    protected abstract int allocateConstantPoolMethodType(String var1);

    protected abstract int allocateConstantPoolMethodHandle(ConstantPoolParser.ReferenceToken var1);

    protected abstract int allocateConstantPoolField(String var1, String var2, String var3);

    protected abstract int allocateConstantPoolMethod(String var1, String var2, String var3);

    protected abstract int allocateConstantPoolInterfaceMethod(String var1, String var2, String var3);

    protected abstract int allocateConstantPoolInvokeDynamic(BootstrapMethodsReader.BootstrapMethod var1, String var2, String var3);

    protected abstract String createHelperMethod(boolean var1, String var2);

    private void collectInstructionInfo() {
        final BitSet s = new BitSet(this.instructions.length);
        final BitSet localsUsed = new BitSet(32);
        final BitSet localsWide = new BitSet(32);
        IInstruction.Visitor visitor = new IInstruction.Visitor(){

            private void visitTargets(IInstruction instr) {
                int[] ts;
                for (int element : ts = instr.getBranchTargets()) {
                    s.set(element);
                }
            }

            @Override
            public void visitGoto(GotoInstruction instruction) {
                this.visitTargets(instruction);
            }

            @Override
            public void visitLocalStore(IStoreInstruction instruction) {
                localsUsed.set(instruction.getVarIndex());
                String t = instruction.getType();
                if (t.equals("J") || t.equals("D")) {
                    localsWide.set(instruction.getVarIndex());
                }
            }

            @Override
            public void visitConditionalBranch(IConditionalBranchInstruction instruction) {
                this.visitTargets(instruction);
            }

            @Override
            public void visitSwitch(SwitchInstruction instruction) {
                this.visitTargets(instruction);
            }
        };
        for (IInstruction instruction : this.instructions) {
            instruction.visit(visitor);
        }
        String[] paramTypes = Util.getParamsTypes(this.isStatic ? null : "Ljava/lang/Object;", this.signature);
        int index = 0;
        for (String t : paramTypes) {
            localsUsed.set(index);
            if (t.equals("J") || t.equals("D")) {
                localsWide.set(index);
                index += 2;
                continue;
            }
            ++index;
        }
        ExceptionHandler[] lastHS = null;
        for (ExceptionHandler[] hs : this.handlers) {
            if (hs == lastHS) continue;
            for (ExceptionHandler element : hs) {
                s.set(element.handler);
            }
            lastHS = hs;
        }
        this.branchTargets = s;
        int maxUsed = localsUsed.length();
        if (maxUsed > 0 && localsWide.get(maxUsed - 1)) {
            ++maxUsed;
        }
        this.maxLocals = maxUsed;
    }

    private void writeInt(int offset, int v) {
        this.code[offset] = (byte)(v >> 24);
        this.code[offset + 1] = (byte)(v >> 16);
        this.code[offset + 2] = (byte)(v >> 8);
        this.code[offset + 3] = (byte)v;
    }

    private void writeShort(int offset, int v) {
        this.code[offset] = (byte)(v >> 8);
        this.code[offset + 1] = (byte)v;
    }

    private void writeByte(int offset, int v) {
        this.code[offset] = (byte)v;
    }

    private boolean inBasicBlock(int i, int n) {
        if (i + n - 1 >= this.instructions.length) {
            return false;
        }
        for (int j = i + 1; j < i + n; ++j) {
            if (this.branchTargets.get(j)) {
                return false;
            }
            if (!Arrays.equals(this.handlers[j], this.handlers[i])) {
                return false;
            }
            if (this.instructionsToBytecodes[j] == this.instructionsToBytecodes[i]) continue;
            return false;
        }
        return true;
    }

    private void checkStackWordSize(byte[] stackWords, int stackLen) {
        if (stackLen * 2 > this.maxStack) {
            int words = 0;
            for (int i = 0; i < stackLen; ++i) {
                words += stackWords[i];
            }
            if (words > this.maxStack) {
                this.maxStack = words;
            }
        }
    }

    private void computeStackWordsAt(int i, int stackLen, byte[] stackWords, boolean[] visited) {
        while (!visited[i]) {
            ExceptionHandler[] hs;
            int[] bt;
            IInstruction instr = this.instructions[i];
            if (i > 0 && !this.instructions[i - 1].isFallThrough()) {
                byte[] newWords = new byte[stackLen];
                System.arraycopy(stackWords, 0, newWords, 0, stackLen);
                this.stackWords[i] = newWords;
            }
            visited[i] = true;
            if (stackLen < instr.getPoppedCount()) {
                throw new IllegalArgumentException("Stack underflow in intermediate code, at offset " + i);
            }
            if (instr instanceof DupInstruction) {
                DupInstruction d = (DupInstruction)instr;
                int size = d.getSize();
                int delta = d.getDelta();
                System.arraycopy(stackWords, stackLen - size - delta, stackWords, stackLen - delta, delta + size);
                System.arraycopy(stackWords, stackLen, stackWords, stackLen - size - delta, size);
                this.checkStackWordSize(stackWords, stackLen += size);
            } else if (instr instanceof SwapInstruction) {
                int words = stackWords[stackLen - 1];
                for (int j = 0; j < stackLen; ++j) {
                    words += stackWords[j];
                }
                if (words > this.maxStack) {
                    this.maxStack = words;
                }
                byte b = stackWords[stackLen - 2];
                stackWords[stackLen - 2] = stackWords[stackLen - 1];
                stackWords[stackLen - 1] = b;
            } else {
                stackLen -= instr.getPoppedCount();
                byte w = instr.getPushedWordSize();
                if (w > 0) {
                    stackWords[stackLen] = w;
                    this.checkStackWordSize(stackWords, ++stackLen);
                }
            }
            for (int element : bt = instr.getBranchTargets()) {
                int t = element;
                if (t < 0 || t >= visited.length) {
                    throw new IllegalArgumentException("Branch target at offset " + i + " is out of bounds: " + t + " (max " + visited.length + ')');
                }
                if (visited[t]) continue;
                this.computeStackWordsAt(element, stackLen, (byte[])stackWords.clone(), visited);
            }
            for (ExceptionHandler element : hs = this.handlers[i]) {
                int t = element.handler;
                if (visited[t]) continue;
                byte[] newWords = (byte[])stackWords.clone();
                newWords[0] = 1;
                this.computeStackWordsAt(t, 1, newWords, visited);
            }
            if (!instr.isFallThrough()) {
                return;
            }
            ++i;
        }
    }

    private void computeStackWords() {
        this.stackWords = new byte[this.instructions.length][];
        this.maxStack = 0;
        this.computeStackWordsAt(0, 0, new byte[this.instructions.length * 2], new boolean[this.instructions.length]);
    }

    private void insertBranchOffsetInt(ArrayList<Patch> patches, int instrStart, int instrOffset, int targetLabel) {
        if (this.instructionsToOffsets[targetLabel] > 0 || targetLabel == 0) {
            this.writeInt(instrOffset, this.instructionsToOffsets[targetLabel] - instrStart);
        } else {
            patches.add(new IntPatch(instrStart, instrOffset, targetLabel));
        }
    }

    private static boolean applyPatches(ArrayList<Patch> patches) {
        for (Patch p : patches) {
            if (p.apply()) continue;
            return false;
        }
        return true;
    }

    private static synchronized byte[] makeCodeBuf() {
        if (cachedBuf != null) {
            byte[] result = cachedBuf;
            cachedBuf = null;
            return result;
        }
        return new byte[65535];
    }

    private static synchronized void releaseCodeBuf(byte[] buf) {
        cachedBuf = buf;
    }

    private boolean outputInstructions(int startInstruction, int endInstruction, int startOffset, boolean farBranches, byte[] initialStack) {
        this.instructionsToOffsets = new int[this.instructions.length];
        this.code = Compiler.makeCodeBuf();
        ArrayList<Patch> patches = new ArrayList<Patch>();
        int curOffset = startOffset;
        final int[] curOffsetRef = new int[1];
        int stackLen = initialStack == null ? 0 : initialStack.length;
        final int[] stackLenRef = new int[1];
        final byte[] stackWords = new byte[this.maxStack];
        if (stackLen > 0) {
            System.arraycopy(initialStack, 0, stackWords, 0, stackLen);
        }
        int[] instrRef = new int[1];
        IInstruction.Visitor noOpcodeHandler = new IInstruction.Visitor(){

            @Override
            public void visitPop(PopInstruction instruction) {
                int count = instruction.getPoppedCount();
                int offset = curOffsetRef[0];
                int stackLen = stackLenRef[0];
                while (count > 0) {
                    ((Compiler)Compiler.this).code[offset] = (byte)(stackWords[stackLen - 1] == 1 ? 87 : 88);
                    --count;
                    --stackLen;
                    ++offset;
                }
                curOffsetRef[0] = offset;
            }

            @Override
            public void visitDup(DupInstruction instruction) {
                int deltaWords;
                int size = instruction.getSize();
                int delta = instruction.getDelta();
                int offset = curOffsetRef[0];
                int stackLen = stackLenRef[0];
                int sizeWords = stackWords[stackLen - 1];
                if (size == 2) {
                    sizeWords += stackWords[stackLen - 2];
                }
                int n = deltaWords = delta == 0 ? 0 : stackWords[stackLen - 1 - size];
                if (delta == 2) {
                    deltaWords += stackWords[stackLen - 1 - size - 1];
                }
                if (sizeWords > 2 || deltaWords > 2) {
                    throw new IllegalArgumentException("Invalid dup size");
                }
                ((Compiler)Compiler.this).code[offset] = (byte)(89 + 3 * (sizeWords - 1) + deltaWords);
                curOffsetRef[0] = ++offset;
            }

            @Override
            public void visitSwap(SwapInstruction instruction) {
                int offset = curOffsetRef[0];
                int stackLen = stackLenRef[0];
                byte topSize = stackWords[stackLen - 1];
                byte nextSize = stackWords[stackLen - 2];
                if (topSize == 1 && nextSize == 1) {
                    ((Compiler)Compiler.this).code[offset] = 95;
                } else {
                    ((Compiler)Compiler.this).code[offset] = (byte)(89 + 3 * (topSize - 1) + nextSize);
                    ((Compiler)Compiler.this).code[offset + 1] = (byte)(topSize == 1 ? 87 : 88);
                    offset += 2;
                }
                curOffsetRef[0] = ++offset;
            }
        };
        block41: for (int i = startInstruction; i < endInstruction; ++i) {
            int startI;
            Instruction instr;
            block97: {
                block96: {
                    instr = (Instruction)this.instructions[i];
                    short opcode = instr.getOpcode();
                    startI = i;
                    this.instructionsToOffsets[i] = curOffset;
                    if (opcode == -1) break block96;
                    boolean fallToConditional = false;
                    this.code[curOffset] = (byte)opcode;
                    ++curOffset;
                    switch (opcode) {
                        case 3: {
                            ConditionalBranchInstruction cbr;
                            if (this.inBasicBlock(i, 2) && this.instructions[i + 1] instanceof ConditionalBranchInstruction && (cbr = (ConditionalBranchInstruction)this.instructions[i + 1]).getType().equals("I")) {
                                this.code[curOffset - 1] = (byte)(cbr.getOperator().ordinal() + 153);
                                fallToConditional = true;
                                instr = (Instruction)this.instructions[++i];
                            }
                            if (!fallToConditional) break;
                        }
                        case 1: {
                            ConditionalBranchInstruction cbr;
                            if (!fallToConditional && this.inBasicBlock(i, 2) && this.instructions[i + 1] instanceof ConditionalBranchInstruction && (cbr = (ConditionalBranchInstruction)this.instructions[i + 1]).getType().equals("Ljava/lang/Object;")) {
                                this.code[curOffset - 1] = (byte)(cbr.getOperator().ordinal() + 198);
                                fallToConditional = true;
                                instr = (Instruction)this.instructions[++i];
                            }
                            if (!fallToConditional) break;
                        }
                        case 153: 
                        case 154: 
                        case 155: 
                        case 156: 
                        case 157: 
                        case 158: {
                            int delta;
                            int targetI = instr.getBranchTargets()[0];
                            boolean invert = false;
                            int iStart = curOffset - 1;
                            if (this.inBasicBlock(i, 2) && instr.getBranchTargets()[0] == i + 2 && this.instructions[i + 1] instanceof GotoInstruction) {
                                invert = true;
                                targetI = this.instructions[i + 1].getBranchTargets()[0];
                                ++i;
                            }
                            if (targetI <= i) {
                                delta = this.instructionsToOffsets[targetI] - iStart;
                                if ((short)delta != delta) {
                                    invert = !invert;
                                    this.writeShort(curOffset, 8);
                                    this.code[curOffset + 2] = -56;
                                    this.writeInt(curOffset + 3, delta - 3);
                                    curOffset += 7;
                                } else {
                                    this.writeShort(curOffset, (short)delta);
                                    curOffset += 2;
                                }
                            } else {
                                Patch p;
                                if (farBranches) {
                                    invert = !invert;
                                    this.writeShort(curOffset, 8);
                                    this.code[curOffset + 2] = -56;
                                    p = new IntPatch(curOffset + 2, curOffset + 3, targetI);
                                    curOffset += 7;
                                } else {
                                    p = new ShortPatch(iStart, curOffset, targetI);
                                    curOffset += 2;
                                }
                                patches.add(p);
                            }
                            if (!invert) break;
                            this.code[iStart] = (byte)((this.code[iStart] - 153 ^ 1) + 153);
                            break;
                        }
                        case 159: 
                        case 160: 
                        case 161: 
                        case 162: 
                        case 163: 
                        case 164: 
                        case 165: 
                        case 166: {
                            int delta;
                            int targetI = instr.getBranchTargets()[0];
                            boolean invert = false;
                            int iStart = curOffset - 1;
                            if (this.inBasicBlock(i, 2) && instr.getBranchTargets()[0] == i + 2 && this.instructions[i + 1] instanceof GotoInstruction) {
                                invert = true;
                                targetI = this.instructions[i + 1].getBranchTargets()[0];
                                ++i;
                            }
                            if (targetI <= i) {
                                delta = this.instructionsToOffsets[targetI] - iStart;
                                if ((short)delta != delta) {
                                    invert = !invert;
                                    this.writeShort(curOffset, 8);
                                    this.code[curOffset + 2] = -56;
                                    this.writeInt(curOffset + 3, delta - 3);
                                    curOffset += 7;
                                } else {
                                    this.writeShort(curOffset, (short)delta);
                                    curOffset += 2;
                                }
                            } else {
                                Patch p;
                                if (farBranches) {
                                    invert = !invert;
                                    this.writeShort(curOffset, 8);
                                    this.code[curOffset + 2] = -56;
                                    p = new IntPatch(curOffset + 2, curOffset + 3, targetI);
                                    curOffset += 7;
                                } else {
                                    p = new ShortPatch(iStart, curOffset, targetI);
                                    curOffset += 2;
                                }
                                patches.add(p);
                            }
                            if (!invert) break;
                            this.code[iStart] = (byte)((this.code[iStart] - 159 ^ 1) + 159);
                            break;
                        }
                        case 16: {
                            this.writeByte(curOffset, ((ConstantInstruction.ConstInt)instr).getIntValue());
                            ++curOffset;
                            break;
                        }
                        case 17: {
                            this.writeShort(curOffset, ((ConstantInstruction.ConstInt)instr).getIntValue());
                            curOffset += 2;
                            break;
                        }
                        case 19: {
                            int cpIndex;
                            ConstantInstruction ci = (ConstantInstruction)instr;
                            if (this.presetConstants != null && ci.getLazyConstantPool() == this.presetConstants) {
                                cpIndex = ci.getCPIndex();
                            } else {
                                String t;
                                switch (t = instr.getPushedType(null)) {
                                    case "I": {
                                        cpIndex = this.allocateConstantPoolInteger(((ConstantInstruction.ConstInt)instr).getIntValue());
                                        break;
                                    }
                                    case "Ljava/lang/String;": {
                                        cpIndex = this.allocateConstantPoolString((String)((ConstantInstruction.ConstString)instr).getValue());
                                        break;
                                    }
                                    case "Ljava/lang/Class;": {
                                        cpIndex = this.allocateConstantPoolClassType(((ConstantInstruction.ClassToken)((ConstantInstruction.ConstClass)instr).getValue()).getTypeName());
                                        break;
                                    }
                                    case "Ljava/lang/invoke/MethodType;": {
                                        cpIndex = this.allocateConstantPoolMethodType((String)((ConstantInstruction.ConstMethodType)instr).getValue());
                                        break;
                                    }
                                    case "Ljava/lang/invoke/MethodHandle;": {
                                        cpIndex = this.allocateConstantPoolMethodHandle((ConstantPoolParser.ReferenceToken)((ConstantInstruction.ConstMethodHandle)instr).getValue());
                                        break;
                                    }
                                    default: {
                                        cpIndex = this.allocateConstantPoolFloat(((ConstantInstruction.ConstFloat)instr).getFloatValue());
                                    }
                                }
                            }
                            if (cpIndex < 256) {
                                this.code[curOffset - 1] = 18;
                                this.code[curOffset] = (byte)cpIndex;
                                ++curOffset;
                                break;
                            }
                            this.writeShort(curOffset, cpIndex);
                            curOffset += 2;
                            break;
                        }
                        case 20: {
                            String t;
                            ConstantInstruction ci = (ConstantInstruction)instr;
                            int cpIndex = this.presetConstants != null && ci.getLazyConstantPool() == this.presetConstants ? ci.getCPIndex() : ((t = instr.getPushedType(null)).equals("J") ? this.allocateConstantPoolLong(((ConstantInstruction.ConstLong)instr).getLongValue()) : this.allocateConstantPoolDouble(((ConstantInstruction.ConstDouble)instr).getDoubleValue()));
                            this.writeShort(curOffset, cpIndex);
                            curOffset += 2;
                            break;
                        }
                        case 21: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: {
                            if (this.inBasicBlock(i, 4) && this.instructions[i + 1] instanceof ConstantInstruction.ConstInt && this.instructions[i + 2] instanceof BinaryOpInstruction && this.instructions[i + 3] instanceof StoreInstruction) {
                                LoadInstruction i0 = (LoadInstruction)instr;
                                ConstantInstruction.ConstInt i1 = (ConstantInstruction.ConstInt)this.instructions[i + 1];
                                BinaryOpInstruction i2 = (BinaryOpInstruction)this.instructions[i + 2];
                                StoreInstruction i3 = (StoreInstruction)this.instructions[i + 3];
                                int c = i1.getIntValue();
                                int v = i0.getVarIndex();
                                IBinaryOpInstruction.Operator op = i2.getOperator();
                                if ((short)c == c && i3.getVarIndex() == v && (op == IBinaryOpInstruction.Operator.ADD || op == IBinaryOpInstruction.Operator.SUB) && i2.getType().equals("I") && i3.getType().equals("I")) {
                                    if (v < 256 && (byte)c == c) {
                                        this.code[curOffset - 1] = -124;
                                        this.writeByte(curOffset, v);
                                        this.writeByte(curOffset + 1, c);
                                        curOffset += 2;
                                    } else {
                                        this.code[curOffset - 1] = -60;
                                        this.code[curOffset] = -124;
                                        this.writeShort(curOffset + 1, v);
                                        this.writeShort(curOffset + 3, c);
                                        curOffset += 5;
                                    }
                                    this.instructionsToOffsets[i + 1] = -1;
                                    this.instructionsToOffsets[i + 2] = -1;
                                    this.instructionsToOffsets[i + 3] = -1;
                                    i += 3;
                                    break;
                                }
                            }
                            if (opcode != 21) break;
                        }
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            int v = ((LoadInstruction)instr).getVarIndex();
                            if (v < 256) {
                                this.writeByte(curOffset, v);
                                ++curOffset;
                                break;
                            }
                            this.code[curOffset - 1] = -60;
                            this.code[curOffset] = (byte)opcode;
                            this.writeShort(curOffset + 1, v);
                            curOffset += 3;
                            break;
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: {
                            int v = ((StoreInstruction)instr).getVarIndex();
                            if (v < 256) {
                                this.writeByte(curOffset, v);
                                ++curOffset;
                                break;
                            }
                            this.code[curOffset - 1] = -60;
                            this.code[curOffset] = (byte)opcode;
                            this.writeShort(curOffset + 1, v);
                            curOffset += 3;
                            break;
                        }
                        case 167: {
                            Patch p;
                            int targetI = instr.getBranchTargets()[0];
                            if (targetI <= i) {
                                int delta = this.instructionsToOffsets[targetI] - (curOffset - 1);
                                if ((short)delta != delta) {
                                    this.code[curOffset - 1] = -56;
                                    this.writeInt(curOffset, delta);
                                    curOffset += 4;
                                    break;
                                }
                                this.writeShort(curOffset, (short)delta);
                                curOffset += 2;
                                break;
                            }
                            if (targetI == i + 1) {
                                --curOffset;
                                break;
                            }
                            if (farBranches) {
                                this.code[curOffset - 1] = -56;
                                p = new IntPatch(curOffset - 1, curOffset, instr.getBranchTargets()[0]);
                                curOffset += 4;
                            } else {
                                p = new ShortPatch(curOffset - 1, curOffset, instr.getBranchTargets()[0]);
                                curOffset += 2;
                            }
                            patches.add(p);
                            break;
                        }
                        case 171: {
                            int j;
                            int start = curOffset - 1;
                            SwitchInstruction sw = (SwitchInstruction)instr;
                            int[] casesAndLabels = sw.getCasesAndLabels();
                            while ((curOffset & 3) != 0) {
                                this.writeByte(curOffset, 0);
                                ++curOffset;
                            }
                            if (curOffset + 4 * casesAndLabels.length + 8 > this.code.length) {
                                return false;
                            }
                            this.insertBranchOffsetInt(patches, start, curOffset, sw.getDefaultLabel());
                            this.writeInt(curOffset + 4, casesAndLabels.length / 2);
                            curOffset += 8;
                            for (j = 0; j < casesAndLabels.length; j += 2) {
                                this.writeInt(curOffset, casesAndLabels[j]);
                                this.insertBranchOffsetInt(patches, start, curOffset + 4, casesAndLabels[j + 1]);
                                curOffset += 8;
                            }
                            break block97;
                        }
                        case 170: {
                            int j;
                            int start = curOffset - 1;
                            SwitchInstruction sw = (SwitchInstruction)instr;
                            int[] casesAndLabels = sw.getCasesAndLabels();
                            while ((curOffset & 3) != 0) {
                                this.writeByte(curOffset, 0);
                                ++curOffset;
                            }
                            if (curOffset + 2 * casesAndLabels.length + 12 > this.code.length) {
                                return false;
                            }
                            this.insertBranchOffsetInt(patches, start, curOffset, sw.getDefaultLabel());
                            this.writeInt(curOffset + 4, casesAndLabels[0]);
                            this.writeInt(curOffset + 8, casesAndLabels[casesAndLabels.length - 2]);
                            curOffset += 12;
                            for (j = 0; j < casesAndLabels.length; j += 2) {
                                this.insertBranchOffsetInt(patches, start, curOffset, casesAndLabels[j + 1]);
                                curOffset += 4;
                            }
                            break block97;
                        }
                        case 178: 
                        case 180: {
                            GetInstruction g = (GetInstruction)instr;
                            int cpIndex = this.presetConstants != null && this.presetConstants == g.getLazyConstantPool() ? ((GetInstruction.Lazy)g).getCPIndex() : this.allocateConstantPoolField(g.getClassType(), g.getFieldName(), g.getFieldType());
                            this.writeShort(curOffset, cpIndex);
                            curOffset += 2;
                            break;
                        }
                        case 179: 
                        case 181: {
                            PutInstruction p = (PutInstruction)instr;
                            int cpIndex = this.presetConstants != null && this.presetConstants == p.getLazyConstantPool() ? ((PutInstruction.Lazy)p).getCPIndex() : this.allocateConstantPoolField(p.getClassType(), p.getFieldName(), p.getFieldType());
                            this.writeShort(curOffset, cpIndex);
                            curOffset += 2;
                            break;
                        }
                        case 182: 
                        case 183: 
                        case 184: {
                            InvokeInstruction inv = (InvokeInstruction)instr;
                            int cpIndex = this.presetConstants != null && this.presetConstants == inv.getLazyConstantPool() ? ((InvokeInstruction.Lazy)inv).getCPIndex() : this.allocateConstantPoolMethod(inv.getClassType(), inv.getMethodName(), inv.getMethodSignature());
                            this.writeShort(curOffset, cpIndex);
                            curOffset += 2;
                            break;
                        }
                        case 186: {
                            InvokeDynamicInstruction inv = (InvokeDynamicInstruction)instr;
                            int cpIndex = this.presetConstants != null && this.presetConstants == inv.getLazyConstantPool() ? ((InvokeDynamicInstruction.Lazy)inv).getCPIndex() : this.allocateConstantPoolInvokeDynamic(inv.getBootstrap(), inv.getMethodName(), inv.getMethodSignature());
                            this.writeShort(curOffset, cpIndex);
                            this.code[curOffset + 2] = 0;
                            this.code[curOffset + 3] = 0;
                            curOffset += 4;
                            break;
                        }
                        case 185: {
                            InvokeInstruction inv = (InvokeInstruction)instr;
                            String sig = inv.getMethodSignature();
                            int cpIndex = this.presetConstants != null && this.presetConstants == inv.getLazyConstantPool() ? ((InvokeInstruction.Lazy)inv).getCPIndex() : this.allocateConstantPoolInterfaceMethod(inv.getClassType(), inv.getMethodName(), sig);
                            this.writeShort(curOffset, cpIndex);
                            this.code[curOffset + 2] = (byte)(Util.getParamsWordSize(sig) + 1);
                            this.code[curOffset + 3] = 0;
                            curOffset += 4;
                            break;
                        }
                        case 187: {
                            this.writeShort(curOffset, this.allocateConstantPoolClassType(((NewInstruction)instr).getType()));
                            curOffset += 2;
                            break;
                        }
                        case 188: {
                            this.code[curOffset] = indexedTypes_T[Util.getTypeIndex(((NewInstruction)instr).getType().substring(1))];
                            ++curOffset;
                            break;
                        }
                        case 189: {
                            this.writeShort(curOffset, this.allocateConstantPoolClassType(((NewInstruction)instr).getType().substring(1)));
                            curOffset += 2;
                            break;
                        }
                        case 197: {
                            NewInstruction n = (NewInstruction)instr;
                            this.writeShort(curOffset, this.allocateConstantPoolClassType(n.getType()));
                            this.code[curOffset + 2] = (byte)n.getArrayBoundsCount();
                            curOffset += 3;
                            break;
                        }
                        case 192: {
                            this.writeShort(curOffset, this.allocateConstantPoolClassType(((CheckCastInstruction)instr).getTypes()[0]));
                            curOffset += 2;
                            break;
                        }
                        case 193: {
                            this.writeShort(curOffset, this.allocateConstantPoolClassType(((InstanceofInstruction)instr).getType()));
                            curOffset += 2;
                            break;
                        }
                    }
                    break block97;
                }
                stackLenRef[0] = stackLen;
                curOffsetRef[0] = curOffset;
                instrRef[0] = i;
                instr.visit(noOpcodeHandler);
                curOffset = curOffsetRef[0];
                i = instrRef[0];
            }
            boolean haveStack = true;
            while (startI <= i) {
                instr = (Instruction)this.instructions[startI];
                if (instr.isFallThrough() && haveStack) {
                    if (stackLen < instr.getPoppedCount()) {
                        throw new IllegalArgumentException("Stack underflow in intermediate code, at offset " + startI);
                    }
                    if (instr instanceof DupInstruction) {
                        DupInstruction d = (DupInstruction)instr;
                        int size = d.getSize();
                        int delta = d.getDelta();
                        System.arraycopy(stackWords, stackLen - size - delta, stackWords, stackLen - delta, delta + size);
                        System.arraycopy(stackWords, stackLen, stackWords, stackLen - size - delta, size);
                        stackLen += size;
                    } else if (instr instanceof SwapInstruction) {
                        byte b = stackWords[stackLen - 1];
                        stackWords[stackLen - 1] = stackWords[stackLen - 2];
                        stackWords[stackLen - 2] = b;
                    } else {
                        stackLen -= instr.getPoppedCount();
                        byte w = instr.getPushedWordSize();
                        if (w > 0) {
                            stackWords[stackLen] = w;
                            ++stackLen;
                        }
                    }
                } else if (startI + 1 < endInstruction) {
                    byte[] s = this.stackWords[startI + 1];
                    if (s == null) {
                        haveStack = false;
                    } else {
                        stackLen = s.length;
                        System.arraycopy(s, 0, stackWords, 0, stackLen);
                    }
                }
                ++startI;
            }
            if (curOffset > this.code.length - 8) {
                return false;
            }
            if (haveStack) continue;
            while (i + 1 < endInstruction) {
                byte[] s = this.stackWords[i + 1];
                if (s != null) {
                    stackLen = s.length;
                    System.arraycopy(s, 0, stackWords, 0, stackLen);
                    continue block41;
                }
                ++i;
            }
        }
        if (!Compiler.applyPatches(patches)) {
            if (farBranches) {
                throw new Error("Failed to apply patches even with farBranches on");
            }
            return this.outputInstructions(startInstruction, endInstruction, startOffset, true, initialStack);
        }
        byte[] newCode = new byte[curOffset];
        System.arraycopy(this.code, 0, newCode, 0, curOffset);
        Compiler.releaseCodeBuf(this.code);
        this.code = newCode;
        return true;
    }

    private int[] buildRawHandlers(int start, int end) {
        int[] handlerCounts = new int[end - start];
        int maxCount = 0;
        for (int i = start; i < end; ++i) {
            int len;
            handlerCounts[i - start] = len = this.handlers[i].length;
            if (len <= maxCount) continue;
            maxCount = len;
        }
        if (maxCount == 0) {
            return noRawHandlers;
        }
        ArrayList<int[]> rawHandlerList = new ArrayList<int[]>();
        for (int i = maxCount; i > 0; --i) {
            for (int j = start; j < end; ++j) {
                if (handlerCounts[j - start] != i) continue;
                int first = j;
                ExceptionHandler h = this.handlers[j][this.handlers[j].length - i];
                do {
                    int n = j - start;
                    handlerCounts[n] = handlerCounts[n] - 1;
                } while (++j < end && handlerCounts[j - start] == i && this.handlers[j][this.handlers[j].length - i].equals(h));
                if (h.handler >= start && h.handler < end) {
                    rawHandlerList.add(new int[]{this.instructionsToOffsets[first], j < end ? this.instructionsToOffsets[j] : this.code.length, this.instructionsToOffsets[h.handler], h.catchClass == null ? 0 : this.allocateConstantPoolClassType(h.catchClass)});
                }
                --j;
            }
        }
        int[] rawHandlers = new int[4 * rawHandlerList.size()];
        int count = 0;
        for (int[] element : rawHandlerList) {
            System.arraycopy(element, 0, rawHandlers, count, 4);
            count += 4;
        }
        return rawHandlers;
    }

    private int[] buildBytecodeMap(int start, int end) {
        int[] r = new int[this.code.length];
        Arrays.fill(r, -1);
        for (int i = start; i < end; ++i) {
            int off = this.instructionsToOffsets[i];
            if (off < 0) continue;
            r[off] = this.instructionsToBytecodes[i];
        }
        return r;
    }

    private void addBackEdge(int from, int to) {
        int[] oldEdges = this.backEdges[from];
        if (oldEdges == null) {
            this.backEdges[from] = new int[]{to};
        } else if (oldEdges[oldEdges.length - 1] < 0) {
            int left = 1;
            int right = oldEdges.length - 1;
            while (true) {
                if (right - left < 2) {
                    if (oldEdges[left] < 0) break;
                    if (oldEdges[right] >= 0) {
                        throw new Error("Failed binary search");
                    }
                    left = right;
                    break;
                }
                int mid = (left + right) / 2;
                if (oldEdges[mid] < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            oldEdges[left] = to;
        } else {
            int[] newEdges = Arrays.copyOf(oldEdges, oldEdges.length * 2);
            newEdges[oldEdges.length] = to;
            for (int i = oldEdges.length + 1; i < newEdges.length; ++i) {
                newEdges[i] = -1;
            }
            this.backEdges[from] = newEdges;
        }
    }

    private void addLiveVar(int instruction, int index) {
        IInstruction instr;
        while (!(this.liveLocals[instruction].get(index) || (instr = this.instructions[instruction]) instanceof StoreInstruction && ((StoreInstruction)instr).getVarIndex() == index)) {
            this.liveLocals[instruction].set(index);
            int[] back = this.backEdges[instruction];
            if (back != null) {
                for (int element : back) {
                    this.addLiveVar(element, index);
                }
            }
            if (instruction <= 0 || !this.instructions[instruction - 1].isFallThrough()) break;
            --instruction;
        }
    }

    private void makeLiveLocals() {
        IInstruction instr;
        int i;
        this.liveLocals = new BitSet[this.instructions.length];
        this.backEdges = new int[this.instructions.length][];
        for (i = 0; i < this.instructions.length; ++i) {
            ExceptionHandler[] hs;
            int[] targets;
            instr = this.instructions[i];
            for (int target : targets = instr.getBranchTargets()) {
                this.addBackEdge(target, i);
            }
            for (ExceptionHandler element : hs = this.handlers[i]) {
                this.addBackEdge(element.handler, i);
            }
            this.liveLocals[i] = new BitSet();
        }
        for (i = 0; i < this.backEdges.length; ++i) {
            int[] back = this.backEdges[i];
            if (back == null || back[back.length - 1] >= 0) continue;
            int j = back.length;
            while (back[j - 1] < 0) {
                --j;
            }
            int[] newBack = new int[j];
            System.arraycopy(back, 0, newBack, 0, newBack.length);
            this.backEdges[i] = newBack;
        }
        for (i = 0; i < this.instructions.length; ++i) {
            instr = this.instructions[i];
            if (!(instr instanceof LoadInstruction)) continue;
            this.addLiveVar(i, ((LoadInstruction)instr).getVarIndex());
        }
    }

    private String getAndCheckLocalType(int i, int l) {
        String[] lts = this.localTypes[i];
        String t = "L?;";
        if (l < lts.length) {
            t = lts[l];
        }
        if (t.equals("L;") || t.equals("L?;")) {
            throw new IllegalArgumentException("Cannot split oversized method because local " + l + " is undefined at " + i);
        }
        return t;
    }

    private void allocateLocals(int count) {
        if (this.maxLocals < this.allocatedLocals + count * 2) {
            this.maxLocals = this.allocatedLocals + count * 2;
        }
    }

    private HelperPatch makeHelperPatch(int start, int len, int retVar, int unreadStack, int untouchedStack) {
        int i;
        String retType = retVar >= 0 ? this.getAndCheckLocalType(start + len, retVar) : "V";
        ArrayList<Instruction> callWrapper = new ArrayList<Instruction>();
        int curStackLen = this.stackTypes[start].length;
        StringBuilder sigBuf = new StringBuilder();
        sigBuf.append('(');
        this.allocateLocals(curStackLen - unreadStack);
        for (int i2 = curStackLen - 1; i2 >= unreadStack; --i2) {
            if (i2 < untouchedStack) {
                callWrapper.add(DupInstruction.make(0));
            }
            callWrapper.add(StoreInstruction.make(this.stackTypes[start][i2], this.allocatedLocals + 2 * (i2 - unreadStack)));
        }
        BitSet liveVars = this.liveLocals[start];
        for (i = 0; i < liveVars.length(); ++i) {
            if (liveVars.get(i)) {
                String t = this.getAndCheckLocalType(start, i);
                sigBuf.append(t);
                callWrapper.add(LoadInstruction.make(t, i));
                if (Util.getWordSize(t) <= 1) continue;
                ++i;
                continue;
            }
            sigBuf.append('I');
            callWrapper.add(ConstantInstruction.make(0));
        }
        for (i = unreadStack; i < curStackLen; ++i) {
            callWrapper.add(LoadInstruction.make(this.stackTypes[start][i], this.allocatedLocals + 2 * (i - unreadStack)));
            sigBuf.append(this.stackTypes[start][i]);
            if (Util.getWordSize(this.stackTypes[start][i]) != 2) continue;
            sigBuf.append('I');
            callWrapper.add(ConstantInstruction.make(0));
        }
        sigBuf.append(')');
        sigBuf.append(retType);
        String sig = sigBuf.toString();
        String name = this.createHelperMethod(true, sig);
        callWrapper.add(InvokeInstruction.make(sig, this.classType, name, IInvokeInstruction.Dispatch.STATIC));
        int savedMaxStack = this.maxStack;
        this.maxStack += curStackLen - unreadStack;
        int prefixLength = 4 * (curStackLen - unreadStack);
        byte[] initialStack = new byte[curStackLen - unreadStack];
        for (int i3 = 0; i3 < initialStack.length; ++i3) {
            initialStack[i3] = Util.getWordSize(this.stackTypes[start][unreadStack + i3]);
        }
        if (!this.outputInstructions(start, start + len, prefixLength, false, initialStack)) {
            throw new Error("Helper function is overlarge");
        }
        byte[] newCode = new byte[this.code.length + (retVar >= 0 ? 5 : 1)];
        for (int i4 = 0; i4 < curStackLen - unreadStack; ++i4) {
            int local = this.allocatedLocals + i4 * 2;
            newCode[i4 * 4] = -60;
            newCode[i4 * 4 + 1] = (byte)LoadInstruction.make(this.stackTypes[start][i4 + unreadStack], 500).getOpcode();
            newCode[i4 * 4 + 2] = (byte)(local >> 8);
            newCode[i4 * 4 + 3] = (byte)local;
        }
        System.arraycopy(this.code, prefixLength, newCode, prefixLength, this.code.length - prefixLength);
        int suffixOffset = this.code.length;
        if (retVar >= 0) {
            newCode[suffixOffset] = -60;
            newCode[suffixOffset + 1] = (byte)LoadInstruction.make(retType, 500).getOpcode();
            newCode[suffixOffset + 2] = (byte)(retVar >> 8);
            newCode[suffixOffset + 3] = (byte)retVar;
            newCode[suffixOffset + 4] = (byte)ReturnInstruction.make(retType).getOpcode();
            callWrapper.add(StoreInstruction.make(retType, retVar));
        } else {
            newCode[suffixOffset] = (byte)ReturnInstruction.make("V").getOpcode();
        }
        if (callWrapper.size() > len) {
            return null;
        }
        int[] rawHandlers = this.buildRawHandlers(start, start + len);
        int[] bytecodeMap = this.buildBytecodeMap(start, start + len);
        this.auxMethods.add(new Output(name, sig, newCode, rawHandlers, bytecodeMap, this.maxLocals, this.maxStack, true, null));
        this.maxStack = savedMaxStack;
        Instruction[] patch = new Instruction[callWrapper.size()];
        callWrapper.toArray(patch);
        ExceptionHandler[] startHS = this.handlers[start];
        ArrayList<ExceptionHandler> newHS = new ArrayList<ExceptionHandler>();
        for (ExceptionHandler element : startHS) {
            int t = element.handler;
            if (t >= start && t < start + len) continue;
            newHS.add(element);
        }
        ExceptionHandler[] patchHS = new ExceptionHandler[newHS.size()];
        newHS.toArray(patchHS);
        return new HelperPatch(start, len, patch, patchHS);
    }

    private HelperPatch findBlock(int start, int len) {
        while (len > 100) {
            int n;
            boolean outsideBranch;
            int i;
            int lastInvalid = start - 1;
            for (i = start + 1; i < start + len; ++i) {
                int[] back = this.backEdges[i];
                outsideBranch = false;
                for (int j = 0; back != null && j < back.length; ++j) {
                    if (back[j] >= start && back[j] < start + len) continue;
                    outsideBranch = true;
                    break;
                }
                if (!outsideBranch) continue;
                HelperPatch p = this.findBlock(lastInvalid + 1, i - lastInvalid - 1);
                if (p != null) {
                    return p;
                }
                lastInvalid = i;
            }
            if (lastInvalid >= start) {
                return null;
            }
            if (!this.instructions[start + len - 1].isFallThrough()) {
                --len;
                continue;
            }
            lastInvalid = start - 1;
            for (i = start; i < start + len; ++i) {
                int[] targets = this.instructions[i].getBranchTargets();
                outsideBranch = false;
                if (this.instructions[i] instanceof ReturnInstruction) {
                    outsideBranch = true;
                }
                Object p = targets;
                int n2 = ((int[])p).length;
                for (n = 0; n < n2; ++n) {
                    int target = p[n];
                    if (target >= start && target < start + len) continue;
                    outsideBranch = true;
                    break;
                }
                if (!outsideBranch) continue;
                p = this.findBlock(lastInvalid + 1, i - lastInvalid - 1);
                if (p != null) {
                    return p;
                }
                lastInvalid = i;
            }
            if (lastInvalid >= start) {
                return null;
            }
            lastInvalid = start - 1;
            for (i = start; i < start + len; ++i) {
                int[] targets;
                ExceptionHandler[] hs;
                boolean out = false;
                for (ExceptionHandler element : hs = this.handlers[i]) {
                    int h = element.handler;
                    if (h >= start && h < start + len) continue;
                    out = true;
                    break;
                }
                int[] nArray = targets = this.instructions[i].getBranchTargets();
                n = nArray.length;
                for (int element = 0; element < n; ++element) {
                    int t = nArray[element];
                    if (t >= start && t < start + len) continue;
                    out = true;
                    break;
                }
                if (!out) continue;
                HelperPatch p = this.findBlock(lastInvalid + 1, i - lastInvalid - 1);
                if (p != null) {
                    return p;
                }
                lastInvalid = i;
            }
            if (lastInvalid >= start) {
                return null;
            }
            if (this.stackTypes[start] == null) {
                while (this.stackTypes[start] == null && len > 0) {
                    ++start;
                    --len;
                }
                continue;
            }
            int untouchedStack = Integer.MAX_VALUE;
            int unreadStack = Integer.MAX_VALUE;
            for (int i2 = start; i2 < start + len; ++i2) {
                if (this.stackTypes[i2] == null) {
                    untouchedStack = 0;
                    unreadStack = 0;
                    break;
                }
                int lowWaterMark = this.stackTypes[i2].length - this.instructions[i2].getPoppedCount();
                unreadStack = Math.min(unreadStack, lowWaterMark);
                if (this.instructions[i2] instanceof DupInstruction) {
                    lowWaterMark += this.instructions[i2].getPoppedCount();
                }
                untouchedStack = Math.min(untouchedStack, lowWaterMark);
            }
            if (untouchedStack > unreadStack + 1 || untouchedStack == unreadStack + 1 && untouchedStack < this.stackTypes[start].length) {
                ++start;
                --len;
                continue;
            }
            boolean unknownType = false;
            for (int i3 = unreadStack; i3 < untouchedStack; ++i3) {
                String t = this.stackTypes[start][i3];
                if (t != null && !t.equals("L?;") && !t.equals("L;")) continue;
                unknownType = true;
                break;
            }
            if (unknownType) {
                ++start;
                --len;
                continue;
            }
            if (this.stackTypes[start + len] == null || this.stackTypes[start + len].length > untouchedStack) {
                while (len > 0 && (this.stackTypes[start + len] == null || this.stackTypes[start + len].length > untouchedStack)) {
                    --len;
                }
                continue;
            }
            BitSet liveAtEnd = this.liveLocals[start + len];
            boolean multipleDefs = false;
            int localDefed = -1;
            int firstDef = -1;
            int secondDef = -1;
            for (int i4 = start; i4 < start + len; ++i4) {
                int l;
                IInstruction instr = this.instructions[i4];
                if (!(instr instanceof StoreInstruction) || !liveAtEnd.get(l = ((StoreInstruction)instr).getVarIndex()) || l == localDefed) continue;
                if (localDefed < 0) {
                    localDefed = l;
                    firstDef = i4;
                    continue;
                }
                multipleDefs = true;
                secondDef = i4;
                break;
            }
            if (multipleDefs) {
                HelperPatch p = this.findBlock(start, secondDef - start);
                if (p != null) {
                    return p;
                }
                len = start + len - (firstDef + 1);
                start = firstDef + 1;
                continue;
            }
            ExceptionHandler[] startHS = this.handlers[start];
            int numOuts = 0;
            for (ExceptionHandler element : startHS) {
                int t = element.handler;
                if (t >= start && t < start + len) continue;
                ++numOuts;
            }
            boolean mismatchedHandlers = false;
            int firstMismatch = -1;
            for (int i5 = start + 1; i5 < start + len; ++i5) {
                ExceptionHandler[] hs = this.handlers[i5];
                int matchingOuts = 0;
                for (ExceptionHandler element : hs) {
                    int t = element.handler;
                    if (t >= start && t < start + len) continue;
                    boolean match = false;
                    for (ExceptionHandler element2 : startHS) {
                        if (!element2.equals(element)) continue;
                        match = true;
                        break;
                    }
                    if (!match) continue;
                    ++matchingOuts;
                }
                if (matchingOuts == numOuts) continue;
                firstMismatch = i5;
                mismatchedHandlers = true;
                break;
            }
            if (mismatchedHandlers) {
                HelperPatch p = this.findBlock(start, firstMismatch - start);
                if (p != null) {
                    return p;
                }
                start = firstMismatch;
                continue;
            }
            try {
                HelperPatch p = this.makeHelperPatch(start, len, localDefed, unreadStack, untouchedStack);
                if (p == null) {
                    return null;
                }
                return p;
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        return null;
    }

    private void makeHelpers() {
        int offset = 0;
        ArrayList<HelperPatch> patches = new ArrayList<HelperPatch>();
        while (offset + 5000 < this.instructions.length) {
            HelperPatch p = this.findBlock(offset, 5000);
            if (p != null) {
                patches.add(p);
                offset = p.start + p.length;
                continue;
            }
            offset += 500;
        }
        for (HelperPatch p : patches) {
            System.arraycopy(p.code, 0, this.instructions, p.start, p.code.length);
            for (int j = 0; j < p.length; ++j) {
                int index = j + p.start;
                this.instructions[index] = j < p.code.length ? p.code[j] : PopInstruction.make(0);
                this.handlers[index] = p.handlers;
                this.instructionsToBytecodes[index] = -1;
            }
        }
    }

    private void makeTypes() {
        Verifier v = new Verifier(this.isConstructor, this.isStatic, this.classType, this.signature, this.instructions, this.handlers, this.instructionsToBytecodes, null);
        if (this.hierarchy != null) {
            v.setClassHierarchy(this.hierarchy);
        }
        try {
            v.computeTypes();
        }
        catch (Analyzer.FailureException ex) {
            throw new IllegalArgumentException("Cannot split oversized method because verification failed: " + ex.getMessage());
        }
        this.localTypes = v.getLocalTypes();
        this.stackTypes = v.getStackTypes();
    }

    public final void compile() {
        this.collectInstructionInfo();
        this.computeStackWords();
        if (!this.outputInstructions(0, this.instructions.length, 0, false, null)) {
            this.allocatedLocals = this.maxLocals;
            this.makeLiveLocals();
            this.makeTypes();
            this.auxMethods = new ArrayList();
            this.makeHelpers();
            this.computeStackWords();
            if (!this.outputInstructions(0, this.instructions.length, 0, false, null)) {
                throw new Error("Input code too large; consider breaking up your code");
            }
        }
        this.mainMethod = new Output(null, null, this.code, this.buildRawHandlers(0, this.instructions.length), this.buildBytecodeMap(0, this.instructions.length), this.maxLocals, this.maxStack, this.isStatic, this.instructionsToOffsets);
        this.instructionsToOffsets = null;
        this.branchTargets = null;
        this.stackWords = null;
        this.code = null;
    }

    public final Output getOutput() {
        return this.mainMethod;
    }

    public final Output[] getAuxiliaryMethods() {
        if (this.auxMethods == null) {
            return null;
        }
        Output[] r = new Output[this.auxMethods.size()];
        this.auxMethods.toArray(r);
        return r;
    }

    public static final class Output {
        private final byte[] code;
        private final int[] rawHandlers;
        private final int[] newBytecodesToOldBytecodes;
        private final String name;
        private final String signature;
        private final boolean isStatic;
        private final int maxLocals;
        private final int maxStack;
        private final int[] instructionsToOffsets;

        Output(String name, String signature, byte[] code, int[] rawHandlers, int[] newBytecodesToOldBytecodes, int maxLocals, int maxStack, boolean isStatic, int[] instructionsToOffsets) {
            this.code = code;
            this.name = name;
            this.signature = signature;
            this.rawHandlers = rawHandlers;
            this.newBytecodesToOldBytecodes = newBytecodesToOldBytecodes;
            this.isStatic = isStatic;
            this.maxLocals = maxLocals;
            this.maxStack = maxStack;
            this.instructionsToOffsets = instructionsToOffsets;
        }

        public byte[] getCode() {
            return this.code;
        }

        public int[] getInstructionOffsets() {
            return this.instructionsToOffsets;
        }

        public String getMethodName() {
            return this.name;
        }

        public String getMethodSignature() {
            return this.signature;
        }

        public int getAccessFlags() {
            return this.name != null ? 2 | (this.isStatic ? 8 : 0) : 0;
        }

        public int[] getRawHandlers() {
            return this.rawHandlers;
        }

        public boolean isStatic() {
            return this.isStatic;
        }

        public int[] getNewBytecodesToOldBytecodes() {
            return this.newBytecodesToOldBytecodes;
        }

        public int getMaxStack() {
            return this.maxStack;
        }

        public int getMaxLocals() {
            return this.maxLocals;
        }
    }

    static class HelperPatch {
        final int start;
        final int length;
        final Instruction[] code;
        final ExceptionHandler[] handlers;

        HelperPatch(int start, int length, Instruction[] code, ExceptionHandler[] handlers) {
            this.start = start;
            this.length = length;
            this.code = code;
            this.handlers = handlers;
        }
    }

    class IntPatch
    extends Patch {
        IntPatch(int instrStart, int instrOffset, int targetLabel) {
            super(instrStart, instrOffset, targetLabel);
        }

        @Override
        boolean apply() {
            Compiler.this.writeInt(this.instrOffset, Compiler.this.instructionsToOffsets[this.targetLabel] - this.instrStart);
            return true;
        }
    }

    class ShortPatch
    extends Patch {
        ShortPatch(int instrStart, int instrOffset, int targetLabel) {
            super(instrStart, instrOffset, targetLabel);
        }

        @Override
        boolean apply() {
            int delta = Compiler.this.instructionsToOffsets[this.targetLabel] - this.instrStart;
            if ((short)delta == delta) {
                Compiler.this.writeShort(this.instrOffset, delta);
                return true;
            }
            return false;
        }
    }

    static abstract class Patch {
        final int instrStart;
        final int instrOffset;
        final int targetLabel;

        Patch(int instrStart, int instrOffset, int targetLabel) {
            this.instrStart = instrStart;
            this.instrOffset = instrOffset;
            this.targetLabel = targetLabel;
        }

        abstract boolean apply();
    }
}

