/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT;

import com.ibm.wala.shrikeBT.Compiler;
import com.ibm.wala.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrikeBT.Decoder;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.shrikeBT.Instruction;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeBT.analysis.Analyzer;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyProvider;
import com.ibm.wala.shrikeBT.shrikeCT.CTCompiler;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.CodeReader;
import com.ibm.wala.shrikeCT.CodeWriter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.LineNumberTableReader;
import com.ibm.wala.shrikeCT.LineNumberTableWriter;
import com.ibm.wala.shrikeCT.LocalVariableTableReader;
import com.ibm.wala.shrikeCT.LocalVariableTableWriter;
import com.ibm.wala.shrikeCT.StackMapConstants;
import com.ibm.wala.shrikeCT.StackMapTableReader;
import com.ibm.wala.shrikeCT.StackMapTableWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class ClassInstrumenter {
    private final boolean[] deletedMethods;
    private final MethodData[] methods;
    private final CodeReader[] oldCode;
    private final ClassReader cr;
    private final ConstantPoolReader cpr;
    private boolean createFakeLineNumbers = false;
    private int fakeLineOffset;
    private final String inputName;
    private final ClassHierarchyProvider cha;
    private static final ExceptionHandler[] noHandlers = new ExceptionHandler[0];

    public ClassInstrumenter(String inputName, byte[] bytes, ClassHierarchyProvider cha) throws InvalidClassFileException {
        this(inputName, new ClassReader(bytes), cha);
    }

    public String getInputName() {
        return this.inputName;
    }

    public void enableFakeLineNumbers(int offset) {
        this.createFakeLineNumbers = true;
        this.fakeLineOffset = offset;
    }

    public ClassInstrumenter(String inputName, ClassReader cr, ClassHierarchyProvider cha) {
        if (cr == null) {
            throw new IllegalArgumentException("cr is null");
        }
        this.cr = cr;
        this.cha = cha;
        this.methods = new MethodData[cr.getMethodCount()];
        this.oldCode = new CodeReader[this.methods.length];
        this.cpr = CTDecoder.makeConstantPoolReader(cr);
        this.deletedMethods = new boolean[this.methods.length];
        this.inputName = inputName;
    }

    public ClassReader getReader() {
        return this.cr;
    }

    private void prepareMethod(int i) throws InvalidClassFileException {
        if (this.deletedMethods[i]) {
            this.methods[i] = null;
        } else if (this.methods[i] == null) {
            ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
            this.cr.initMethodAttributeIterator(i, iter);
            while (iter.isValid()) {
                if (iter.getName().equals("Code")) {
                    MethodData md;
                    CodeReader code = new CodeReader(iter);
                    CTDecoder d = new CTDecoder(code, this.cpr);
                    try {
                        d.decode();
                    }
                    catch (Decoder.InvalidBytecodeException e) {
                        throw new InvalidClassFileException(code.getRawOffset(), e.getMessage());
                    }
                    this.methods[i] = md = new MethodData(d, this.cr.getMethodAccessFlags(i), CTDecoder.convertClassToType(this.cr.getName()), this.cr.getMethodName(i), this.cr.getMethodType(i));
                    this.oldCode[i] = code;
                    return;
                }
                iter.advance();
            }
        }
    }

    public void deleteMethod(int i) {
        this.deletedMethods[i] = true;
    }

    public MethodData createEmptyMethodData(String name, String sig, int access) {
        IInstruction[] instructions = new Instruction[1];
        String type = Util.getReturnType(sig);
        if ("C".equals(type) || "B".equals(type) || "Z".equals(type) || "S".equals(type)) {
            type = "I";
        }
        instructions[0] = ReturnInstruction.make(type);
        ExceptionHandler[][] handlers = new ExceptionHandler[instructions.length][];
        Arrays.fill((Object[])handlers, noHandlers);
        int[] i2b = new int[instructions.length];
        Arrays.setAll(i2b, i -> i);
        MethodData md = null;
        try {
            md = new MethodData(access, Util.makeType(this.cr.getName()), name, sig, instructions, handlers, i2b);
        }
        catch (InvalidClassFileException ex) {
            ex.printStackTrace();
        }
        return md;
    }

    public void visitMethods(MethodExaminer me) throws InvalidClassFileException {
        for (int i = 0; i < this.methods.length; ++i) {
            this.prepareMethod(i);
            if (this.methods[i] == null) continue;
            me.examineCode(this.methods[i]);
        }
    }

    public MethodData visitMethod(int i) throws InvalidClassFileException {
        this.prepareMethod(i);
        return this.methods[i];
    }

    public CodeReader getMethodCode(int i) throws InvalidClassFileException {
        this.prepareMethod(i);
        return this.oldCode[i];
    }

    public void resetMethod(int i) {
        this.deletedMethods[i] = false;
        this.methods[i] = null;
    }

    public void replaceMethod(int i, MethodData md) {
        if (md == null) {
            throw new IllegalArgumentException("md is null");
        }
        this.deletedMethods[i] = false;
        this.methods[i] = md;
        this.oldCode[i] = null;
        md.setHasChanged();
    }

    public boolean isChanged() {
        for (int i = 0; i < this.methods.length; ++i) {
            if (!this.deletedMethods[i] && (this.methods[i] == null || !this.methods[i].getHasChanged())) continue;
            return true;
        }
        return false;
    }

    public ClassWriter emitClass() throws InvalidClassFileException {
        return this.emitClass(new ClassWriter());
    }

    public ClassWriter emitClass(ClassWriter w) throws InvalidClassFileException {
        this.emitClassInto(w);
        return w;
    }

    private void emitClassInto(ClassWriter w) throws InvalidClassFileException {
        int i;
        w.setMajorVersion(this.cr.getMajorVersion());
        w.setMinorVersion(this.cr.getMinorVersion());
        w.setRawCP(this.cr.getCP(), false);
        w.setAccessFlags(this.cr.getAccessFlags());
        w.setNameIndex(this.cr.getNameIndex());
        w.setSuperNameIndex(this.cr.getSuperNameIndex());
        w.setInterfaceNameIndices(this.cr.getInterfaceNameIndices());
        int fieldCount = this.cr.getFieldCount();
        for (i = 0; i < fieldCount; ++i) {
            w.addRawField(new ClassWriter.RawElement(this.cr.getBytes(), this.cr.getFieldRawOffset(i), this.cr.getFieldRawSize(i)));
        }
        for (i = 0; i < this.methods.length; ++i) {
            MethodData md = this.methods[i];
            if (this.deletedMethods[i]) continue;
            if (md == null || !md.getHasChanged()) {
                w.addRawMethod(new ClassWriter.RawElement(this.cr.getBytes(), this.cr.getMethodRawOffset(i), this.cr.getMethodRawSize(i)));
                continue;
            }
            CTCompiler comp = CTCompiler.make(w, md);
            comp.setPresetConstants(this.cpr);
            try {
                comp.compile();
            }
            catch (Error | Exception ex) {
                ex.printStackTrace();
                throw new Error("Error compiling method " + md + ": " + ex.getMessage());
            }
            CodeReader oc = this.oldCode[i];
            int flags = this.cr.getMethodAccessFlags(i);
            w.addMethod(flags &= 0xFFFFFEFF, this.cr.getMethodNameIndex(i), this.cr.getMethodTypeIndex(i), this.makeMethodAttributes(i, w, oc, comp.getOutput(), md));
            Compiler.Output[] aux = comp.getAuxiliaryMethods();
            if (aux == null) continue;
            for (Compiler.Output a : aux) {
                w.addMethod(a.getAccessFlags(), a.getMethodName(), a.getMethodSignature(), this.makeMethodAttributes(i, w, oc, a, md));
            }
        }
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.cr.initClassAttributeIterator(iter);
        while (iter.isValid()) {
            w.addClassAttribute(new ClassWriter.RawElement(this.cr.getBytes(), iter.getRawOffset(), iter.getRawSize()));
            iter.advance();
        }
    }

    private static CodeWriter makeNewCode(ClassWriter w, Compiler.Output output) {
        CodeWriter code = new CodeWriter(w);
        code.setMaxStack(output.getMaxStack());
        code.setMaxLocals(output.getMaxLocals());
        code.setCode(output.getCode());
        code.setRawHandlers(output.getRawHandlers());
        return code;
    }

    private LineNumberTableWriter makeNewLines(ClassWriter w, CodeReader oldCode, Compiler.Output output) throws InvalidClassFileException {
        int[] newLineMap = null;
        int[] oldLineMap = LineNumberTableReader.makeBytecodeToSourceMap(oldCode);
        if (oldLineMap != null) {
            int[] newToOldMap = output.getNewBytecodesToOldBytecodes();
            newLineMap = new int[newToOldMap.length];
            for (int i2 = 0; i2 < newToOldMap.length; ++i2) {
                int old = newToOldMap[i2];
                if (old < 0) continue;
                newLineMap[i2] = oldLineMap[old];
            }
        } else if (this.createFakeLineNumbers) {
            newLineMap = new int[output.getCode().length];
            Arrays.setAll(newLineMap, i -> i + this.fakeLineOffset);
        } else {
            return null;
        }
        int[] rawTable = LineNumberTableWriter.makeRawTable(newLineMap);
        if (rawTable == null || rawTable.length == 0) {
            return null;
        }
        LineNumberTableWriter lines = new LineNumberTableWriter(w);
        lines.setRawTable(rawTable);
        return lines;
    }

    private static LocalVariableTableWriter makeNewLocals(ClassWriter w, CodeReader oldCode, Compiler.Output output) throws InvalidClassFileException {
        int[][] oldMap = LocalVariableTableReader.makeVarMap(oldCode);
        if (oldMap != null) {
            int[] newToOldMap = output.getNewBytecodesToOldBytecodes();
            int[][] newMap = new int[newToOldMap.length][];
            int[] lastLocals = null;
            for (int i = 0; i < newToOldMap.length; ++i) {
                int old = newToOldMap[i];
                if (old >= 0) {
                    newMap[i] = oldMap[old];
                    lastLocals = newMap[i];
                    continue;
                }
                newMap[i] = lastLocals;
            }
            int[] rawTable = LocalVariableTableWriter.makeRawTable(newMap, output);
            if (rawTable == null || rawTable.length == 0) {
                return null;
            }
            LocalVariableTableWriter locals = new LocalVariableTableWriter(w);
            locals.setRawTable(rawTable);
            return locals;
        }
        return null;
    }

    private ClassWriter.Element[] makeMethodAttributes(int m, ClassWriter w, CodeReader oldCode, Compiler.Output output, MethodData md) throws InvalidClassFileException {
        CodeWriter code = ClassInstrumenter.makeNewCode(w, output);
        int codeAttrCount = 0;
        LineNumberTableWriter lines = null;
        LocalVariableTableWriter locals = null;
        StackMapTableWriter stacks = null;
        if (oldCode != null) {
            lines = this.makeNewLines(w, oldCode, output);
            if (lines != null) {
                ++codeAttrCount;
            }
            if ((locals = ClassInstrumenter.makeNewLocals(w, oldCode, output)) != null) {
                ++codeAttrCount;
            }
            if (oldCode.getClassReader().getMajorVersion() > 50) {
                try {
                    List<StackMapConstants.StackMapFrame> sm = StackMapTableReader.readStackMap(oldCode);
                    String[][] varTypes = null;
                    int[] newToOld = output.getNewBytecodesToOldBytecodes();
                    int[][] vars = LocalVariableTableReader.makeVarMap(oldCode);
                    if (vars != null) {
                        varTypes = new String[newToOld.length][];
                        for (int i = 0; i < newToOld.length; ++i) {
                            int idx = newToOld[i];
                            if (idx == -1 || vars[idx] == null) continue;
                            varTypes[i] = new String[vars[idx].length / 2];
                            for (int j = 1; j < vars[idx].length; j += 2) {
                                int type = vars[idx][j];
                                varTypes[i][j / 2] = type == 0 ? null : oldCode.getClassReader().getCP().getCPUtf8(type);
                            }
                        }
                    }
                    stacks = new StackMapTableWriter(w, md, output, this.cha, varTypes, sm);
                    ++codeAttrCount;
                }
                catch (Analyzer.FailureException | IOException e) {
                    e.printStackTrace();
                }
            }
        }
        ClassWriter.Element[] codeAttributes = new ClassWriter.Element[codeAttrCount];
        int codeAttrIndex = 0;
        if (lines != null) {
            codeAttributes[codeAttrIndex++] = lines;
        }
        if (locals != null) {
            codeAttributes[codeAttrIndex++] = locals;
        }
        if (stacks != null) {
            codeAttributes[codeAttrIndex++] = stacks;
        }
        code.setAttributes(codeAttributes);
        ClassReader.AttrIterator iter = new ClassReader.AttrIterator();
        this.cr.initMethodAttributeIterator(m, iter);
        int methodAttrCount = iter.getRemainingAttributesCount();
        if (oldCode == null) {
            ++methodAttrCount;
        }
        ClassWriter.Element[] methodAttributes = new ClassWriter.Element[methodAttrCount];
        int i = 0;
        while (iter.isValid()) {
            if (iter.getName().equals("Code")) {
                methodAttributes[i] = code;
                code = null;
                if (oldCode == null) {
                    throw new Error("No old code provided, but Code attribute found");
                }
            } else {
                methodAttributes[i] = new ClassWriter.RawElement(this.cr.getBytes(), iter.getRawOffset(), iter.getRawSize());
            }
            ++i;
            iter.advance();
        }
        if (oldCode == null) {
            if (code == null) {
                throw new Error("Old code not provided but existing code was found and replaced");
            }
            methodAttributes[methodAttrCount - 1] = code;
        }
        return methodAttributes;
    }

    public static interface MethodExaminer {
        public void examineCode(MethodData var1);
    }
}

