/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT.tools;

import com.ibm.wala.shrikeBT.Util;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.ConstantValueWriter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;

public class AddSerialVersion {
    private AddSerialVersion() {
    }

    public static void addSerialVersionUID(ClassReader r, ClassWriter w) throws InvalidClassFileException {
        if (r == null) {
            throw new IllegalArgumentException("r is null");
        }
        int numFields = r.getFieldCount();
        for (int i = 0; i < numFields; ++i) {
            if (!r.getFieldName(i).equals("serialVersionUID")) continue;
            return;
        }
        long UID = AddSerialVersion.computeSerialVersionUID(r);
        w.addField(25, "serialVersionUID", "J", new ClassWriter.Element[]{new ConstantValueWriter(w, UID)});
    }

    public static long computeSerialVersionUID(ClassReader r) throws InvalidClassFileException {
        MessageDigest digest;
        if (r == null) {
            throw new IllegalArgumentException("r is null");
        }
        try {
            digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error("SHA algorithm not supported: " + e.getMessage());
        }
        try (SinkOutputStream sink2 = new SinkOutputStream();
             DataOutputStream out = new DataOutputStream(new DigestOutputStream(sink2, digest));){
            try {
                out.writeUTF(r.getName());
                out.writeInt(r.getAccessFlags());
                Object[] interfaces = r.getInterfaceNames();
                Arrays.sort(interfaces);
                for (Object interface1 : interfaces) {
                    out.writeUTF((String)interface1);
                }
                Integer[] fields = new Integer[r.getFieldCount()];
                String[] fieldNames = new String[fields.length];
                int fieldCount = 0;
                for (int f = 0; f < fields.length; ++f) {
                    int flags = r.getFieldAccessFlags(f);
                    if ((flags & 2) != 0 && (flags & 0x88) != 0) continue;
                    fields[fieldCount] = f;
                    fieldNames[f] = r.getFieldName(f);
                    ++fieldCount;
                }
                Arrays.sort(fields, 0, fieldCount, (o1, o2) -> {
                    String name1 = fieldNames[o1];
                    String name2 = fieldNames[o2];
                    return name1.compareTo(name2);
                });
                for (int i = 0; i < fieldCount; ++i) {
                    int f = fields[i];
                    out.writeUTF(fieldNames[f]);
                    out.writeInt(r.getFieldAccessFlags(f));
                    out.writeUTF(r.getFieldType(f));
                }
                Integer[] methods = new Integer[r.getMethodCount()];
                int[] methodKinds = new int[methods.length];
                String[] methodSigs = new String[methods.length];
                int methodCount = 0;
                for (int m = 0; m < methodSigs.length; ++m) {
                    String name = r.getMethodName(m);
                    int flags = r.getMethodAccessFlags(m);
                    if (!name.equals("<clinit>") && (flags & 2) != 0) continue;
                    methods[methodCount] = m;
                    methodSigs[m] = name + r.getMethodType(m);
                    switch (name) {
                        case "<clinit>": {
                            methodKinds[m] = 0;
                            break;
                        }
                        case "<init>": {
                            methodKinds[m] = 1;
                            break;
                        }
                        default: {
                            methodKinds[m] = 2;
                        }
                    }
                    ++methodCount;
                }
                Arrays.sort(methods, 0, methodCount, (o1, o2) -> {
                    int m2;
                    int m1 = o1;
                    if (methodKinds[m1] != methodKinds[m2 = o2.intValue()]) {
                        return methodKinds[m1] - methodKinds[m2];
                    }
                    String name1 = methodSigs[m1];
                    String name2 = methodSigs[m2];
                    return name1.compareTo(name2);
                });
                for (int i = 0; i < methodCount; ++i) {
                    int m = methods[i];
                    out.writeUTF(r.getMethodName(m));
                    out.writeInt(r.getMethodAccessFlags(m));
                    out.writeUTF(r.getMethodType(m));
                }
            }
            catch (IOException e1) {
                throw new Error("Unexpected IOException: " + e1.getMessage());
            }
        }
        catch (IOException sink2) {
            // empty catch block
        }
        byte[] hash = digest.digest();
        return hash[0] & 0xFF | (hash[1] & 0xFF) << 8 | (hash[2] & 0xFF) << 16 | hash[3] << 24 | (hash[4] & 0xFF) << 32 | (hash[5] & 0xFF) << 40 | (hash[6] & 0xFF) << 48 | (hash[7] & 0xFF) << 56;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) {
                throw new IllegalArgumentException("args[" + i + "] is null");
            }
            try (FileInputStream in = new FileInputStream(args[i]);){
                byte[] data = Util.readFully(in);
                ClassReader r = new ClassReader(data);
                System.out.println(Util.makeClass(r.getName()) + ": serialVersionUID = " + AddSerialVersion.computeSerialVersionUID(r));
                continue;
            }
            catch (FileNotFoundException e) {
                System.err.println("File not found: " + args[i]);
                continue;
            }
            catch (IOException e) {
                System.err.println("Error reading file: " + args[i]);
                continue;
            }
            catch (InvalidClassFileException e) {
                System.err.println("Invalid class file: " + args[i]);
            }
        }
    }

    public static final class SinkOutputStream
    extends OutputStream {
        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }
    }
}

