/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeCT;

import com.ibm.wala.shrikeBT.Compiler;
import com.ibm.wala.shrikeCT.ClassWriter;
import java.util.Arrays;

public final class LocalVariableTableWriter
extends ClassWriter.Element {
    private final int attrID;
    private int[] rawTable = emptyTable;
    private static final int[] emptyTable = new int[0];

    public LocalVariableTableWriter(ClassWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("w is null");
        }
        this.attrID = w.addCPUtf8("LocalVariableTable");
    }

    public void setRawTable(int[] table) {
        if (table == null) {
            table = emptyTable;
        }
        if (table.length % 5 != 0) {
            throw new IllegalArgumentException("Local variable table has bad length: " + table.length);
        }
        if (table.length / 5 > 65535) {
            throw new IllegalArgumentException("Too many local variable table entries: " + table.length / 5);
        }
        for (int i = 0; i < table.length; ++i) {
            int v = table[i];
            if (v >= 0 && v <= 65535) continue;
            throw new IllegalArgumentException("Bad local variable table entry at " + i + ": " + v);
        }
        this.rawTable = table;
    }

    @Override
    public int getSize() {
        return 8 + this.rawTable.length * 2;
    }

    @Override
    public int copyInto(byte[] buf, int offset) throws IllegalArgumentException {
        ClassWriter.setUShort(buf, offset, this.attrID);
        ClassWriter.setInt(buf, offset + 2, 2 + this.rawTable.length * 2);
        ClassWriter.setUShort(buf, offset + 6, this.rawTable.length / 5);
        offset += 8;
        for (int element : this.rawTable) {
            ClassWriter.setUShort(buf, offset, element);
            offset += 2;
        }
        return offset;
    }

    public static int[] makeRawTable(int[][] varMap, Compiler.Output output) throws IllegalArgumentException {
        if (varMap == null) {
            throw new IllegalArgumentException("varMap == null");
        }
        try {
            int varCount = 0;
            for (int[] element : varMap) {
                if (element == null) continue;
                varCount = Math.max(varCount, element.length);
            }
            int[] entries = new int[20];
            int[] varEnd = new int[varCount /= 2];
            Arrays.fill(varEnd, -1);
            int[] lastVector = null;
            int entryCount = 0;
            for (int i = 0; i < varMap.length; ++i) {
                if (varMap[i] == lastVector || (lastVector = varMap[i]) == null) continue;
                for (int k = 0; k < lastVector.length / 2 && k < output.getMaxLocals(); ++k) {
                    int end;
                    if (lastVector[k * 2] <= 0 || i < varEnd[k]) continue;
                    int entryOffset = entryCount * 5;
                    if (++entryCount * 5 > entries.length) {
                        entries = Arrays.copyOf(entries, entries.length * 2);
                    }
                    int nameIndex = lastVector[k * 2];
                    int typeIndex = lastVector[k * 2 + 1];
                    for (end = i + 1; end < varMap.length && varMap[end] != null && k * 2 < varMap[end].length && varMap[end][k * 2] == nameIndex && varMap[end][k * 2 + 1] == typeIndex; ++end) {
                    }
                    varEnd[k] = end;
                    entries[entryOffset] = i;
                    entries[entryOffset + 1] = end - i;
                    entries[entryOffset + 2] = nameIndex;
                    entries[entryOffset + 3] = typeIndex;
                    entries[entryOffset + 4] = k;
                }
            }
            if (entryCount == 0) {
                return null;
            }
            int[] r = new int[entryCount * 5];
            System.arraycopy(entries, 0, r, 0, r.length);
            return r;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("malformed varMap", e);
        }
    }
}

