/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrikeBT.shrikeCT;

import com.ibm.wala.shrikeBT.Compiler;
import com.ibm.wala.shrikeBT.MethodData;
import com.ibm.wala.shrikeBT.analysis.ClassHierarchyStore;
import com.ibm.wala.shrikeBT.shrikeCT.CTCompiler;
import com.ibm.wala.shrikeBT.shrikeCT.CTDecoder;
import com.ibm.wala.shrikeCT.ClassReader;
import com.ibm.wala.shrikeCT.ClassWriter;
import com.ibm.wala.shrikeCT.CodeWriter;
import com.ibm.wala.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrikeCT.LineNumberTableWriter;
import java.util.Arrays;

public class CTUtils {
    public static void addClassToHierarchy(ClassHierarchyStore store, ClassReader cr) throws InvalidClassFileException, IllegalArgumentException {
        if (store == null) {
            throw new IllegalArgumentException("store is null");
        }
        if (cr == null) {
            throw new IllegalArgumentException();
        }
        String[] superInterfaces = new String[cr.getInterfaceCount()];
        for (int i = 0; i < superInterfaces.length; ++i) {
            superInterfaces[i] = CTDecoder.convertClassToType(cr.getInterfaceName(i));
        }
        String superName = cr.getSuperName();
        if ("java/io/File".equals(cr.getName()) || "java/lang/Throwable".equals(cr.getName())) {
            System.err.println(superName);
        }
        store.setClassInfo(CTDecoder.convertClassToType(cr.getName()), (cr.getAccessFlags() & 0x200) != 0, (cr.getAccessFlags() & 0x10) != 0, superName != null ? CTDecoder.convertClassToType(superName) : null, superInterfaces);
    }

    public static void compileAndAddMethodToClassWriter(MethodData md, ClassWriter classWriter, ClassWriter.Element rawLines) {
        if (classWriter == null) {
            throw new IllegalArgumentException("classWriter is null");
        }
        if (md == null) {
            throw new IllegalArgumentException("md is null");
        }
        CTCompiler compiler = CTCompiler.make(classWriter, md);
        compiler.compile();
        Compiler.Output output = compiler.getOutput();
        CodeWriter code = new CodeWriter(classWriter);
        code.setMaxStack(output.getMaxStack());
        code.setMaxLocals(output.getMaxLocals());
        code.setCode(output.getCode());
        code.setRawHandlers(output.getRawHandlers());
        ClassWriter.Element lines = null;
        if (rawLines == null) {
            int[] newLineMap = new int[code.getCodeLength()];
            Arrays.setAll(newLineMap, i -> i);
            int[] rawTable = LineNumberTableWriter.makeRawTable(newLineMap);
            lines = new LineNumberTableWriter(classWriter);
            ((LineNumberTableWriter)lines).setRawTable(rawTable);
        }
        code.setAttributes(new ClassWriter.Element[]{rawLines == null ? lines : rawLines});
        ClassWriter.Element[] elements = new ClassWriter.Element[]{code};
        classWriter.addMethod(md.getAccess(), md.getName(), md.getSignature(), elements);
    }
}

