/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.sourcepos;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public final class Debug {
    public static final boolean PRINT_CHARACTER_RANGE_TABLE = false;
    private static PrintStream OUT_STREAM = System.out;
    private static final Map<LogLevel, LogStream> logStreams = new EnumMap<LogLevel, LogStream>(LogLevel.class);
    private static final Set<LogLevel> allowed = EnumSet.noneOf(LogLevel.class);

    private Debug() {
    }

    public static void setLogFile(String file) throws FileNotFoundException {
        OUT_STREAM = file != null && file.equals("console") ? System.out : (file != null ? new PrintStream(file) : null);
    }

    public static void setMinLogLevel(LogLevel level) {
        for (LogLevel l : LogLevel.values()) {
            if (l == level || l.isHigherPriority(level)) {
                Debug.allow(l);
                continue;
            }
            Debug.ignore(l);
        }
    }

    public static void noLogging() {
        for (LogLevel l : LogLevel.values()) {
            Debug.ignore(l);
        }
    }

    public static void fullLogging() {
        for (LogLevel l : LogLevel.values()) {
            Debug.allow(l);
        }
    }

    public static void error(String str, Object ... obj) {
        Debug.log(LogLevel.ERROR, str + '\n', obj);
    }

    public static void warn(String str, Object ... obj) {
        Debug.log(LogLevel.WARN, str + '\n', obj);
    }

    public static void info(String str, Object ... obj) {
        Debug.log(LogLevel.INFO, str + '\n', obj);
    }

    public static void debug(String str, Object ... obj) {
        Debug.log(LogLevel.DEBUG, str + '\n', obj);
    }

    public static void error(String str) {
        Debug.log(LogLevel.ERROR, str + '\n');
    }

    public static void warn(String str) {
        Debug.log(LogLevel.WARN, str + '\n');
    }

    public static void logTime() {
        Date date = new Date();
        Debug.log(LogLevel.INFO, "Current time: " + date + '\n');
    }

    public static void info(String str) {
        Debug.log(LogLevel.INFO, str + '\n');
    }

    public static void appendInfo(String str) {
        if (OUT_STREAM != null && allowed.contains((Object)LogLevel.INFO)) {
            OUT_STREAM.print(str);
        }
    }

    public static void debug(String str) {
        Debug.log(LogLevel.DEBUG, str + '\n');
    }

    public static void error(Throwable t) {
        Debug.log(LogLevel.ERROR, t);
    }

    public static void warn(Throwable t) {
        Debug.log(LogLevel.WARN, t);
    }

    public static void info(Throwable t) {
        Debug.log(LogLevel.INFO, t);
    }

    public static void debug(Throwable t) {
        Debug.log(LogLevel.DEBUG, t);
    }

    public static void allow(LogLevel level) {
        allowed.add(level);
    }

    public static void ignore(LogLevel level) {
        allowed.remove((Object)level);
    }

    private static void log(LogLevel level, Throwable exc) {
        StringWriter sw = new StringWriter();
        exc.printStackTrace(new PrintWriter(sw));
        Debug.log(level, sw.toString());
    }

    private static void log(LogLevel level, String str) {
        if (OUT_STREAM != null && allowed.contains((Object)level)) {
            OUT_STREAM.print("[" + (Object)((Object)level) + "] " + str);
        }
    }

    private static void log(LogLevel level, String str, Object ... obj) {
        if (OUT_STREAM != null && allowed.contains((Object)level)) {
            OUT_STREAM.format("[" + (Object)((Object)level) + "] " + str, obj);
        }
    }

    public static PrintStream getStream(LogLevel level) {
        LogStream logStream = logStreams.get((Object)level);
        if (OUT_STREAM != null && logStream == null) {
            logStream = new LogStream((OutputStream)OUT_STREAM, level);
            LogStream logStream2 = logStreams.put(level, logStream);
        }
        return logStream;
    }

    static {
        allowed.addAll(Arrays.asList(LogLevel.values()));
    }

    private static final class LogStream
    extends PrintStream {
        private final LogLevel level;

        LogStream(OutputStream out, LogLevel level) {
            super(out);
            this.level = level;
        }

        @Override
        public void print(String str) {
            Debug.log(this.level, str);
        }

        @Override
        public void println(String str) {
            Debug.log(this.level, str + '\n');
        }
    }

    public static enum LogLevel {
        DEBUG(0),
        INFO(1),
        WARN(2),
        ERROR(3);

        private final Integer priority;

        private LogLevel(int priority) {
            this.priority = priority;
        }

        public boolean isHigherPriority(LogLevel l) {
            return this.priority > l.priority;
        }
    }
}

