/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT;

import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrike.shrikeBT.Instruction;
import com.ibm.wala.shrike.shrikeBT.Util;

public final class StoreInstruction
extends Instruction
implements IStoreInstruction {
    private final int index;
    private static final StoreInstruction[] preallocated = StoreInstruction.preallocate();

    private StoreInstruction(short opcode, int index) {
        super(opcode);
        this.index = index;
    }

    private static StoreInstruction[] preallocate() {
        StoreInstruction[] r = new StoreInstruction[80];
        for (int p = 0; p < 5; ++p) {
            int i;
            for (i = 0; i < 4; ++i) {
                r[p * 16 + i] = new StoreInstruction((short)(59 + i + p * 4), i);
            }
            for (i = 4; i < 16; ++i) {
                r[p * 16 + i] = new StoreInstruction((short)(54 + p), i);
            }
        }
        return r;
    }

    public static StoreInstruction make(String type, int index) throws IllegalArgumentException {
        int t = Util.getTypeIndex(type);
        if (t < 0 || t > 4) {
            throw new IllegalArgumentException("Cannot store local of type " + type);
        }
        if (index < 16) {
            return preallocated[t * 16 + index];
        }
        return new StoreInstruction((short)(54 + t), index);
    }

    @Override
    public int getVarIndex() {
        return this.index;
    }

    @Override
    public String getType() {
        if (this.opcode < 59) {
            return indexedTypes[this.opcode - 54];
        }
        return indexedTypes[(this.opcode - 59) / 4];
    }

    public boolean equals(Object o) {
        if (o instanceof StoreInstruction) {
            StoreInstruction i = (StoreInstruction)o;
            return i.index == this.index && i.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode + this.index * 148091891;
    }

    @Override
    public int getPoppedCount() {
        return 1;
    }

    @Override
    public String toString() {
        return "LocalStore(" + this.getType() + ',' + this.index + ')';
    }

    @Override
    public void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitLocalStore(this);
    }

    @Override
    public boolean isPEI() {
        return false;
    }
}

