/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT;

import com.ibm.wala.shrike.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrike.shrikeBT.IGetInstruction;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.Instruction;
import com.ibm.wala.shrike.shrikeBT.Util;

public class GetInstruction
extends Instruction
implements IGetInstruction {
    protected String type;
    protected String classType;
    protected String fieldName;

    GetInstruction(short opcode, String type, String classType, String fieldName) {
        super(opcode);
        this.type = type;
        this.classType = classType;
        this.fieldName = fieldName;
    }

    ConstantPoolReader getLazyConstantPool() {
        return null;
    }

    static GetInstruction make(ConstantPoolReader cp, int index, boolean isStatic) {
        return new Lazy(isStatic ? (short)178 : 180, cp, index);
    }

    public static GetInstruction make(String type, String className, String fieldName, boolean isStatic) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        return new GetInstruction(isStatic ? (short)178 : 180, type, className, fieldName);
    }

    public final boolean equals(Object o) {
        if (o instanceof GetInstruction) {
            GetInstruction i = (GetInstruction)o;
            return i.getFieldType().equals(this.getFieldType()) && i.getClassType().equals(this.getClassType()) && i.getFieldName().equals(this.getFieldName()) && i.opcode == this.opcode;
        }
        return false;
    }

    @Override
    public String getClassType() {
        return this.classType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public String getFieldType() {
        return this.type;
    }

    @Override
    public final boolean isStatic() {
        return this.opcode == 178;
    }

    public final int hashCode() {
        return this.getClassType().hashCode() + 11113 * this.getFieldType().hashCode() + 398011 * this.getFieldName().hashCode() + this.opcode;
    }

    @Override
    public final int getPoppedCount() {
        return this.isStatic() ? 0 : 1;
    }

    @Override
    public final String getPushedType(String[] types) {
        return this.getFieldType();
    }

    @Override
    public final byte getPushedWordSize() {
        return Util.getWordSize(this.getFieldType());
    }

    @Override
    public String toString() {
        return "Get(" + this.getFieldType() + ',' + (this.isStatic() ? "STATIC" : "NONSTATIC") + ',' + this.getClassType() + ',' + this.getFieldName() + ')';
    }

    @Override
    public void visit(IInstruction.Visitor v) throws IllegalArgumentException {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        v.visitGet(this);
    }

    @Override
    public boolean isPEI() {
        return !this.isStatic();
    }

    @Override
    public boolean isAddressOf() {
        return false;
    }

    static final class Lazy
    extends GetInstruction {
        private final ConstantPoolReader cp;
        private final int index;

        Lazy(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, null, null, null);
            this.index = index;
            this.cp = cp;
        }

        @Override
        ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        int getCPIndex() {
            return this.index;
        }

        @Override
        public String getClassType() {
            if (this.classType == null) {
                this.classType = this.cp.getConstantPoolMemberClassType(this.index);
            }
            return this.classType;
        }

        @Override
        public String getFieldName() {
            if (this.fieldName == null) {
                this.fieldName = this.cp.getConstantPoolMemberName(this.index);
            }
            return this.fieldName;
        }

        @Override
        public String getFieldType() {
            if (this.type == null) {
                this.type = this.cp.getConstantPoolMemberType(this.index);
            }
            return this.type;
        }
    }
}

