/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT;

import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrike.shrikeBT.Instruction;
import com.ibm.wala.shrike.shrikeBT.Util;

public final class LoadInstruction
extends Instruction
implements ILoadInstruction {
    private final int index;
    private static final LoadInstruction[] preallocated = LoadInstruction.preallocate();

    private LoadInstruction(short opcode, int index) {
        super(opcode);
        this.index = index;
    }

    private static LoadInstruction[] preallocate() {
        LoadInstruction[] r = new LoadInstruction[80];
        for (int p = 0; p < 5; ++p) {
            int i;
            for (i = 0; i < 4; ++i) {
                r[p * 16 + i] = new LoadInstruction((short)(26 + i + p * 4), i);
            }
            for (i = 4; i < 16; ++i) {
                r[p * 16 + i] = new LoadInstruction((short)(21 + p), i);
            }
        }
        return r;
    }

    public static LoadInstruction make(String type, int index) throws IllegalArgumentException {
        int t = Util.getTypeIndex(type);
        if (t < 0 || t > 4) {
            throw new IllegalArgumentException("Cannot load local of type " + type);
        }
        if (index < 16) {
            return preallocated[t * 16 + index];
        }
        return new LoadInstruction((short)(21 + t), index);
    }

    @Override
    public int getVarIndex() {
        return this.index;
    }

    @Override
    public String getType() {
        if (this.opcode < 26) {
            return indexedTypes[this.opcode - 21];
        }
        return indexedTypes[(this.opcode - 26) / 4];
    }

    @Override
    public String getPushedType(String[] types) {
        return this.getType();
    }

    @Override
    public byte getPushedWordSize() {
        return Util.getWordSize(this.getType());
    }

    @Override
    public void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitLocalLoad(this);
    }

    public boolean equals(Object o) {
        if (o instanceof LoadInstruction) {
            LoadInstruction i = (LoadInstruction)o;
            return i.index == this.index && i.opcode == this.opcode;
        }
        return false;
    }

    public int hashCode() {
        return this.opcode + this.index * 19801901;
    }

    @Override
    public String toString() {
        return "LocalLoad(" + this.getType() + ',' + this.index + ')';
    }

    @Override
    public boolean isPEI() {
        return false;
    }

    @Override
    public boolean isAddressOf() {
        return false;
    }
}

