/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT.analysis;

import com.ibm.wala.shrike.shrikeBT.analysis.ClassHierarchyProvider;
import java.util.HashSet;
import java.util.Iterator;

public final class ClassHierarchy {
    public static final int NO = 1;
    public static final int YES = 2;
    public static final int MAYBE = 3;

    private ClassHierarchy() {
    }

    private static int checkSuperinterfacesContain(ClassHierarchyProvider hierarchy, String t1, String t2, HashSet<String> visited) {
        String[] ifaces = hierarchy.getSuperInterfaces(t1);
        if (ifaces == null) {
            return 3;
        }
        int r = 1;
        for (String iface2 : ifaces) {
            String iface = iface2;
            if (!visited.add(iface)) continue;
            if (iface.equals(t2)) {
                return 2;
            }
            int v = ClassHierarchy.checkSuperinterfacesContain(hierarchy, iface, t2, visited);
            switch (v) {
                case 2: {
                    return 2;
                }
                case 3: {
                    r = 3;
                }
            }
        }
        return r;
    }

    private static int checkSupertypesContain(ClassHierarchyProvider hierarchy, String t1, String t2) {
        int r = 1;
        String c = t1;
        while (true) {
            String sup;
            if ((sup = hierarchy.getSuperClass(c)) == null) {
                if (c.equals("Ljava/lang/Object;")) break;
                r = 3;
                break;
            }
            if (sup.equals(t2)) {
                return 2;
            }
            c = sup;
        }
        if (hierarchy.isInterface(t2) != 1) {
            HashSet<String> visited = new HashSet<String>();
            c = t1;
            while (c != null) {
                int v = ClassHierarchy.checkSuperinterfacesContain(hierarchy, c, t2, visited);
                switch (v) {
                    case 2: {
                        return 2;
                    }
                    case 3: {
                        r = 3;
                    }
                }
                c = hierarchy.getSuperClass(c);
            }
        }
        return r;
    }

    private static int checkSubtypesContain(ClassHierarchyProvider hierarchy, String t1, String t2, HashSet<String> visited) {
        if (hierarchy.isInterface(t1) == 1 && hierarchy.isInterface(t2) == 2) {
            return 1;
        }
        String[] subtypes = hierarchy.getSubClasses(t1);
        if (subtypes == null) {
            return 3;
        }
        int r = 1;
        for (String subtype : subtypes) {
            String subt = subtype;
            if (!visited.add(subt)) continue;
            if (subt.equals(t2)) {
                return 2;
            }
            int v = ClassHierarchy.checkSubtypesContain(hierarchy, subt, t2, visited);
            switch (v) {
                case 2: {
                    return 2;
                }
                case 3: {
                    r = 3;
                }
            }
        }
        return r;
    }

    private static int checkSubtypeOfHierarchy(ClassHierarchyProvider hierarchy, String t1, String t2) {
        if (t2.equals("Ljava/lang/Object;")) {
            return 2;
        }
        int v = ClassHierarchy.checkSupertypesContain(hierarchy, t1, t2);
        if (v == 3) {
            v = ClassHierarchy.checkSubtypesContain(hierarchy, t2, t1, new HashSet<String>());
        }
        return v;
    }

    public static int isSubtypeOf(ClassHierarchyProvider hierarchy, String t1, String t2) {
        if (t1 == null || t2 == null) {
            return 1;
        }
        if (t1.equals(t2)) {
            return 2;
        }
        if (t1.equals("L?;") || t2.equals("L?;")) {
            return 3;
        }
        switch (t1.charAt(0)) {
            case 'L': {
                if (t1.equals("L;")) {
                    return 2;
                }
                if (t2.startsWith("[")) {
                    return 1;
                }
                if (hierarchy == null) {
                    return 3;
                }
                return ClassHierarchy.checkSubtypeOfHierarchy(hierarchy, t1, t2);
            }
            case '[': {
                if (t2.equals("Ljava/lang/Object;") || t2.equals("Ljava/io/Serializable;") || t2.equals("Ljava/lang/Cloneable;")) {
                    return 2;
                }
                if (t2.startsWith("[")) {
                    return ClassHierarchy.isSubtypeOf(hierarchy, t1.substring(1), t2.substring(1));
                }
                return 1;
            }
        }
        return 1;
    }

    private static boolean insertSuperInterfaces(ClassHierarchyProvider hierarchy, String t, HashSet<String> supers) {
        String[] ifaces = hierarchy.getSuperInterfaces(t);
        if (ifaces == null) {
            return false;
        }
        boolean r = true;
        for (String iface : ifaces) {
            if (!supers.add(iface) || ClassHierarchy.insertSuperInterfaces(hierarchy, iface, supers)) continue;
            r = false;
        }
        return r;
    }

    private static boolean insertSuperClasses(ClassHierarchyProvider hierarchy, String t, HashSet<String> supers) {
        String last = t;
        String c = t;
        while (c != null) {
            supers.add(c);
            last = c;
            c = hierarchy.getSuperClass(c);
        }
        return last.equals("Ljava/lang/Object;");
    }

    private static boolean insertSuperClassInterfaces(ClassHierarchyProvider hierarchy, String t, HashSet<String> supers) {
        boolean r = true;
        String c = t;
        while (c != null) {
            if (!ClassHierarchy.insertSuperInterfaces(hierarchy, c, supers)) {
                r = false;
            }
            c = hierarchy.getSuperClass(c);
        }
        return r;
    }

    private static boolean collectDominatingSuperClasses(ClassHierarchyProvider hierarchy, String t, HashSet<String> matches, HashSet<String> supers) {
        String last = t;
        String c = t;
        while (c != null) {
            if (matches.contains(c)) {
                supers.add(c);
                return true;
            }
            last = c;
            c = hierarchy.getSuperClass(c);
        }
        return last.equals("Ljava/lang/Object;");
    }

    private static boolean collectDominatingSuperInterfacesFromClass(ClassHierarchyProvider hierarchy, String t, HashSet<String> supers) {
        String[] ifaces = hierarchy.getSuperInterfaces(t);
        if (ifaces == null) {
            return false;
        }
        boolean r = true;
        for (String iface : ifaces) {
            if (!supers.add(iface) || ClassHierarchy.insertSuperInterfaces(hierarchy, iface, supers)) continue;
            r = false;
        }
        return r;
    }

    private static boolean collectDominatingSuperInterfaces(ClassHierarchyProvider hierarchy, String t, HashSet<String> supers) {
        boolean r = true;
        String c = t;
        while (c != null && !supers.contains(c)) {
            if (!ClassHierarchy.collectDominatingSuperInterfacesFromClass(hierarchy, c, supers)) {
                r = false;
            }
            c = hierarchy.getSuperClass(c);
        }
        return r;
    }

    private static String findCommonSupertypeHierarchy(ClassHierarchyProvider hierarchy, String t1, String t2) {
        boolean t2ExactInterfaces;
        if (ClassHierarchy.isSubtypeOf(hierarchy, t1, t2) == 2) {
            return t2;
        }
        if (ClassHierarchy.isSubtypeOf(hierarchy, t2, t1) == 2) {
            return t1;
        }
        HashSet<String> t1Supers = new HashSet<String>();
        t1Supers.add("Ljava/lang/Object;");
        boolean t1ExactClasses = ClassHierarchy.insertSuperClasses(hierarchy, t1, t1Supers);
        int t1ClassCount = t1Supers.size();
        boolean t1ExactInterfaces = ClassHierarchy.insertSuperClassInterfaces(hierarchy, t1, t1Supers);
        HashSet<String> t2Supers = new HashSet<String>();
        boolean t2ExactClasses = ClassHierarchy.collectDominatingSuperClasses(hierarchy, t2, t1Supers, t2Supers);
        if (t2Supers.size() == 0) {
            return "L?;";
        }
        if (t1ExactInterfaces && t1ExactClasses && t1Supers.size() - t1ClassCount == 0) {
            t2ExactInterfaces = true;
        } else {
            t2ExactInterfaces = ClassHierarchy.collectDominatingSuperInterfaces(hierarchy, t2, t2Supers);
            if (!t1ExactInterfaces && t2Supers.size() != 1) {
                return "L?;";
            }
        }
        if (!t2ExactClasses || !t2ExactInterfaces) {
            return "";
        }
        Iterator<String> iter = t2Supers.iterator();
        while (iter.hasNext()) {
            String element = iter.next();
            boolean subsumed = false;
            for (String element2 : t2Supers) {
                if (element == element2 || ClassHierarchy.isSubtypeOf(hierarchy, element2, element) != 2) continue;
                subsumed = true;
                break;
            }
            if (!subsumed) continue;
            iter.remove();
        }
        if (t2Supers.size() == 1) {
            return t2Supers.iterator().next();
        }
        if (t2Supers.size() == 0) {
            return "Ljava/lang/Object;";
        }
        return "L?;";
    }

    public static String findCommonSupertype(ClassHierarchyProvider hierarchy, String t1, String t2) {
        if (t1 == null || t2 == null) {
            return null;
        }
        if (t1.equals(t2)) {
            return t1;
        }
        if (t1.equals("L?;") || t2.equals("L?;")) {
            return "L?;";
        }
        if (t2.charAt(0) == '[') {
            String t = t1;
            t1 = t2;
            t2 = t;
        }
        switch (t1.charAt(0)) {
            case 'L': {
                if (t1.equals("L;")) {
                    return t2;
                }
                if (t2.equals("L;")) {
                    return t1;
                }
                if (hierarchy == null) {
                    return "L?;";
                }
                return ClassHierarchy.findCommonSupertypeHierarchy(hierarchy, t1, t2);
            }
            case '[': {
                char ch2 = t2.charAt(0);
                switch (ch2) {
                    case '[': {
                        char ch1_1 = t1.charAt(1);
                        if (ch1_1 == '[' || ch1_1 == 'L') {
                            return '[' + ClassHierarchy.findCommonSupertype(hierarchy, t1.substring(1), t2.substring(1));
                        }
                        return "Ljava/lang/Object;";
                    }
                    case 'L': {
                        switch (t2) {
                            case "L;": {
                                return t1;
                            }
                            case "Ljava/io/Serializable;": 
                            case "Ljava/lang/Cloneable;": {
                                return t2;
                            }
                        }
                        return "Ljava/lang/Object;";
                    }
                }
                return null;
            }
        }
        return null;
    }
}

