/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeCT;

import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;

public abstract class AttributeReader {
    protected final ClassReader cr;
    protected final int attr;
    protected final int length;

    protected AttributeReader(ClassReader.AttrIterator attr, String expectedName) throws InvalidClassFileException {
        if (attr == null) {
            throw new IllegalArgumentException("attr cannot be null");
        }
        attr.verifyValid();
        this.cr = attr.cr;
        this.attr = attr.offset;
        this.length = attr.size;
        String n = attr.getName();
        if (expectedName != n && !expectedName.equals(n)) {
            throw new IllegalArgumentException("Attribute " + n + " is not a " + expectedName + " attribute");
        }
    }

    public final ClassReader getClassReader() {
        return this.cr;
    }

    public final int getRawOffset() {
        return this.attr;
    }

    public final int getRawSize() {
        return this.length;
    }

    protected final void checkSize(int offset, int len) throws InvalidClassFileException {
        if (this.length < offset - this.attr + len) {
            throw new InvalidClassFileException(offset, "Attribute data too short, expected " + len + " bytes, got " + (this.length + this.attr - offset));
        }
    }

    protected final void checkSizeEquals(int offset, int len) throws InvalidClassFileException {
        if (this.length != offset - this.attr + len) {
            throw new InvalidClassFileException(offset, "Attribute data invalid length, expected " + len + " bytes, got " + (this.length + this.attr - offset));
        }
    }
}

