/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.instrumentation;

import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;
import com.ibm.wala.shrike.shrikeCT.SourceFileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.ProtectionDomain;

public class CodeScraper
implements ClassFileTransformer {
    private static final Path prefix;

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            block13: {
                String sourceFile = null;
                ClassReader reader = new ClassReader(classfileBuffer);
                ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
                reader.initClassAttributeIterator(attrs);
                while (attrs.isValid()) {
                    if (attrs.getName().equals("SourceFile")) {
                        SourceFileReader file = new SourceFileReader(attrs);
                        int index = file.getSourceFileCPIndex();
                        sourceFile = reader.getCP().getCPUtf8(index);
                    }
                    attrs.advance();
                }
                if (className == null || sourceFile == null || sourceFile.endsWith("java")) {
                    // empty if block
                }
                try {
                    Path log = prefix.resolve(reader.getName() + ".class");
                    try (OutputStream f = Files.newOutputStream(log, new OpenOption[0]);){
                        f.write(classfileBuffer);
                    }
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError((Object)e);
                }
            }
            return classfileBuffer;
        }
        catch (InvalidClassFileException e1) {
            e1.printStackTrace();
            throw new IllegalClassFormatException(e1.getLocalizedMessage());
        }
    }

    public static void premain(Instrumentation inst) {
        inst.addTransformer(new CodeScraper());
    }

    static {
        try {
            prefix = Files.createTempDirectory("loggedClasses", new FileAttribute[0]);
            prefix.toFile().deleteOnExit();
        }
        catch (IOException problem) {
            throw new RuntimeException(problem);
        }
        System.err.println("scraping to " + prefix);
    }
}

