/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT;

import com.ibm.wala.shrike.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.Instruction;
import com.ibm.wala.shrike.shrikeBT.Util;

public final class ConditionalBranchInstruction
extends Instruction
implements IConditionalBranchInstruction {
    private final int label;

    private ConditionalBranchInstruction(short opcode, int label) {
        super(opcode);
        this.label = label;
    }

    public static ConditionalBranchInstruction make(String type, IConditionalBranchInstruction.Operator operator, int label) throws IllegalArgumentException {
        short opcode;
        int t = Util.getTypeIndex(type);
        switch (t) {
            case 0: {
                opcode = (short)(159 + (operator.ordinal() - IConditionalBranchInstruction.Operator.EQ.ordinal()));
                break;
            }
            case 4: {
                if (operator != IConditionalBranchInstruction.Operator.EQ && operator != IConditionalBranchInstruction.Operator.NE) {
                    throw new IllegalArgumentException("Cannot test for condition " + operator + " on a reference");
                }
                opcode = (short)(165 + (operator.ordinal() - IConditionalBranchInstruction.Operator.EQ.ordinal()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot conditionally branch on a value of type " + type);
            }
        }
        return ConditionalBranchInstruction.make(opcode, label);
    }

    public static ConditionalBranchInstruction make(short opcode, int label) throws IllegalArgumentException {
        if (opcode < 153 || opcode > 166) {
            throw new IllegalArgumentException("Illegal opcode: " + opcode);
        }
        return new ConditionalBranchInstruction(opcode, label);
    }

    public boolean equals(Object o) {
        if (o instanceof ConditionalBranchInstruction) {
            ConditionalBranchInstruction i = (ConditionalBranchInstruction)o;
            return i.opcode == this.opcode && i.label == this.label;
        }
        return false;
    }

    @Override
    public String toString() {
        return "ConditionalBranch(" + this.getType() + "," + this.getOperator() + "," + this.label + ")";
    }

    @Override
    public int[] getBranchTargets() {
        int[] r = new int[]{this.label};
        return r;
    }

    @Override
    public int getTarget() {
        return this.label;
    }

    @Override
    public IInstruction redirectTargets(int[] targetMap) throws IllegalArgumentException {
        if (targetMap == null) {
            throw new IllegalArgumentException("targetMap is null");
        }
        try {
            return ConditionalBranchInstruction.make(this.opcode, targetMap[this.label]);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("bad target map", e);
        }
    }

    @Override
    public IConditionalBranchInstruction.Operator getOperator() {
        if (this.opcode < 165) {
            return IConditionalBranchInstruction.Operator.values()[this.opcode - 159];
        }
        return IConditionalBranchInstruction.Operator.values()[this.opcode - 165];
    }

    @Override
    public String getType() {
        return this.opcode < 165 ? "I" : "Ljava/lang/Object;";
    }

    public int hashCode() {
        return 30190 * this.opcode + 384101 * this.label;
    }

    @Override
    public int getPoppedCount() {
        if (this.opcode >= 153 && this.opcode <= 158) {
            return 1;
        }
        return 2;
    }

    @Override
    public void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitConditionalBranch(this);
    }

    @Override
    public boolean isPEI() {
        return false;
    }
}

