/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.bench;

import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.InvokeInstruction;
import com.ibm.wala.shrike.shrikeBT.MethodData;
import com.ibm.wala.shrike.shrikeBT.Util;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.ClassInstrumenter;
import com.ibm.wala.shrike.shrikeBT.shrikeCT.OfflineInstrumenter;
import com.ibm.wala.shrike.shrikeCT.ClassReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.Writer;

public class Statistics {
    private static OfflineInstrumenter instrumenter;

    public static void main(String[] args) throws Exception {
        for (int i = 0; i < 1; ++i) {
            instrumenter = new OfflineInstrumenter();
            try (BufferedWriter w = new BufferedWriter(new FileWriter("report", false));){
                ClassInstrumenter ci;
                args = instrumenter.parseStandardArgs(args);
                instrumenter.beginTraversal();
                while ((ci = instrumenter.nextClass()) != null) {
                    Statistics.doClass(ci, w);
                }
                instrumenter.close();
                continue;
            }
        }
    }

    private static void doClass(ClassInstrumenter ci, Writer w) throws Exception {
        ClassReader cr = ci.getReader();
        String className = cr.getName();
        w.write("Class: " + className + "\n");
        boolean allPrivateConstructors = true;
        boolean methodCallsConstructor = false;
        boolean classInitCallsConstructor = false;
        for (int m = 0; m < cr.getMethodCount(); ++m) {
            IInstruction[] instrs;
            int f;
            MethodData d = ci.visitMethod(m);
            if (d == null) continue;
            if (d.getName().equals("<init>") && ((f = cr.getMethodAccessFlags(m)) & 2) == 0 && ((f & 4) == 0 || (cr.getAccessFlags() & 0x10) == 0)) {
                allPrivateConstructors = false;
            }
            int constructorCalls = 0;
            for (IInstruction instr : instrs = d.getInstructions()) {
                InvokeInstruction invoke;
                if (!(instr instanceof InvokeInstruction) || !(invoke = (InvokeInstruction)instr).getMethodName().equals("<init>") || !invoke.getClassType().equals(Util.makeType(className))) continue;
                ++constructorCalls;
            }
            if (!d.getName().equals("<init>") && !d.getName().equals("<clinit>")) {
                if (constructorCalls <= 0) continue;
                methodCallsConstructor = true;
                continue;
            }
            if (!d.getName().equals("<clinit>")) continue;
            classInitCallsConstructor = true;
        }
        if (allPrivateConstructors && !methodCallsConstructor && classInitCallsConstructor) {
            w.write("Restricted Creation\n");
        }
    }
}

