/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT;

import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.Instruction;

public final class NewInstruction
extends Instruction {
    private final String type;
    private final short arrayBoundsCount;

    private NewInstruction(short opcode, String type, short arrayBoundsCount) {
        super(opcode);
        this.type = type;
        this.arrayBoundsCount = arrayBoundsCount;
    }

    public static NewInstruction make(String type, int arrayBoundsCount) throws IllegalArgumentException {
        int opcode;
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (arrayBoundsCount < 0 || arrayBoundsCount > 255) {
            throw new IllegalArgumentException("Too many array bounds: " + arrayBoundsCount);
        }
        if (type.length() < arrayBoundsCount + 1) {
            throw new IllegalArgumentException("Not enough array nesting in " + type + " for bounds count " + arrayBoundsCount);
        }
        for (int i = 0; i < arrayBoundsCount; ++i) {
            if (type.charAt(i) == '[') continue;
            throw new IllegalArgumentException("Not enough array nesting in " + type + " for bounds count " + arrayBoundsCount);
        }
        switch (arrayBoundsCount) {
            case 0: {
                opcode = 187;
                break;
            }
            case 1: {
                char ch = type.charAt(1);
                if (ch != 'L' && ch != '[') {
                    opcode = 188;
                    break;
                }
                opcode = 189;
                break;
            }
            default: {
                opcode = 197;
            }
        }
        return new NewInstruction((short)opcode, type, (short)arrayBoundsCount);
    }

    public boolean equals(Object o) {
        if (o instanceof NewInstruction) {
            NewInstruction i = (NewInstruction)o;
            return i.type.equals(this.type) && i.arrayBoundsCount == this.arrayBoundsCount;
        }
        return false;
    }

    public int getArrayBoundsCount() {
        return this.arrayBoundsCount;
    }

    public int hashCode() {
        return 13111143 * this.type.hashCode() + this.arrayBoundsCount;
    }

    @Override
    public int getPoppedCount() {
        return this.arrayBoundsCount;
    }

    @Override
    public String getPushedType(String[] types) {
        return this.type;
    }

    @Override
    public byte getPushedWordSize() {
        return 1;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return "New(" + this.type + "," + this.arrayBoundsCount + ")";
    }

    @Override
    public void visit(IInstruction.Visitor v) throws IllegalArgumentException {
        if (v == null) {
            throw new IllegalArgumentException();
        }
        v.visitNew(this);
    }

    @Override
    public boolean isPEI() {
        return true;
    }
}

