/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT;

import com.ibm.wala.shrike.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.IPutInstruction;
import com.ibm.wala.shrike.shrikeBT.Instruction;

public class PutInstruction
extends Instruction
implements IPutInstruction {
    protected String type;
    protected String classType;
    protected String fieldName;

    PutInstruction(short opcode, String type, String classType, String fieldName) {
        super(opcode);
        this.type = type;
        this.classType = classType;
        this.fieldName = fieldName;
    }

    ConstantPoolReader getLazyConstantPool() {
        return null;
    }

    static PutInstruction make(ConstantPoolReader cp, int index, boolean isStatic) {
        return new Lazy(isStatic ? (short)179 : 181, cp, index);
    }

    public static PutInstruction make(String type, String className, String fieldName, boolean isStatic) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("className must not be null");
        }
        if (fieldName == null) {
            throw new IllegalArgumentException("fieldName must not be null");
        }
        return new PutInstruction(isStatic ? (short)179 : 181, type, className, fieldName);
    }

    public final boolean equals(Object o) {
        if (o instanceof PutInstruction) {
            PutInstruction i = (PutInstruction)o;
            return i.getFieldType().equals(this.getFieldType()) && i.getClassType().equals(this.getClassType()) && i.getFieldName().equals(this.getFieldName()) && i.opcode == this.opcode;
        }
        return false;
    }

    @Override
    public String getClassType() {
        return this.classType;
    }

    @Override
    public String getFieldType() {
        return this.type;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public final boolean isStatic() {
        return this.opcode == 179;
    }

    public final int hashCode() {
        return this.getClassType().hashCode() + 9011 * this.getClassType().hashCode() + 317 * this.getFieldName().hashCode() + this.opcode;
    }

    @Override
    public final int getPoppedCount() {
        return this.isStatic() ? 1 : 2;
    }

    @Override
    public final String toString() {
        return "Put(" + this.getFieldType() + "," + (this.isStatic() ? "STATIC" : "NONSTATIC") + "," + this.getClassType() + "," + this.getFieldName() + ")";
    }

    @Override
    public final void visit(IInstruction.Visitor v) throws NullPointerException {
        v.visitPut(this);
    }

    @Override
    public boolean isPEI() {
        return !this.isStatic();
    }

    static final class Lazy
    extends PutInstruction {
        private final ConstantPoolReader cp;
        private final int index;

        Lazy(short opcode, ConstantPoolReader cp, int index) {
            super(opcode, null, null, null);
            this.index = index;
            this.cp = cp;
        }

        @Override
        ConstantPoolReader getLazyConstantPool() {
            return this.cp;
        }

        int getCPIndex() {
            return this.index;
        }

        @Override
        public String getClassType() {
            if (this.classType == null) {
                this.classType = this.cp.getConstantPoolMemberClassType(this.index);
            }
            return this.classType;
        }

        @Override
        public String getFieldName() {
            if (this.fieldName == null) {
                this.fieldName = this.cp.getConstantPoolMemberName(this.index);
            }
            return this.fieldName;
        }

        @Override
        public String getFieldType() {
            if (this.type == null) {
                this.type = this.cp.getConstantPoolMemberType(this.index);
            }
            return this.type;
        }
    }
}

