/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT.info;

import com.ibm.wala.shrike.shrikeBT.ArrayLengthInstruction;
import com.ibm.wala.shrike.shrikeBT.ConstantInstruction;
import com.ibm.wala.shrike.shrikeBT.DupInstruction;
import com.ibm.wala.shrike.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrike.shrikeBT.GotoInstruction;
import com.ibm.wala.shrike.shrikeBT.IArrayLoadInstruction;
import com.ibm.wala.shrike.shrikeBT.IArrayStoreInstruction;
import com.ibm.wala.shrike.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.shrike.shrikeBT.IComparisonInstruction;
import com.ibm.wala.shrike.shrikeBT.IConditionalBranchInstruction;
import com.ibm.wala.shrike.shrikeBT.IConversionInstruction;
import com.ibm.wala.shrike.shrikeBT.IGetInstruction;
import com.ibm.wala.shrike.shrikeBT.IInstanceofInstruction;
import com.ibm.wala.shrike.shrikeBT.IInstruction;
import com.ibm.wala.shrike.shrikeBT.IInvokeInstruction;
import com.ibm.wala.shrike.shrikeBT.ILoadInstruction;
import com.ibm.wala.shrike.shrikeBT.IPutInstruction;
import com.ibm.wala.shrike.shrikeBT.IShiftInstruction;
import com.ibm.wala.shrike.shrikeBT.IStoreInstruction;
import com.ibm.wala.shrike.shrikeBT.ITypeTestInstruction;
import com.ibm.wala.shrike.shrikeBT.IUnaryOpInstruction;
import com.ibm.wala.shrike.shrikeBT.MethodData;
import com.ibm.wala.shrike.shrikeBT.MonitorInstruction;
import com.ibm.wala.shrike.shrikeBT.NewInstruction;
import com.ibm.wala.shrike.shrikeBT.PopInstruction;
import com.ibm.wala.shrike.shrikeBT.ReturnInstruction;
import com.ibm.wala.shrike.shrikeBT.SwapInstruction;
import com.ibm.wala.shrike.shrikeBT.SwitchInstruction;
import com.ibm.wala.shrike.shrikeBT.ThrowInstruction;

public class InstructionTypeCounter
implements MethodData.Results {
    private static final String key = InstructionTypeCounter.class.getName();
    private int countMonitors;
    private int countGets;
    private int countPuts;
    private int countArrayLoads;
    private int countArrayStores;
    private int countInvokes;
    private int countArrayLengths;
    private int countBinaryOps;
    private int countCheckCasts;
    private int countComparisons;
    private int countConditionalBranches;
    private int countConstants;
    private int countConversions;
    private int countDups;
    private int countGotos;
    private int countInstanceOfs;
    private int countLocalLoads;
    private int countLocalStores;
    private int countNews;
    private int countPops;
    private int countReturns;
    private int countShifts;
    private int countSwaps;
    private int countSwitches;
    private int countThrows;
    private int countUnaryOps;

    InstructionTypeCounter(MethodData info) {
        this.recalculateFrom(info.getInstructions());
    }

    private void recalculateFrom(IInstruction[] instructions) {
        this.countMonitors = 0;
        this.countGets = 0;
        this.countPuts = 0;
        this.countArrayLoads = 0;
        this.countArrayStores = 0;
        this.countInvokes = 0;
        this.countArrayLengths = 0;
        this.countBinaryOps = 0;
        this.countCheckCasts = 0;
        this.countComparisons = 0;
        this.countConditionalBranches = 0;
        this.countConstants = 0;
        this.countConversions = 0;
        this.countDups = 0;
        this.countGotos = 0;
        this.countInstanceOfs = 0;
        this.countLocalLoads = 0;
        this.countLocalStores = 0;
        this.countNews = 0;
        this.countPops = 0;
        this.countReturns = 0;
        this.countShifts = 0;
        this.countSwaps = 0;
        this.countSwitches = 0;
        this.countThrows = 0;
        this.countUnaryOps = 0;
        IInstruction.Visitor visitor = new IInstruction.Visitor(){

            @Override
            public void visitArrayLength(ArrayLengthInstruction instruction) {
                ++InstructionTypeCounter.this.countArrayLengths;
            }

            @Override
            public void visitBinaryOp(IBinaryOpInstruction instruction) {
                ++InstructionTypeCounter.this.countBinaryOps;
            }

            @Override
            public void visitCheckCast(ITypeTestInstruction instruction) {
                ++InstructionTypeCounter.this.countCheckCasts;
            }

            @Override
            public void visitComparison(IComparisonInstruction instruction) {
                ++InstructionTypeCounter.this.countComparisons;
            }

            @Override
            public void visitConditionalBranch(IConditionalBranchInstruction instruction) {
                ++InstructionTypeCounter.this.countConditionalBranches;
            }

            @Override
            public void visitConstant(ConstantInstruction instruction) {
                ++InstructionTypeCounter.this.countConstants;
            }

            @Override
            public void visitConversion(IConversionInstruction instruction) {
                ++InstructionTypeCounter.this.countConversions;
            }

            @Override
            public void visitDup(DupInstruction instruction) {
                ++InstructionTypeCounter.this.countDups;
            }

            @Override
            public void visitGoto(GotoInstruction instruction) {
                ++InstructionTypeCounter.this.countGotos;
            }

            @Override
            public void visitInstanceof(IInstanceofInstruction instruction) {
                ++InstructionTypeCounter.this.countInstanceOfs;
            }

            @Override
            public void visitLocalLoad(ILoadInstruction instruction) {
                ++InstructionTypeCounter.this.countLocalLoads;
            }

            @Override
            public void visitLocalStore(IStoreInstruction instruction) {
                ++InstructionTypeCounter.this.countLocalStores;
            }

            @Override
            public void visitNew(NewInstruction instruction) {
                ++InstructionTypeCounter.this.countNews;
            }

            @Override
            public void visitPop(PopInstruction instruction) {
                ++InstructionTypeCounter.this.countPops;
            }

            @Override
            public void visitReturn(ReturnInstruction instruction) {
                ++InstructionTypeCounter.this.countReturns;
            }

            @Override
            public void visitShift(IShiftInstruction instruction) {
                ++InstructionTypeCounter.this.countShifts;
            }

            @Override
            public void visitSwap(SwapInstruction instruction) {
                ++InstructionTypeCounter.this.countSwaps;
            }

            @Override
            public void visitSwitch(SwitchInstruction instruction) {
                ++InstructionTypeCounter.this.countSwitches;
            }

            @Override
            public void visitThrow(ThrowInstruction instruction) {
                ++InstructionTypeCounter.this.countThrows;
            }

            @Override
            public void visitUnaryOp(IUnaryOpInstruction instruction) {
                ++InstructionTypeCounter.this.countUnaryOps;
            }

            @Override
            public void visitArrayLoad(IArrayLoadInstruction instruction) {
                ++InstructionTypeCounter.this.countArrayLoads;
            }

            @Override
            public void visitArrayStore(IArrayStoreInstruction instruction) {
                ++InstructionTypeCounter.this.countArrayStores;
            }

            @Override
            public void visitGet(IGetInstruction instruction) {
                ++InstructionTypeCounter.this.countGets;
            }

            @Override
            public void visitPut(IPutInstruction instruction) {
                ++InstructionTypeCounter.this.countPuts;
            }

            @Override
            public void visitMonitor(MonitorInstruction instruction) {
                ++InstructionTypeCounter.this.countMonitors;
            }

            @Override
            public void visitInvoke(IInvokeInstruction instruction) {
                ++InstructionTypeCounter.this.countInvokes;
            }
        };
        for (IInstruction instruction : instructions) {
            instruction.visit(visitor);
        }
    }

    @Override
    public boolean notifyUpdate(MethodData info, IInstruction[] newInstructions, ExceptionHandler[][] newHandlers, int[] newInstructionMap) {
        return true;
    }

    public static int getArrayLoadCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countArrayLoads;
    }

    public static int getArrayStoreCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countArrayStores;
    }

    public static int getGetCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countGets;
    }

    public static int getPutCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countPuts;
    }

    public static int getMonitorCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countMonitors;
    }

    public static int getInvokeCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countInvokes;
    }

    public static int getComparisonCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countComparisons;
    }

    public static int getArrayLengthCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countArrayLengths;
    }

    public static int getConstantCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countConstants;
    }

    public static int getShiftCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countShifts;
    }

    public static int getSwitchesCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countSwitches;
    }

    public static int getSwapCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countSwaps;
    }

    public static int getBinaryOpCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countBinaryOps;
    }

    public static int getCheckCastCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countCheckCasts;
    }

    public static int getThrowCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countThrows;
    }

    public static int getConditionalBranchCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countConditionalBranches;
    }

    public static int getConversionCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countConversions;
    }

    public static int getDupCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countDups;
    }

    public static int getGotoCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countGotos;
    }

    public static int getReturnCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countReturns;
    }

    public static int getInstanceOfCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countInstanceOfs;
    }

    public static int getLocalLoadCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countLocalLoads;
    }

    public static int getLocalStoreCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countLocalStores;
    }

    public static int getNewCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countNews;
    }

    public static int getPopCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countPops;
    }

    public static int getUnaryOpCount(MethodData info) throws IllegalArgumentException {
        if (info == null) {
            throw new IllegalArgumentException();
        }
        return InstructionTypeCounter.getCounter((MethodData)info).countUnaryOps;
    }

    private static InstructionTypeCounter getCounter(MethodData info) {
        InstructionTypeCounter c = (InstructionTypeCounter)info.getInfo(key);
        if (c == null) {
            c = new InstructionTypeCounter(info);
            info.putInfo(key, c);
        }
        return c;
    }
}

