/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeBT.shrikeCT;

import com.ibm.wala.shrike.shrikeBT.ConstantPoolReader;
import com.ibm.wala.shrike.shrikeBT.Decoder;
import com.ibm.wala.shrike.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.CodeReader;
import com.ibm.wala.shrike.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;

public final class CTDecoder
extends Decoder {
    public CTDecoder(CodeReader r) throws NullPointerException {
        this(r, CTDecoder.makeConstantPoolReader(r.getClassReader()));
    }

    public CTDecoder(CodeReader r, ConstantPoolReader cpr) throws NullPointerException {
        super(r.getBytecode(), r.getRawHandlers(), cpr);
    }

    public static String convertClassToType(String s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (!s.isEmpty() && s.charAt(0) != '[') {
            return "L" + s + ";";
        }
        return s;
    }

    public static ConstantPoolReader makeConstantPoolReader(ClassReader cr) throws IllegalArgumentException {
        if (cr == null) {
            throw new IllegalArgumentException("illegal null cr");
        }
        return new CPReader(cr.getCP());
    }

    static final class CPReader
    extends ConstantPoolReader {
        private final ConstantPoolParser cp;

        CPReader(ConstantPoolParser cp) {
            this.cp = cp;
        }

        @Override
        public int getConstantPoolItemType(int index) {
            return this.cp.getItemType(index);
        }

        private static Error convertToError(InvalidClassFileException e) {
            e.printStackTrace();
            return new Error("Invalid class file: " + e.getMessage());
        }

        @Override
        public int getConstantPoolInteger(int index) {
            return this.cp.getCPInt(index);
        }

        @Override
        public float getConstantPoolFloat(int index) {
            return this.cp.getCPFloat(index);
        }

        @Override
        public long getConstantPoolLong(int index) {
            return this.cp.getCPLong(index);
        }

        @Override
        public double getConstantPoolDouble(int index) {
            return this.cp.getCPDouble(index);
        }

        @Override
        public String getConstantPoolMethodType(int index) {
            try {
                return this.cp.getCPMethodType(index);
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public String getConstantPoolString(int index) {
            try {
                return this.cp.getCPString(index);
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public String getConstantPoolClassType(int index) {
            try {
                return CTDecoder.convertClassToType(this.cp.getCPClass(index));
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public String getConstantPoolMemberClassType(int index) {
            try {
                return CTDecoder.convertClassToType(this.cp.getCPRefClass(index));
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public String getConstantPoolMemberName(int index) {
            try {
                return this.cp.getCPRefName(index);
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public String getConstantPoolMemberType(int index) {
            try {
                return this.cp.getCPRefType(index);
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public String getConstantPoolHandleClassType(int index) {
            try {
                return this.cp.getCPHandleClass(index);
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public String getConstantPoolHandleName(int index) {
            try {
                return this.cp.getCPHandleName(index);
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public String getConstantPoolHandleType(int index) {
            try {
                return this.cp.getCPHandleType(index);
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public byte getConstantPoolHandleKind(int index) {
            try {
                return this.cp.getCPHandleKind(index);
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public BootstrapMethodsReader.BootstrapMethod getConstantPoolDynamicBootstrap(int index) {
            try {
                return this.cp.getCPDynBootstrap(index);
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public String getConstantPoolDynamicName(int index) {
            try {
                return this.cp.getCPDynName(index);
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }

        @Override
        public String getConstantPoolDynamicType(int index) {
            try {
                return this.cp.getCPDynType(index);
            }
            catch (InvalidClassFileException e) {
                throw CPReader.convertToError(e);
            }
        }
    }
}

