/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeCT;

import com.ibm.wala.shrike.shrikeCT.ClassConstants;
import com.ibm.wala.shrike.shrikeCT.ConstantPoolParser;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;

public final class ClassReader
implements ClassConstants {
    private final byte[] bytes;
    private int[] methodOffsets;
    private int[] fieldOffsets;
    private ConstantPoolParser cpParser;
    private int classInfoOffset;
    private int attrInfoOffset;
    private int interfaceCount;

    public ClassReader(byte[] bytes) throws InvalidClassFileException {
        this.bytes = bytes;
        this.parse();
    }

    private void checkLength(int offset, int required) throws InvalidClassFileException {
        if (this.bytes.length < offset + required) {
            throw new InvalidClassFileException(offset, "file truncated, expected " + required + " bytes, saw only " + (this.bytes.length - offset));
        }
    }

    private void parse() throws InvalidClassFileException {
        int offset = 0;
        this.checkLength(offset, 10);
        int magic = this.getInt(offset);
        int minorVersion = this.getUShort(offset + 4);
        int majorVersion = this.getUShort(offset + 6);
        int constantPoolCount = this.getUShort(offset + 8);
        offset += 10;
        if (magic != -889275714) {
            throw new InvalidClassFileException(offset, "bad magic number: " + magic);
        }
        if (majorVersion < 45 || majorVersion > 65) {
            throw new InvalidClassFileException(offset, "unknown class file version: " + majorVersion + "." + minorVersion);
        }
        this.cpParser = new ConstantPoolParser(this.bytes, offset, constantPoolCount);
        this.classInfoOffset = offset += this.cpParser.getRawSize();
        this.checkLength(offset, 8);
        this.interfaceCount = this.getUShort(offset + 6);
        if (this.interfaceCount < 0) {
            throw new InvalidClassFileException(offset, "negative interface count: " + this.interfaceCount);
        }
        this.checkLength(offset += 8, this.interfaceCount * 2);
        this.checkLength(offset += this.interfaceCount * 2, 2);
        int fieldCount = this.getUShort(offset);
        if (fieldCount < 0) {
            throw new InvalidClassFileException(offset, "negative field count: " + this.interfaceCount);
        }
        offset = this.parseFields(offset + 2, fieldCount);
        this.checkLength(offset, 2);
        int methodCount = this.getUShort(offset);
        if (methodCount < 0) {
            throw new InvalidClassFileException(offset, "negative method count: " + this.interfaceCount);
        }
        this.attrInfoOffset = offset = this.parseMethods(offset + 2, methodCount);
        this.checkLength(offset, 2);
        int attrCount = this.getUShort(offset);
        offset = this.skipAttributes(offset + 2, attrCount);
        if (offset != this.bytes.length) {
            throw new InvalidClassFileException(offset, "extra data in class file");
        }
    }

    private int skipAttributes(int offset, int count) throws InvalidClassFileException {
        if (count < 0) {
            throw new InvalidClassFileException(offset, "negative attribute count: " + this.interfaceCount);
        }
        for (int i = 0; i < count; ++i) {
            this.checkLength(offset, 6);
            int size = this.getInt(offset + 2);
            if (size < 0) {
                throw new InvalidClassFileException(offset, "negative attribute size: " + size);
            }
            this.checkLength(offset += 6, size);
            offset += size;
        }
        return offset;
    }

    private int parseFields(int offset, int count) throws InvalidClassFileException {
        this.fieldOffsets = new int[count + 1];
        for (int i = 0; i < count; ++i) {
            this.fieldOffsets[i] = offset;
            this.checkLength(offset, 8);
            offset = this.skipAttributes(offset + 8, this.getUShort(offset + 6));
        }
        this.fieldOffsets[count] = offset;
        return offset;
    }

    private int parseMethods(int offset, int count) throws InvalidClassFileException {
        this.methodOffsets = new int[count + 1];
        for (int i = 0; i < count; ++i) {
            this.methodOffsets[i] = offset;
            this.checkLength(offset, 8);
            offset = this.skipAttributes(offset + 8, this.getUShort(offset + 6));
        }
        this.methodOffsets[count] = offset;
        return offset;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getMagic() {
        return this.getInt(0);
    }

    public int getMinorVersion() {
        return this.getUShort(4);
    }

    public int getMajorVersion() {
        return this.getUShort(6);
    }

    public int getAccessFlags() {
        return this.getUShort(this.classInfoOffset);
    }

    public int getNameIndex() {
        return this.getUShort(this.classInfoOffset + 2);
    }

    String getClassFromAddress(int addr) throws InvalidClassFileException {
        int c = this.getUShort(addr);
        if (c == 0) {
            return null;
        }
        try {
            return this.cpParser.getCPClass(c);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(addr, "Invalid class constant pool index: " + c);
        }
    }

    public String getName() throws InvalidClassFileException {
        String s = this.getClassFromAddress(this.classInfoOffset + 2);
        if (s == null) {
            throw new InvalidClassFileException(this.classInfoOffset + 2, "Null class name not allowed");
        }
        return s;
    }

    public int getSuperNameIndex() {
        return this.getUShort(this.classInfoOffset + 4);
    }

    public String getSuperName() throws InvalidClassFileException {
        return this.getClassFromAddress(this.classInfoOffset + 4);
    }

    public int getInterfaceCount() {
        return this.interfaceCount;
    }

    private void verifyInterfaceIndex(int i) {
        if (i < 0 || i >= this.interfaceCount) {
            throw new IllegalArgumentException("Invalid interface index: " + i);
        }
    }

    public int getInterfaceNameIndex(int i) {
        this.verifyInterfaceIndex(i);
        return this.getUShort(this.classInfoOffset + 8 + 2 * i);
    }

    public int[] getInterfaceNameIndices() {
        int[] indices = new int[this.interfaceCount];
        for (int i = 0; i < this.interfaceCount; ++i) {
            indices[i] = this.getUShort(this.classInfoOffset + 8 + 2 * i);
        }
        return indices;
    }

    public String getInterfaceName(int i) throws InvalidClassFileException {
        this.verifyInterfaceIndex(i);
        String s = this.getClassFromAddress(this.classInfoOffset + 8 + 2 * i);
        if (s == null) {
            throw new InvalidClassFileException(this.classInfoOffset + 8 + 2 * i, "Null interface name not allowed");
        }
        return s;
    }

    public String[] getInterfaceNames() throws InvalidClassFileException {
        String[] names = new String[this.interfaceCount];
        for (int i = 0; i < this.interfaceCount; ++i) {
            String s = this.getClassFromAddress(this.classInfoOffset + 8 + 2 * i);
            if (s == null) {
                throw new InvalidClassFileException(this.classInfoOffset + 8 + 2 * i, "Null interface name not allowed");
            }
            names[i] = s;
        }
        return names;
    }

    public ConstantPoolParser getCP() {
        return this.cpParser;
    }

    public int getInt(int i) {
        return (this.bytes[i] << 24) + ((this.bytes[i + 1] & 0xFF) << 16) + ((this.bytes[i + 2] & 0xFF) << 8) + (this.bytes[i + 3] & 0xFF);
    }

    public int getUShort(int i) {
        return ((this.bytes[i] & 0xFF) << 8) + (this.bytes[i + 1] & 0xFF);
    }

    public int getShort(int i) {
        return (this.bytes[i] << 8) + (this.bytes[i + 1] & 0xFF);
    }

    public byte getByte(int i) {
        return this.bytes[i];
    }

    public int getUnsignedByte(int i) {
        return this.bytes[i] & 0xFF;
    }

    public int getFieldCount() {
        return this.fieldOffsets.length - 1;
    }

    private void verifyFieldIndex(int f) {
        if (f < 0 || f >= this.fieldOffsets.length - 1) {
            throw new IllegalArgumentException("Invalid field index: " + f);
        }
    }

    public int getFieldAccessFlags(int f) {
        this.verifyFieldIndex(f);
        return this.getUShort(this.fieldOffsets[f]);
    }

    String getUtf8FromAddress(int addr) throws InvalidClassFileException {
        int s = this.getUShort(addr);
        if (s == 0) {
            return null;
        }
        try {
            return this.cpParser.getCPUtf8(s);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(addr, "Invalid Utf8 constant pool index: " + s);
        }
    }

    public String getFieldName(int f) throws InvalidClassFileException {
        this.verifyFieldIndex(f);
        return this.getUtf8FromAddress(this.fieldOffsets[f] + 2);
    }

    public String getFieldType(int f) throws InvalidClassFileException {
        this.verifyFieldIndex(f);
        return this.getUtf8FromAddress(this.fieldOffsets[f] + 4);
    }

    public int getFieldNameIndex(int f) {
        this.verifyFieldIndex(f);
        return this.getUShort(this.fieldOffsets[f] + 2);
    }

    public int getFieldTypeIndex(int f) {
        this.verifyFieldIndex(f);
        return this.getUShort(this.fieldOffsets[f] + 4);
    }

    public void initFieldAttributeIterator(int f, AttrIterator iter) {
        if (iter == null) {
            throw new IllegalArgumentException("iter is null");
        }
        this.verifyFieldIndex(f);
        iter.init(this, this.fieldOffsets[f] + 6);
    }

    public int getFieldRawOffset(int f) {
        this.verifyFieldIndex(f);
        return this.fieldOffsets[f];
    }

    public int getFieldRawSize(int f) {
        this.verifyFieldIndex(f);
        return this.fieldOffsets[f + 1] - this.fieldOffsets[f];
    }

    public int getMethodCount() {
        return this.methodOffsets.length - 1;
    }

    private void verifyMethodIndex(int m) {
        if (m < 0 || m >= this.methodOffsets.length - 1) {
            throw new IllegalArgumentException("Invalid method index: " + m);
        }
    }

    public int getMethodRawOffset(int m) {
        this.verifyMethodIndex(m);
        return this.methodOffsets[m];
    }

    public int getMethodRawSize(int m) {
        this.verifyMethodIndex(m);
        return this.methodOffsets[m + 1] - this.methodOffsets[m];
    }

    public int getMethodAccessFlags(int m) {
        this.verifyMethodIndex(m);
        return this.getUShort(this.methodOffsets[m]);
    }

    public String getMethodName(int m) throws InvalidClassFileException {
        this.verifyMethodIndex(m);
        return this.getUtf8FromAddress(this.methodOffsets[m] + 2);
    }

    public String getMethodType(int m) throws InvalidClassFileException {
        this.verifyMethodIndex(m);
        return this.getUtf8FromAddress(this.methodOffsets[m] + 4);
    }

    public int getMethodNameIndex(int m) {
        this.verifyMethodIndex(m);
        return this.getUShort(this.methodOffsets[m] + 2);
    }

    public int getMethodTypeIndex(int m) {
        this.verifyMethodIndex(m);
        return this.getUShort(this.methodOffsets[m] + 4);
    }

    public void initMethodAttributeIterator(int m, AttrIterator iter) {
        if (iter == null) {
            throw new IllegalArgumentException("iter is null");
        }
        this.verifyMethodIndex(m);
        iter.init(this, this.methodOffsets[m] + 6);
    }

    public void initClassAttributeIterator(AttrIterator iter) {
        if (iter == null) {
            throw new IllegalArgumentException("iter is null");
        }
        iter.init(this, this.attrInfoOffset);
    }

    public static final class AttrIterator {
        ClassReader cr;
        int offset;
        int size;
        private int remaining;

        private void setSize() {
            if (this.remaining > 0) {
                this.size = 6 + this.cr.getInt(this.offset + 2);
            }
        }

        void init(ClassReader cr, int offset) {
            this.cr = cr;
            this.offset = offset + 2;
            this.remaining = cr.getUShort(offset);
            this.setSize();
        }

        void verifyValid() {
            if (this.remaining <= 0) {
                throw new IllegalArgumentException("Attempt to manipulate invalid AttrIterator");
            }
        }

        public ClassReader getClassReader() {
            this.verifyValid();
            return this.cr;
        }

        public int getRawOffset() {
            this.verifyValid();
            return this.offset;
        }

        public int getRawSize() {
            this.verifyValid();
            return this.size;
        }

        public int getDataOffset() {
            this.verifyValid();
            return this.offset + 6;
        }

        public int getDataSize() {
            this.verifyValid();
            return this.size - 6;
        }

        public int getRemainingAttributesCount() {
            return this.remaining;
        }

        public int getNameIndex() {
            this.verifyValid();
            return this.cr.getUShort(this.offset);
        }

        public String getName() throws InvalidClassFileException {
            this.verifyValid();
            String s = this.cr.getUtf8FromAddress(this.offset);
            if (s == null) {
                throw new InvalidClassFileException(this.offset, "Null attribute name");
            }
            return s;
        }

        public boolean isValid() {
            return this.remaining > 0;
        }

        public void advance() {
            this.verifyValid();
            this.offset += this.size;
            --this.remaining;
            this.setSize();
        }
    }
}

