/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.shrike.shrikeCT;

import com.ibm.wala.shrike.shrikeCT.BootstrapMethodsReader;
import com.ibm.wala.shrike.shrikeCT.ClassConstants;
import com.ibm.wala.shrike.shrikeCT.ClassReader;
import com.ibm.wala.shrike.shrikeCT.InvalidClassFileException;

public final class ConstantPoolParser
implements ClassConstants {
    private final byte[] bytes;
    private int[] cpOffsets;
    private String[] cpItems;
    private BootstrapMethodsReader invokeDynamicBootstraps;
    private static final int MAX_CP_ITEMS = 0x1FFFFFFF;

    private BootstrapMethodsReader getBootstrapReader() throws InvalidClassFileException {
        if (this.invokeDynamicBootstraps == null) {
            ClassReader thisClass = new ClassReader(this.bytes);
            ClassReader.AttrIterator attrs = new ClassReader.AttrIterator();
            thisClass.initClassAttributeIterator(attrs);
            while (attrs.isValid()) {
                if (attrs.getName().equals("BootstrapMethods")) {
                    this.invokeDynamicBootstraps = new BootstrapMethodsReader(attrs);
                    break;
                }
                attrs.advance();
            }
            assert (this.invokeDynamicBootstraps != null);
        }
        return this.invokeDynamicBootstraps;
    }

    public ConstantPoolParser(byte[] bytes, int offset, int itemCount) throws InvalidClassFileException {
        this.bytes = bytes;
        if (offset < 0) {
            throw new IllegalArgumentException("invalid offset: " + offset);
        }
        if (itemCount < 0 || itemCount > 0x1FFFFFFF) {
            throw new IllegalArgumentException("invalid itemCount: " + itemCount);
        }
        this.parseConstantPool(offset, itemCount);
    }

    public byte[] getRawBytes() {
        return this.bytes;
    }

    public int getRawOffset() throws IllegalStateException {
        if (this.cpOffsets.length < 2) {
            throw new IllegalStateException();
        }
        return this.cpOffsets[1];
    }

    public int getRawSize() throws IllegalStateException {
        if (this.cpOffsets.length < 2) {
            throw new IllegalStateException();
        }
        return this.cpOffsets[this.cpOffsets.length - 1] - this.cpOffsets[1];
    }

    public int getItemCount() {
        return this.cpOffsets.length - 1;
    }

    private void checkLength(int offset, int required) throws InvalidClassFileException {
        if (this.bytes.length < offset + required) {
            throw new InvalidClassFileException(offset, "file truncated, expected " + required + " bytes, saw only " + (this.bytes.length - offset));
        }
    }

    public byte getItemType(int i) throws IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0) {
            return 0;
        }
        return this.getByte(offset);
    }

    public String getCPClass(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 7) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Class");
        }
        String s = this.cpItems[i];
        if (s == null) {
            try {
                s = this.getCPUtf8(this.getUShort(offset + 1));
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidClassFileException(offset, "Invalid class name at constant pool item #" + i + ": " + ex.getMessage());
            }
            this.cpItems[i] = s;
        }
        return s;
    }

    public String getCPMethodType(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 16) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a MethodType");
        }
        String s = this.cpItems[i];
        if (s == null) {
            try {
                s = this.getCPUtf8(this.getUShort(offset + 1));
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidClassFileException(offset, "Invalid method type at constant pool item #" + i + ": " + ex.getMessage());
            }
            this.cpItems[i] = s;
        }
        return s;
    }

    public String getCPString(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 8) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a String");
        }
        String s = this.cpItems[i];
        if (s == null) {
            try {
                s = this.getCPUtf8(this.getUShort(offset + 1));
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidClassFileException(offset, "Invalid string at constant pool item #" + i + ": " + ex.getMessage());
            }
            this.cpItems[i] = s;
        }
        return s;
    }

    public static boolean isRef(byte b) {
        switch (b) {
            case 9: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }

    public String getCPRefClass(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || !ConstantPoolParser.isRef(this.getByte(offset))) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Ref");
        }
        try {
            return this.getCPClass(this.getUShort(offset + 1));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid Ref class at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPRefName(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || !ConstantPoolParser.isRef(this.getByte(offset))) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Ref");
        }
        try {
            return this.getCPNATName(this.getUShort(offset + 3));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid Ref NameAndType at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPRefType(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || !ConstantPoolParser.isRef(this.getByte(offset))) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Ref");
        }
        try {
            return this.getCPNATType(this.getUShort(offset + 3));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid Ref NameAndType at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPNATName(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 12) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a NameAndType");
        }
        try {
            return this.getCPUtf8(this.getUShort(offset + 1));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid NameAndType name at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPNATType(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 12) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a NameAndType");
        }
        try {
            return this.getCPUtf8(this.getUShort(offset + 3));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid NameAndType type at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPHandleName(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 15) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a MethodHandle");
        }
        try {
            return this.getCPRefName(this.getUShort(offset + 2));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid NameAndType type at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPHandleType(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 15) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a MethodHandle");
        }
        try {
            return this.getCPRefType(this.getUShort(offset + 2));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid NameAndType type at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPHandleClass(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 15) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a MethodHandle");
        }
        try {
            return this.getCPRefClass(this.getUShort(offset + 2));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid NameAndType type at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public byte getCPHandleKind(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 15) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a MethodHandle");
        }
        try {
            return this.getByte(offset + 1);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid NameAndType type at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public int getCPInt(int i) throws IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 3) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not an Integer");
        }
        return this.getInt(offset + 1);
    }

    public float getCPFloat(int i) throws IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 4) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Float");
        }
        return this.getFloat(offset + 1);
    }

    public long getCPLong(int i) throws IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 5) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Long");
        }
        return this.getLong(offset + 1);
    }

    public double getCPDouble(int i) throws IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 6) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Double");
        }
        return this.getDouble(offset + 1);
    }

    public BootstrapMethodsReader.BootstrapMethod getCPDynBootstrap(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 18) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not an InvokeDynamic");
        }
        try {
            int index = this.getUShort(offset + 1);
            return this.getBootstrapReader().getEntry(index);
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid Ref class at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPDynName(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 18) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not an InvokeDynamic");
        }
        try {
            return this.getCPNATName(this.getUShort(offset + 3));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid Ref class at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    public String getCPDynType(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 18) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not an InvokeDynamic");
        }
        try {
            return this.getCPNATType(this.getUShort(offset + 3));
        }
        catch (IllegalArgumentException ex) {
            throw new InvalidClassFileException(offset, "Invalid Ref class at constant pool item #" + i + ": " + ex.getMessage());
        }
    }

    private InvalidClassFileException invalidUtf8(int item, int offset) {
        return new InvalidClassFileException(offset, "Constant pool item #" + item + " starting at " + this.cpOffsets[item] + ", is an invalid Java Utf8 string (byte is " + this.getByte(offset) + ")");
    }

    public String getCPUtf8(int i) throws InvalidClassFileException, IllegalArgumentException {
        if (i < 1 || i >= this.cpItems.length) {
            throw new IllegalArgumentException("Constant pool item #" + i + " out of range");
        }
        int offset = this.cpOffsets[i];
        if (offset == 0 || this.getByte(offset) != 1) {
            throw new IllegalArgumentException("Constant pool item #" + i + " is not a Utf8");
        }
        String s = this.cpItems[i];
        if (s == null) {
            int count = this.getUShort(offset + 1);
            int end = count + offset + 3;
            StringBuilder buf = new StringBuilder(count);
            offset += 3;
            while (offset < end) {
                byte y;
                byte x = this.getByte(offset);
                if ((x & 0x80) == 0) {
                    if (x == 0) {
                        throw this.invalidUtf8(i, offset);
                    }
                    buf.append((char)x);
                    ++offset;
                    continue;
                }
                if ((x & 0xE0) == 192) {
                    if (offset + 1 >= end) {
                        throw this.invalidUtf8(i, offset);
                    }
                    y = this.getByte(offset + 1);
                    if ((y & 0xC0) != 128) {
                        throw this.invalidUtf8(i, offset);
                    }
                    buf.append((char)(((x & 0x1F) << 6) + (y & 0x3F)));
                    offset += 2;
                    continue;
                }
                if ((x & 0xF0) == 224) {
                    if (offset + 2 >= end) {
                        throw this.invalidUtf8(i, offset);
                    }
                    y = this.getByte(offset + 1);
                    byte z = this.getByte(offset + 2);
                    if ((y & 0xC0) != 128 || (z & 0xC0) != 128) {
                        throw this.invalidUtf8(i, offset);
                    }
                    buf.append((char)(((x & 0xF) << 12) + ((y & 0x3F) << 6) + (z & 0x3F)));
                    offset += 3;
                    continue;
                }
                throw this.invalidUtf8(i, offset);
            }
            this.cpItems[i] = s = buf.toString();
        }
        return s;
    }

    private void parseConstantPool(int offset, int itemCount) throws InvalidClassFileException {
        this.cpOffsets = new int[itemCount + 1];
        this.cpItems = new String[itemCount];
        for (int i = 1; i < itemCount; ++i) {
            int itemLen;
            this.cpOffsets[i] = offset;
            byte tag = this.getByte(offset);
            switch (tag) {
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    itemLen = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    itemLen = 4;
                    break;
                }
                case 5: 
                case 6: {
                    itemLen = 8;
                    ++i;
                    break;
                }
                case 1: {
                    itemLen = 2 + this.getUShort(offset + 1);
                    break;
                }
                case 15: {
                    itemLen = 3;
                    break;
                }
                default: {
                    throw new InvalidClassFileException(offset, "unknown constant pool entry type" + tag);
                }
            }
            this.checkLength(offset, itemLen);
            offset += itemLen + 1;
        }
        this.cpOffsets[itemCount] = offset;
    }

    private byte getByte(int i) {
        return this.bytes[i];
    }

    private int getUShort(int i) {
        return ((this.bytes[i] & 0xFF) << 8) + (this.bytes[i + 1] & 0xFF);
    }

    private int getInt(int i) {
        return (this.bytes[i] << 24) + ((this.bytes[i + 1] & 0xFF) << 16) + ((this.bytes[i + 2] & 0xFF) << 8) + (this.bytes[i + 3] & 0xFF);
    }

    private long getLong(int i) {
        return ((long)this.getInt(i) << 32) + ((long)this.getInt(i + 4) & 0xFFFFFFFFL);
    }

    private float getFloat(int i) {
        return Float.intBitsToFloat(this.getInt(i));
    }

    private double getDouble(int i) {
        return Double.longBitsToDouble(this.getLong(i));
    }

    public static class ReferenceToken {
        private final byte kind;
        private final String className;
        private final String elementName;
        private final String descriptor;

        public ReferenceToken(byte kind, String className, String elementName, String descriptor) {
            this.kind = kind;
            this.className = className;
            this.elementName = elementName;
            this.descriptor = descriptor;
        }

        public byte getKind() {
            return this.kind;
        }

        public String getClassName() {
            return this.className;
        }

        public String getElementName() {
            return this.elementName;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
            result = 31 * result + (this.descriptor == null ? 0 : this.descriptor.hashCode());
            result = 31 * result + (this.elementName == null ? 0 : this.elementName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferenceToken other = (ReferenceToken)obj;
            if (this.kind != other.kind) {
                return false;
            }
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
            if (this.descriptor == null ? other.descriptor != null : !this.descriptor.equals(other.descriptor)) {
                return false;
            }
            return !(this.elementName == null ? other.elementName != null : !this.elementName.equals(other.elementName));
        }
    }
}

