/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.ObjectVisitor;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArraySet<T>
extends AbstractSet<T> {
    private static final ArraySet EMPTY = new ArraySet<Object>(0, true){

        @Override
        public boolean add(Object obj_) {
            throw new UnsupportedOperationException();
        }
    };
    private T[] _elems;
    private int _curIndex = 0;
    private final boolean checkDupes;

    public static final <T> ArraySet<T> empty() {
        return EMPTY;
    }

    public ArraySet(int n, boolean checkDupes) {
        if (n < 0) {
            throw new IllegalArgumentException("invalid n: " + n);
        }
        this._elems = new Object[n];
        this.checkDupes = checkDupes;
    }

    public ArraySet() {
        this(1, true);
    }

    public ArraySet(ArraySet<T> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        int size = other._curIndex;
        this._elems = new Object[size];
        this.checkDupes = other.checkDupes;
        this._curIndex = size;
        System.arraycopy(other._elems, 0, this._elems, 0, size);
    }

    private ArraySet(Collection<T> other) {
        this(other.size(), true);
        ((AbstractCollection)this).addAll(other);
    }

    @Override
    public boolean add(T o) {
        if (o == null) {
            throw new IllegalArgumentException("null o");
        }
        if (this.checkDupes && this.contains(o)) {
            return false;
        }
        if (this._curIndex == this._elems.length) {
            this._elems = Arrays.copyOf(this._elems, this._elems.length * 2);
        }
        this._elems[this._curIndex] = o;
        ++this._curIndex;
        return true;
    }

    @Override
    public boolean addAll(ArraySet<T> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        boolean ret = false;
        for (int i = 0; i < other.size(); ++i) {
            boolean added = this.add(other.get(i));
            ret = ret || added;
        }
        return ret;
    }

    @Override
    public boolean contains(Object obj_) {
        for (int i = 0; i < this._curIndex; ++i) {
            if (!this._elems[i].equals(obj_)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(ArraySet<T> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        for (int i = 0; i < other.size(); ++i) {
            if (!this.contains(other.get(i))) continue;
            return true;
        }
        return false;
    }

    public void forall(ObjectVisitor<T> visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("null visitor");
        }
        for (int i = 0; i < this._curIndex; ++i) {
            visitor.visit(this._elems[i]);
        }
    }

    @Override
    public int size() {
        return this._curIndex;
    }

    public T get(int i) {
        return this._elems[i];
    }

    @Override
    public boolean remove(Object obj_) {
        int ind;
        for (ind = 0; ind < this._curIndex && !this._elems[ind].equals(obj_); ++ind) {
        }
        if (ind == this._curIndex) {
            return false;
        }
        return this.remove(ind);
    }

    public boolean remove(int ind) {
        try {
            System.arraycopy(this._elems, ind + 1, this._elems, ind, this._curIndex - (ind + 1));
            --this._curIndex;
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("invalid ind: " + ind, e);
        }
    }

    @Override
    public void clear() {
        this._curIndex = 0;
    }

    @Override
    public Iterator<T> iterator() {
        return new ArraySetIterator();
    }

    public static <T> ArraySet<T> make() {
        return new ArraySet<T>();
    }

    public static <T> ArraySet<T> make(Collection<T> other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        return new ArraySet<T>(other);
    }

    public class ArraySetIterator
    implements Iterator<T> {
        int ind = 0;
        final int setSize = ArraySet.this.size();

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.ind < this.setSize;
        }

        @Override
        public T next() {
            if (this.ind >= this.setSize) {
                throw new NoSuchElementException();
            }
            return ArraySet.this.get(this.ind++);
        }
    }
}

