/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.collections;

import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.MapIterator;
import java.util.Iterator;

public class IteratorUtil {
    public static <T> boolean contains(Iterator<? extends T> it, T o) {
        if (it == null) {
            throw new IllegalArgumentException("null it");
        }
        while (it.hasNext()) {
            if (!o.equals(it.next())) continue;
            return true;
        }
        return false;
    }

    public static final <T> int count(Iterator<T> it) throws IllegalArgumentException {
        if (it == null) {
            throw new IllegalArgumentException("it == null");
        }
        int count = 0;
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        return count;
    }

    public static <T, S extends T> Iterator<S> filter(Iterator<T> iterator, Class<S> cls) {
        return new MapIterator<Object, Object>(new FilterIterator<Object>(iterator, cls::isInstance), cls::cast);
    }
}

