/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.dominators;

import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.NonNullSingletonIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.AbstractGraph;
import com.ibm.wala.util.graph.EdgeManager;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.NodeManager;
import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.graph.dominators.GenericDominators;
import com.ibm.wala.util.graph.dominators.NumberedDominators;
import com.ibm.wala.util.graph.traverse.SlowDFSDiscoverTimeIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class Dominators<T> {
    static final boolean DEBUG = false;
    private final T[] vertex;
    protected final Graph<T> G;
    protected final T root;
    protected int reachableNodeCount = 0;

    public Dominators(Graph<T> G, T root) throws IllegalArgumentException {
        if (G == null) {
            throw new IllegalArgumentException("G is null");
        }
        this.G = G;
        this.root = root;
        if (G.getNumberOfNodes() == 0) {
            throw new IllegalArgumentException("G has no nodes");
        }
        this.vertex = new Object[G.getNumberOfNodes() + 1];
    }

    public static <T> Dominators<T> make(Graph<T> G, T root) {
        if (G instanceof NumberedGraph) {
            return new NumberedDominators<T>((NumberedGraph)G, root);
        }
        return new GenericDominators<T>(G, root);
    }

    public boolean isDominatedBy(T node, T master) {
        T ptr = node;
        while (ptr != null) {
            if (ptr.equals(master)) {
                return true;
            }
            ptr = this.getIdom(ptr);
        }
        return false;
    }

    public T getIdom(T node) {
        return (T)this.getInfo(node).dominator;
    }

    public Iterator<T> dominators(final T node) {
        return new Iterator<T>(){
            private T current;
            {
                this.current = node;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public T next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object nextNode = this.current;
                this.current = Dominators.this.getIdom(this.current);
                return nextNode;
            }
        };
    }

    public Graph<T> dominatorTree() {
        return new AbstractGraph<T>(){
            private final EdgeManager<T> edges = new EdgeManager<T>(){
                private final Map<T, Set<T>> nextMap = HashMapFactory.make();
                {
                    for (Object n : Dominators.this.G) {
                        if (n == Dominators.this.root) continue;
                        Object prev = Dominators.this.getIdom(n);
                        Set next = this.nextMap.get(prev);
                        if (next == null) {
                            next = HashSetFactory.make(2);
                            this.nextMap.put(prev, next);
                        }
                        next.add(n);
                    }
                }

                @Override
                public Iterator<T> getPredNodes(T N) {
                    if (N == Dominators.this.root) {
                        return EmptyIterator.instance();
                    }
                    return new NonNullSingletonIterator(Dominators.this.getIdom(N));
                }

                @Override
                public int getPredNodeCount(Object N) {
                    return N == Dominators.this.root ? 0 : 1;
                }

                @Override
                public Iterator<T> getSuccNodes(Object N) {
                    if (this.nextMap.containsKey(N)) {
                        return this.nextMap.get(N).iterator();
                    }
                    return EmptyIterator.instance();
                }

                @Override
                public int getSuccNodeCount(Object N) {
                    if (this.nextMap.containsKey(N)) {
                        return this.nextMap.get(N).size();
                    }
                    return 0;
                }

                @Override
                public void addEdge(Object src, Object dst) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeEdge(Object src, Object dst) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeAllIncidentEdges(Object node) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeIncomingEdges(Object node) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public void removeOutgoingEdges(Object node) {
                    Assertions.UNREACHABLE();
                }

                @Override
                public boolean hasEdge(Object src, Object dst) {
                    Assertions.UNREACHABLE();
                    return false;
                }
            };

            @Override
            protected NodeManager<T> getNodeManager() {
                return Dominators.this.G;
            }

            @Override
            protected EdgeManager<T> getEdgeManager() {
                return this.edges;
            }
        };
    }

    protected void analyze() {
        this.step1();
        this.step2();
        this.step3();
    }

    private void step1() {
        this.reachableNodeCount = 0;
        SlowDFSDiscoverTimeIterator dfs = new SlowDFSDiscoverTimeIterator<T>(this.G, this.root){
            public static final long serialVersionUID = 88831771771711L;

            @Override
            protected void visitEdge(T from, T to) {
                Dominators.this.setParent(to, from);
            }
        };
        while (dfs.hasNext()) {
            Object node = dfs.next();
            assert (node != null);
            this.vertex[++this.reachableNodeCount] = node;
            this.setSemi(node, this.reachableNodeCount);
        }
    }

    private void step2() {
        for (int i = this.reachableNodeCount; i > 1; --i) {
            T node = this.vertex[i];
            Iterator<T> e = this.G.getPredNodes(node);
            while (e.hasNext()) {
                T prev = e.next();
                T u = this.EVAL(prev);
                if (this.getSemi(u) == 0 || this.getSemi(u) >= this.getSemi(node)) continue;
                this.setSemi(node, this.getSemi(u));
            }
            this.addToBucket(this.vertex[this.getSemi(node)], node);
            this.LINK(this.getParent(node), node);
            Iterator<T> bucketEnum = this.iterateBucket(this.getParent(node));
            while (bucketEnum.hasNext()) {
                T node2 = bucketEnum.next();
                T u = this.EVAL(node2);
                if (this.getSemi(u) < this.getSemi(node2)) {
                    this.setDominator(node2, u);
                    continue;
                }
                this.setDominator(node2, this.getParent(node));
            }
        }
    }

    private T EVAL(T node) {
        if (this.getAncestor(node) == null) {
            return this.getLabel(node);
        }
        this.compress(node);
        if (this.getSemi(this.getLabel(this.getAncestor(node))) >= this.getSemi(this.getLabel(node))) {
            return this.getLabel(node);
        }
        return this.getLabel(this.getAncestor(node));
    }

    private void compress(T node) {
        if (this.getAncestor(this.getAncestor(node)) != null) {
            this.compress(this.getAncestor(node));
            if (this.getSemi(this.getLabel(this.getAncestor(node))) < this.getSemi(this.getLabel(node))) {
                this.setLabel(node, this.getLabel(this.getAncestor(node)));
            }
            this.setAncestor(node, this.getAncestor(this.getAncestor(node)));
        }
    }

    private void LINK(T node1, T node2) {
        T s = node2;
        while (this.getSemi(this.getLabel(node2)) < this.getSemi(this.getLabel(this.getChild(s)))) {
            if (this.getSize(s) + this.getSize(this.getChild(this.getChild(s))) >= 2 * this.getSize(this.getChild(s))) {
                this.setAncestor(this.getChild(s), s);
                this.setChild(s, this.getChild(this.getChild(s)));
                continue;
            }
            this.setSize(this.getChild(s), this.getSize(s));
            this.setAncestor(s, this.getChild(s));
            s = this.getChild(s);
        }
        this.setLabel(s, this.getLabel(node2));
        this.setSize(node1, this.getSize(node1) + this.getSize(node2));
        if (this.getSize(node1) < 2 * this.getSize(node2)) {
            T tmp = s;
            s = this.getChild(node1);
            this.setChild(node1, tmp);
        }
        while (s != null) {
            this.setAncestor(s, node1);
            s = this.getChild(s);
        }
    }

    private void step3() {
        for (int i = 2; i <= this.reachableNodeCount; ++i) {
            T node = this.vertex[i];
            if (this.getDominator(node) == this.vertex[this.getSemi(node)]) continue;
            this.setDominator(node, this.getDominator(this.getDominator(node)));
        }
    }

    protected abstract DominatorInfo getInfo(T var1);

    private Iterator<T> iterateBucket(T node) {
        return this.getInfo(node).bucket.iterator();
    }

    private void addToBucket(T node, T addend) {
        this.getInfo(node).bucket.add(addend);
    }

    private T getDominator(T node) {
        assert (node != null);
        return (T)this.getInfo(node).dominator;
    }

    private void setDominator(T node, T dominator) {
        this.getInfo(node).dominator = dominator;
    }

    private T getParent(T node) {
        return (T)this.getInfo(node).parent;
    }

    private void setParent(T node, T parent) {
        this.getInfo(node).parent = parent;
    }

    private T getAncestor(T node) {
        return (T)this.getInfo(node).ancestor;
    }

    private void setAncestor(T node, T ancestor) {
        this.getInfo(node).ancestor = ancestor;
    }

    private T getLabel(T node) {
        if (node == null) {
            return null;
        }
        return (T)this.getInfo(node).label;
    }

    private void setLabel(T node, T label) {
        this.getInfo(node).label = label;
    }

    private int getSize(T node) {
        if (node == null) {
            return 0;
        }
        return this.getInfo(node).size;
    }

    private void setSize(T node, int size) {
        this.getInfo(node).size = size;
    }

    private T getChild(T node) {
        return (T)this.getInfo(node).child;
    }

    private void setChild(T node, T child) {
        this.getInfo(node).child = child;
    }

    private int getSemi(T node) {
        if (node == null) {
            return 0;
        }
        return this.getInfo(node).semiDominator;
    }

    private void setSemi(T node, int semi) {
        this.getInfo(node).semiDominator = semi;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Object node : this.G) {
            sb.append("Dominators of ").append(node).append(":\n");
            for (Object dom : Iterator2Iterable.make(this.dominators(node))) {
                sb.append("   ").append(dom).append('\n');
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    protected final class DominatorInfo {
        private T dominator = null;
        private T parent = null;
        private int semiDominator = 0;
        private final Set<T> bucket = HashSetFactory.make();
        private T label;
        private T ancestor = null;
        private int size;
        private T child;

        DominatorInfo(T node) {
            this.label = node;
            this.size = 1;
            this.child = null;
        }
    }
}

