/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.intset;

import com.ibm.wala.util.intset.BitVectorBase;

public final class OffsetBitVector
extends BitVectorBase<OffsetBitVector> {
    private static final long serialVersionUID = -5846568678514886375L;
    int offset;

    private static int wordDiff(int offset1, int offset2) {
        return offset1 > offset2 ? offset1 - offset2 >> 5 : -(offset2 - offset1 >> 5);
    }

    private void expand(int newOffset, int newCapacity) {
        int wordDiff = OffsetBitVector.wordDiff(newOffset, this.offset);
        int[] oldbits = this.bits;
        this.bits = new int[OffsetBitVector.subscript(newCapacity) + 1];
        System.arraycopy(oldbits, 0, this.bits, 0 - wordDiff, oldbits.length);
        this.offset = newOffset;
    }

    private void ensureCapacity(int newOffset, int newCapacity) {
        if (newOffset < this.offset || newCapacity > this.bits.length << 5) {
            this.expand(newOffset, newCapacity);
        }
    }

    public OffsetBitVector() {
        this(0, 1);
    }

    public OffsetBitVector(int offset, int nbits) {
        if (nbits < 0) {
            throw new IllegalArgumentException("invalid nbits: " + nbits);
        }
        if (offset < 0) {
            throw new IllegalArgumentException("invalid offset: " + offset);
        }
        this.offset = offset &= 0xFFFFFFE0;
        this.bits = new int[OffsetBitVector.subscript(nbits) + 1];
    }

    public OffsetBitVector(OffsetBitVector s) {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        this.offset = s.offset;
        this.bits = (int[])s.bits.clone();
    }

    @Override
    public String toString() {
        return super.toString() + "(offset:" + this.offset + ')';
    }

    void growCapacity(float fraction) {
        this.expand(this.offset, (int)(fraction * (float)(this.bits.length << 5)));
    }

    public int getOffset() {
        return this.offset;
    }

    int getSize() {
        return this.bits.length;
    }

    @Override
    public final void set(int bit) {
        int subscript;
        int shiftBits;
        if (bit < 0) {
            throw new IllegalArgumentException("illegal bit: " + bit);
        }
        if (bit < this.offset) {
            int newOffset = bit & 0xFFFFFFE0;
            this.expand(newOffset, this.length() - 1 - newOffset);
            shiftBits = bit & 0x1F;
            subscript = 0;
        } else {
            shiftBits = (bit -= this.offset) & 0x1F;
            subscript = OffsetBitVector.subscript(bit);
            if (subscript >= this.bits.length) {
                this.expand(this.offset, bit);
            }
        }
        try {
            int n = subscript;
            this.bits[n] = this.bits[n] | 1 << shiftBits;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    @Override
    public final void clear(int bit) {
        if (bit < this.offset) {
            return;
        }
        int ss = OffsetBitVector.subscript(bit -= this.offset);
        if (ss >= this.bits.length) {
            return;
        }
        int shiftBits = bit & 0x1F;
        int n = ss;
        this.bits[n] = this.bits[n] & ~(1 << shiftBits);
    }

    @Override
    public final boolean get(int bit) {
        if (bit < this.offset) {
            return false;
        }
        int ss = OffsetBitVector.subscript(bit -= this.offset);
        if (ss >= this.bits.length) {
            return false;
        }
        int shiftBits = bit & 0x1F;
        return (this.bits[ss] & 1 << shiftBits) != 0;
    }

    @Override
    public int nextSetBit(int start) {
        int nb = super.nextSetBit(Math.max(0, start - this.offset));
        return nb == -1 ? -1 : this.offset + nb;
    }

    public final void not() {
        if (this.offset != 0) {
            this.expand(0, this.offset + this.length() - 1);
        }
        int i = 0;
        while (i < this.bits.length) {
            int n = i++;
            this.bits[n] = ~this.bits[n];
        }
    }

    @Override
    public int max() {
        return super.max() + this.offset;
    }

    @Override
    public final int length() {
        return (this.bits.length << 5) + this.offset;
    }

    public final void setAll() {
        this.expand(0, this.length() - 1);
        for (int i = 0; i < this.bits.length; ++i) {
            this.bits[i] = -1;
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof OffsetBitVector) {
            if (this == obj) {
                return true;
            }
            OffsetBitVector set = (OffsetBitVector)obj;
            return this.sameBits(set);
        }
        return false;
    }

    @Override
    public final boolean intersectionEmpty(OffsetBitVector set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == set) {
            return this.isZero();
        }
        int wordDiff = OffsetBitVector.wordDiff(this.offset, set.offset);
        int maxWord = Math.min(this.bits.length, set.bits.length - wordDiff);
        for (int i = Math.max(0, -wordDiff); i < maxWord; ++i) {
            if ((this.bits[i] & set.bits[i + wordDiff]) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean sameBits(OffsetBitVector set) throws IllegalArgumentException {
        int j;
        int i;
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == set) {
            return true;
        }
        int wordDiff = OffsetBitVector.wordDiff(this.offset, set.offset);
        int maxWord = Math.min(this.bits.length, set.bits.length - wordDiff);
        if (wordDiff < 0) {
            for (i = 0; i < -wordDiff; ++i) {
                if (this.bits[i] == 0) continue;
                return false;
            }
        } else {
            for (j = 0; j < wordDiff; ++j) {
                if (set.bits[j] == 0) continue;
                return false;
            }
        }
        while (i < maxWord) {
            if (this.bits[i] != set.bits[i + wordDiff]) {
                return false;
            }
            ++i;
        }
        for (j = maxWord + wordDiff; j < set.bits.length; ++j) {
            if (set.bits[j] == 0) continue;
            return false;
        }
        while (i < this.bits.length) {
            if (this.bits[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean isSubset(OffsetBitVector other) throws IllegalArgumentException {
        int i;
        if (other == null) {
            throw new IllegalArgumentException("other == null");
        }
        if (this == other) {
            return true;
        }
        int wordDiff = OffsetBitVector.wordDiff(this.offset, other.offset);
        int maxWord = Math.min(this.bits.length, other.bits.length - wordDiff);
        for (i = 0; i < -wordDiff; ++i) {
            if (this.bits[i] == 0) continue;
            return false;
        }
        while (i < maxWord) {
            if ((this.bits[i] & ~other.bits[i + wordDiff]) != 0) {
                return false;
            }
            ++i;
        }
        while (i < this.bits.length) {
            if (this.bits[i] != 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public final void copyBits(OffsetBitVector set) {
        if (set == null) {
            throw new IllegalArgumentException("set is null");
        }
        super.copyBits(set);
        this.offset = set.offset;
    }

    @Override
    public final void and(OffsetBitVector set) throws IllegalArgumentException {
        int i;
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == set) {
            return;
        }
        int wordDiff = OffsetBitVector.wordDiff(this.offset, set.offset);
        int maxWord = Math.min(this.bits.length, set.bits.length - wordDiff);
        for (i = 0; i < -wordDiff; ++i) {
            this.bits[i] = 0;
        }
        while (i < maxWord) {
            int n = i;
            this.bits[n] = this.bits[n] & set.bits[i + wordDiff];
            ++i;
        }
        while (i < this.bits.length) {
            this.bits[i] = 0;
            ++i;
        }
    }

    @Override
    public final void or(OffsetBitVector set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == set) {
            return;
        }
        int newOffset = Math.min(this.offset, set.offset);
        int newCapacity = Math.max(this.length(), set.length()) - newOffset;
        this.ensureCapacity(newOffset, newCapacity);
        int wordDiff = OffsetBitVector.wordDiff(newOffset, set.offset);
        for (int i = 0; i < set.bits.length; ++i) {
            int n = i - wordDiff;
            this.bits[n] = this.bits[n] | set.bits[i];
        }
    }

    @Override
    public final void xor(OffsetBitVector set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == set) {
            this.clearAll();
            return;
        }
        int newOffset = Math.min(this.offset, set.offset);
        int newCapacity = Math.max(this.length(), set.length()) - newOffset;
        this.ensureCapacity(newOffset, newCapacity);
        int wordDiff = OffsetBitVector.wordDiff(newOffset, set.offset);
        for (int i = 0; i < set.bits.length; ++i) {
            int n = i - wordDiff;
            this.bits[n] = this.bits[n] ^ set.bits[i];
        }
    }

    @Override
    public void andNot(OffsetBitVector set) throws IllegalArgumentException {
        if (set == null) {
            throw new IllegalArgumentException("set == null");
        }
        if (this == set) {
            this.clearAll();
            return;
        }
        int wordDiff = OffsetBitVector.wordDiff(this.offset, set.offset);
        int maxWord = Math.min(this.bits.length, set.bits.length - wordDiff);
        for (int i = Math.max(0, -wordDiff); i < maxWord; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] & ~set.bits[i + wordDiff];
        }
    }

    public static OffsetBitVector not(OffsetBitVector s) {
        OffsetBitVector b = new OffsetBitVector(s);
        b.not();
        return b;
    }

    public static OffsetBitVector and(OffsetBitVector b1, OffsetBitVector b2) throws IllegalArgumentException {
        if (b2 == null) {
            throw new IllegalArgumentException("b2 == null");
        }
        OffsetBitVector b = new OffsetBitVector(b1);
        b.and(b2);
        return b;
    }

    public static OffsetBitVector or(OffsetBitVector b1, OffsetBitVector b2) throws IllegalArgumentException {
        if (b2 == null) {
            throw new IllegalArgumentException("b2 == null");
        }
        OffsetBitVector b = new OffsetBitVector(b1);
        b.or(b2);
        return b;
    }

    public static OffsetBitVector andNot(OffsetBitVector b1, OffsetBitVector b2) {
        OffsetBitVector b = new OffsetBitVector(b1);
        b.andNot(b2);
        return b;
    }
}

