/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.processes;

import com.ibm.wala.util.processes.Launcher;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.logging.Logger;

public class BasicLauncher
extends Launcher {
    protected String cmd;

    public BasicLauncher(boolean captureOutput, boolean captureErr, Logger logger) {
        super(captureOutput, captureErr, logger);
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String newCmd) {
        this.cmd = newCmd;
    }

    @Override
    public String toString() {
        return super.toString() + " (cmd: " + this.cmd;
    }

    public int launch() throws IllegalArgumentException, IOException {
        Launcher.Drainer d;
        Thread d2;
        Process p = this.spawnProcess(this.getCmd());
        Thread d1 = this.isCaptureErr() ? this.captureStdErr(p) : this.drainStdErr(p);
        Thread thread = d2 = this.isCaptureOutput() ? this.captureStdOut(p) : this.drainStdOut(p);
        if (this.getInput() != null) {
            try (BufferedOutputStream input = new BufferedOutputStream(p.getOutputStream());){
                input.write(this.getInput(), 0, this.getInput().length);
                input.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new IOException("error priming stdin", e);
            }
        }
        try {
            d1.join();
            d2.join();
        }
        catch (InterruptedException e) {
            throw new Error("Internal error", e);
        }
        if (this.isCaptureErr()) {
            d = (Launcher.Drainer)d1;
            this.setStdErr(d.getCapture().toByteArray());
        }
        if (this.isCaptureOutput()) {
            d = (Launcher.Drainer)d2;
            this.setStdOut(d.getCapture().toByteArray());
        }
        return p.exitValue();
    }
}

