/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.labeled;

import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.SlowNumberedNodeManager;
import com.ibm.wala.util.graph.labeled.AbstractNumberedLabeledGraph;
import com.ibm.wala.util.graph.labeled.LabeledGraph;
import com.ibm.wala.util.graph.labeled.NumberedLabeledEdgeManager;
import com.ibm.wala.util.graph.labeled.SparseNumberedLabeledEdgeManager;

public class SlowSparseNumberedLabeledGraph<T, U>
extends AbstractNumberedLabeledGraph<T, U> {
    private final SlowNumberedNodeManager<T> nodeManager;
    private final SparseNumberedLabeledEdgeManager<T, U> edgeManager;

    public static <T, U> SlowSparseNumberedLabeledGraph<T, U> duplicate(LabeledGraph<T, U> g) {
        SlowSparseNumberedLabeledGraph result = new SlowSparseNumberedLabeledGraph(g.getDefaultLabel());
        SlowSparseNumberedLabeledGraph.copyInto(g, result);
        return result;
    }

    public static <T, U> void copyInto(LabeledGraph<T, U> g, LabeledGraph<T, U> into) {
        if (g == null) {
            throw new IllegalArgumentException("g is null");
        }
        for (Object name : g) {
            into.addNode(name);
        }
        for (Object n : g) {
            for (Object s : Iterator2Iterable.make(g.getSuccNodes(n))) {
                for (Object l : g.getEdgeLabels(n, s)) {
                    into.addEdge(n, s, l);
                }
            }
        }
    }

    public SlowSparseNumberedLabeledGraph(U defaultLabel) {
        if (defaultLabel == null) {
            throw new IllegalArgumentException("null default label");
        }
        this.nodeManager = new SlowNumberedNodeManager();
        this.edgeManager = new SparseNumberedLabeledEdgeManager<T, U>(this.nodeManager, defaultLabel);
    }

    @Override
    protected NumberedLabeledEdgeManager<T, U> getEdgeManager() {
        return this.edgeManager;
    }

    @Override
    protected NumberedNodeManager<T> getNodeManager() {
        return this.nodeManager;
    }
}

