/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util.graph.traverse;

import com.ibm.wala.util.graph.NumberedGraph;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntSetUtil;
import com.ibm.wala.util.intset.MutableIntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class FloydWarshall<T> {
    protected final NumberedGraph<T> G;

    public FloydWarshall(NumberedGraph<T> g) {
        this.G = g;
    }

    protected int edgeCost() {
        return 1;
    }

    protected void pathCallback(int i, int j, int k) {
    }

    public int[][] allPairsShortestPaths() {
        int[][] result = new int[this.G.getNumberOfNodes()][this.G.getNumberOfNodes()];
        for (int[] ints : result) {
            Arrays.fill(ints, Integer.MAX_VALUE);
        }
        Object object = this.G.iterator();
        while (object.hasNext()) {
            Object from = object.next();
            int fn = this.G.getNumber(from);
            IntSet tos = this.G.getSuccNodeNumbers(from);
            tos.foreach(x -> {
                result[fn][x] = this.edgeCost();
            });
        }
        for (Object kn : this.G) {
            int k = this.G.getNumber(kn);
            for (Object in : this.G) {
                int i = this.G.getNumber(in);
                for (Object jn : this.G) {
                    int j = this.G.getNumber(jn);
                    long newLen = (long)result[i][k] + (long)result[k][j];
                    if (newLen <= (long)result[i][j]) {
                        this.pathCallback(i, j, k);
                    }
                    if (newLen >= (long)result[i][j]) continue;
                    result[i][j] = (int)newLen;
                }
            }
        }
        return result;
    }

    public static <T> int[][] shortestPathLengths(NumberedGraph<T> G) {
        return new FloydWarshall<T>(G).allPairsShortestPaths();
    }

    public static <T> GetPath<T> allPairsShortestPath(NumberedGraph<T> G) {
        return (new FloydWarshall<T>((NumberedGraph)G){
            int[][] next;
            {
                this.next = new int[this.G.getNumberOfNodes()][this.G.getNumberOfNodes()];
            }

            @Override
            protected void pathCallback(int i, int j, int k) {
                this.next[i][j] = k;
            }

            private GetPath<T> doit() {
                for (int[] ints : this.next) {
                    Arrays.fill(ints, -1);
                }
                final int[][] paths = this.allPairsShortestPaths();
                return new GetPath<T>(){

                    public String toString() {
                        StringBuilder s = new StringBuilder();
                        for (int i = 0; i <= G.getMaxNumber(); ++i) {
                            for (int j = 0; j <= G.getMaxNumber(); ++j) {
                                try {
                                    s.append(this.getPath(G.getNode(i), G.getNode(j)));
                                    continue;
                                }
                                catch (UnsupportedOperationException unsupportedOperationException) {
                                    // empty catch block
                                }
                            }
                        }
                        return s.toString();
                    }

                    @Override
                    public List<T> getPath(T from, T to) {
                        int tn;
                        int fn = G.getNumber(from);
                        if (paths[fn][tn = G.getNumber(to)] == Integer.MAX_VALUE) {
                            throw new UnsupportedOperationException("no path from " + from + " to " + to);
                        }
                        int intermediate = next[fn][tn];
                        if (intermediate == -1) {
                            return Collections.emptyList();
                        }
                        Object in = G.getNode(intermediate);
                        LinkedList result = new LinkedList(this.getPath(from, in));
                        result.add(in);
                        result.addAll(this.getPath(in, to));
                        return result;
                    }
                };
            }
        }).doit();
    }

    public static <T> GetPaths<T> allPairsShortestPaths(NumberedGraph<T> G) {
        return (new FloydWarshall<T>((NumberedGraph)G){
            MutableIntSet[][] next;
            {
                this.next = new MutableIntSet[this.G.getNumberOfNodes()][this.G.getNumberOfNodes()];
            }

            @Override
            protected void pathCallback(int i, int j, int k) {
                if (this.next[i][j] == null) {
                    this.next[i][j] = IntSetUtil.make();
                }
                this.next[i][j].add(k);
            }

            private GetPaths<T> doit() {
                final int[][] paths = this.allPairsShortestPaths();
                return new GetPaths<T>(){

                    public String toString() {
                        ArrayList x = new ArrayList();
                        for (int i = 0; i <= G.getMaxNumber(); ++i) {
                            for (int j = 0; j <= G.getMaxNumber(); ++j) {
                                try {
                                    x.add(this.getPaths(G.getNode(i), G.getNode(j)));
                                    continue;
                                }
                                catch (UnsupportedOperationException unsupportedOperationException) {
                                    // empty catch block
                                }
                            }
                        }
                        return ((Object)x).toString();
                    }

                    @Override
                    public Set<List<T>> getPaths(T from, T to) {
                        int tn;
                        int fn = G.getNumber(from);
                        if (paths[fn][tn = G.getNumber(to)] == Integer.MAX_VALUE) {
                            throw new UnsupportedOperationException("no path from " + from + " to " + to);
                        }
                        MutableIntSet intermediate = next[fn][tn];
                        if (intermediate == null) {
                            List none = Collections.emptyList();
                            return Collections.singleton(none);
                        }
                        HashSet result = new HashSet();
                        intermediate.foreach(x -> {
                            Object in = G.getNode(x);
                            for (List pre : this.getPaths(from, in)) {
                                for (List post : this.getPaths(in, to)) {
                                    LinkedList path = new LinkedList(pre);
                                    path.add(in);
                                    path.addAll(post);
                                    result.add(path);
                                }
                            }
                        });
                        return result;
                    }
                };
            }
        }).doit();
    }

    public static interface GetPaths<T> {
        public Set<List<T>> getPaths(T var1, T var2);
    }

    public static interface GetPath<T> {
        public List<T> getPath(T var1, T var2);
    }
}

