/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.util;

import com.ibm.wala.util.CancelException;

public class MonitorUtil {
    public static void beginTask(IProgressMonitor monitor, String task, int totalWork) throws CancelException {
        if (monitor != null) {
            monitor.beginTask(task, totalWork);
            if (monitor.isCanceled()) {
                throw CancelException.make("cancelled in " + task);
            }
        }
    }

    public static void done(IProgressMonitor monitor) throws CancelException {
        if (monitor != null) {
            monitor.done();
            if (monitor.isCanceled()) {
                throw CancelException.make("cancelled in " + monitor);
            }
        }
    }

    public static void worked(IProgressMonitor monitor, int units) throws CancelException {
        if (monitor != null) {
            monitor.worked(units);
            if (monitor.isCanceled()) {
                throw CancelException.make("cancelled in " + monitor);
            }
        }
    }

    public static void throwExceptionIfCanceled(IProgressMonitor progressMonitor) throws CancelException {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw CancelException.make(progressMonitor.getCancelMessage());
        }
    }

    public static void subTask(IProgressMonitor progressMonitor, String subTask) throws CancelException {
        if (progressMonitor != null) {
            progressMonitor.subTask(subTask);
            if (progressMonitor.isCanceled()) {
                throw CancelException.make("cancelled in " + subTask);
            }
        }
    }

    public static boolean isCanceled(IProgressMonitor progressMonitor) {
        if (progressMonitor == null) {
            return false;
        }
        return progressMonitor.isCanceled();
    }

    public static void cancel(IProgressMonitor progress) {
        if (progress != null) {
            progress.cancel();
        }
    }

    public static interface IProgressMonitor {
        public static final int UNKNOWN = -1;

        public void beginTask(String var1, int var2);

        public void subTask(String var1);

        public void cancel();

        public boolean isCanceled();

        public void done();

        public void worked(int var1);

        public String getCancelMessage();
    }
}

